/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.mapping.def;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hasor.cobble.function.Property;
import net.hasor.cobble.ref.LinkedCaseInsensitiveMap;
import net.hasor.dbvisitor.mapping.def.ColumnDef;
import net.hasor.dbvisitor.mapping.def.ColumnMapping;
import net.hasor.dbvisitor.mapping.def.IndexDescription;
import net.hasor.dbvisitor.mapping.def.TableDescription;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;
import net.hasor.dbvisitor.types.UnknownTypeHandler;

public class TableDef<T>
implements TableMapping<T> {
    private String catalog;
    private String schema;
    private String table;
    private final Class<T> entityType;
    private final boolean autoProperty;
    private final boolean useDelimited;
    private final boolean caseInsensitive;
    private final boolean mapUnderscoreToCamelCase;
    private TableDescription description;
    private final boolean mapBased;
    private final List<ColumnMapping> columnMappings;
    private final Map<String, ColumnMapping> mapByProperty;
    private final Map<String, ColumnMapping> mapByColumn;
    private final List<IndexDescription> indexList;

    public TableDef(String catalog, String schema, String table, Class<T> entityType, boolean autoProperty, boolean useDelimited, boolean caseInsensitive, boolean mapUnderscoreToCamelCase) {
        this.catalog = catalog;
        this.schema = schema;
        this.table = table;
        this.entityType = entityType;
        this.autoProperty = autoProperty;
        this.useDelimited = useDelimited;
        this.caseInsensitive = caseInsensitive;
        this.mapBased = Map.class.isAssignableFrom(entityType);
        this.columnMappings = new ArrayList<ColumnMapping>();
        this.mapByProperty = caseInsensitive && Map.class.isAssignableFrom(entityType) ? new LinkedCaseInsensitiveMap() : new HashMap();
        this.mapByColumn = caseInsensitive ? new LinkedCaseInsensitiveMap() : new HashMap();
        this.indexList = new ArrayList<IndexDescription>();
        this.mapUnderscoreToCamelCase = mapUnderscoreToCamelCase;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Override
    public Class<T> entityType() {
        return this.entityType;
    }

    @Override
    public boolean isAutoProperty() {
        return this.autoProperty;
    }

    @Override
    public boolean useDelimited() {
        return this.useDelimited;
    }

    @Override
    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public boolean isToCamelCase() {
        return this.mapUnderscoreToCamelCase;
    }

    public boolean isMapUnderscoreToCamelCase() {
        return this.mapUnderscoreToCamelCase;
    }

    @Override
    public boolean isMapEntity() {
        return this.mapBased;
    }

    @Override
    public Collection<ColumnMapping> getProperties() {
        return this.columnMappings;
    }

    public void addMapping(ColumnMapping mapping) {
        String columnName = mapping.getColumn();
        String propertyName = mapping.getProperty();
        if (this.mapByColumn.containsKey(columnName) && this.mapByProperty.containsKey(propertyName)) {
            throw new IllegalStateException("mapping already added.");
        }
        this.mapByColumn.put(columnName, mapping);
        this.mapByProperty.put(propertyName, mapping);
        this.columnMappings.add(mapping);
    }

    @Override
    public ColumnMapping getPropertyByColumn(String column) {
        if (this.mapByColumn.containsKey(column)) {
            return this.mapByColumn.get(column);
        }
        if (this.mapBased) {
            return this.initOrGetMapMapping(this.mapByColumn, column);
        }
        return null;
    }

    @Override
    public ColumnMapping getPropertyByName(String property) {
        if (this.mapByProperty.containsKey(property)) {
            return this.mapByProperty.get(property);
        }
        if (this.mapBased) {
            return this.initOrGetMapMapping(this.mapByProperty, property);
        }
        return null;
    }

    @Override
    public TableDescription getDescription() {
        return this.description;
    }

    public void setDescription(TableDescription description) {
        this.description = description;
    }

    @Override
    public List<IndexDescription> getIndexes() {
        return this.indexList;
    }

    public void addIndexDescription(IndexDescription index) {
        this.indexList.add(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColumnMapping initOrGetMapMapping(Map<String, ColumnMapping> map, String name) {
        if (map.containsKey(name)) {
            return map.get(name);
        }
        TableDef tableDef = this;
        synchronized (tableDef) {
            if (map.containsKey(name)) {
                return map.get(name);
            }
            Class<Object> javaType = Object.class;
            int jdbcType = TypeHandlerRegistry.toSqlType(javaType);
            UnknownTypeHandler typeHandler = TypeHandlerRegistry.DEFAULT.getDefaultTypeHandler();
            ColumnDef columnDef = new ColumnDef(name, name, jdbcType, javaType, typeHandler, new MapProperty(name), true, true, false);
            this.mapByColumn.put(name, columnDef);
            return columnDef;
        }
    }

    private final class MapProperty
    implements Property {
        private final String name;

        public MapProperty(String name) {
            this.name = name;
        }

        public boolean isReadOnly() {
            return false;
        }

        public Object get(Object instance) {
            return ((Map)instance).get(this.name);
        }

        public void set(Object instance, Object value) {
            ((Map)instance).put(this.name, value);
        }
    }
}

