/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.mapping.reader;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.hasor.dbvisitor.jdbc.ResultSetExtractor;
import net.hasor.dbvisitor.jdbc.mapper.ColumnMapRowMapper;
import net.hasor.dbvisitor.mapping.TableReader;
import net.hasor.dbvisitor.types.TypeHandler;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;
import net.hasor.dbvisitor.types.UnknownTypeHandler;

public class ResultTableReader
extends ColumnMapRowMapper
implements TableReader<Map<String, Object>>,
ResultSetExtractor<List<Map<String, Object>>> {
    public ResultTableReader(boolean caseInsensitive, TypeHandlerRegistry typeHandler) {
        super(caseInsensitive, typeHandler);
    }

    @Override
    public List<Map<String, Object>> extractData(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList handlers = new ArrayList();
        for (int i = 0; i < rsmd.getColumnCount(); ++i) {
            columns.add(this.getColumnKey(rsmd, i));
            handlers.add(this.getResultSetTypeHandler(rs, i + 1, null));
        }
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        int rowNum = 0;
        while (rs.next()) {
            results.add(this.extractRow(columns, handlers, rs, rowNum++));
        }
        return results;
    }

    @Override
    public Map<String, Object> extractRow(List<String> columns, ResultSet rs, int rowNum) throws SQLException {
        ArrayList handlers = new ArrayList();
        for (int i = 0; i < columns.size(); ++i) {
            handlers.add(this.getResultSetTypeHandler(rs, i + 1, null));
        }
        return this.extractRow(columns, handlers, rs, rowNum);
    }

    protected Map<String, Object> extractRow(List<String> columns, List<TypeHandler<?>> handlers, ResultSet rs, int rowNum) throws SQLException {
        Map<String, Object> target = super.createColumnMap(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            String columnName = columns.get(i);
            UnknownTypeHandler handler = handlers.get(i);
            if (handler == null) {
                handler = this.getHandlerRegistry().getDefaultTypeHandler();
            }
            Object result = handler.getResult(rs, i + 1);
            target.put(columnName, result);
        }
        return target;
    }
}

