/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.mapping.resolve;

import java.lang.annotation.Annotation;
import java.util.Map;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.mapping.DdlAuto;
import net.hasor.dbvisitor.mapping.Table;
import net.hasor.dbvisitor.mapping.TableDefault;
import net.hasor.dbvisitor.mapping.TableDescribe;
import net.hasor.dbvisitor.mapping.resolve.MappingOptions;

class TableDefaultInfo
implements TableDefault,
Table,
TableDescribe {
    private final String catalog;
    private final String schema;
    private String table;
    private final boolean autoMapping;
    private final boolean useDelimited;
    private final boolean caseInsensitive;
    private final boolean mapUnderscoreToCamelCase;
    private final DdlAuto ddlAuto;
    private final String characterSet;
    private final String collation;
    private final String comment;
    private final String other;

    TableDefaultInfo(Map<String, String> attrMaps, ClassLoader classLoader, MappingOptions options) {
        String catalog = attrMaps.get("catalog");
        String schema = attrMaps.get("schema");
        String table = attrMaps.get("value");
        if (StringUtils.isBlank((String)table)) {
            table = attrMaps.get("table");
        }
        String autoMapping = attrMaps.get("autoMapping");
        String useDelimited = attrMaps.get("useDelimited");
        String caseInsensitive = attrMaps.get("caseInsensitive");
        String mapUnderscoreToCamelCase = attrMaps.get("mapUnderscoreToCamelCase");
        String characterSet = attrMaps.get("character-set");
        String collation = attrMaps.get("collation");
        String comment = attrMaps.get("comment");
        String other = attrMaps.get("other");
        String ddlAuto = attrMaps.get("ddlAuto");
        this.catalog = catalog == null ? "" : catalog;
        this.schema = schema == null ? "" : schema;
        String string = this.table = table == null ? "" : table;
        this.autoMapping = StringUtils.isNotBlank((String)autoMapping) ? Boolean.parseBoolean(autoMapping) : options.getAutoMapping() == null || options.getAutoMapping() != false;
        this.useDelimited = StringUtils.isNotBlank((String)useDelimited) ? Boolean.parseBoolean(useDelimited) : Boolean.TRUE.equals(options.getUseDelimited());
        this.caseInsensitive = StringUtils.isNotBlank((String)caseInsensitive) ? Boolean.parseBoolean(caseInsensitive) : options.getCaseInsensitive() == null || options.getCaseInsensitive() != false;
        this.mapUnderscoreToCamelCase = StringUtils.isNotBlank((String)mapUnderscoreToCamelCase) ? Boolean.parseBoolean(mapUnderscoreToCamelCase) : Boolean.TRUE.equals(options.getMapUnderscoreToCamelCase());
        this.ddlAuto = DdlAuto.valueOfCode(ddlAuto);
        this.characterSet = characterSet;
        this.collation = collation;
        this.comment = comment;
        this.other = other;
    }

    @Override
    public String catalog() {
        return this.catalog;
    }

    @Override
    public String schema() {
        return this.schema;
    }

    @Override
    public String value() {
        return this.table;
    }

    @Override
    public String table() {
        return this.table;
    }

    @Override
    public boolean autoMapping() {
        return this.autoMapping;
    }

    @Override
    public boolean useDelimited() {
        return this.useDelimited;
    }

    @Override
    public boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public boolean mapUnderscoreToCamelCase() {
        return this.mapUnderscoreToCamelCase;
    }

    @Override
    public DdlAuto ddlAuto() {
        return this.ddlAuto;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Table.class;
    }

    @Override
    public String characterSet() {
        return this.characterSet;
    }

    @Override
    public String collation() {
        return this.collation;
    }

    @Override
    public String comment() {
        return this.comment;
    }

    @Override
    public String other() {
        return this.other;
    }

    public void setTable(String table) {
        this.table = table;
    }
}

