/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.transaction;

import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import net.hasor.dbvisitor.transaction.ConnectionHolder;
import net.hasor.dbvisitor.transaction.ConnectionHolderImpl;
import net.hasor.dbvisitor.transaction.ConnectionProxy;

public abstract class DataSourceUtils {
    protected static final ThreadLocal<Map<DataSource, ConnectionHolder>> holderMap = ThreadLocal.withInitial(ConcurrentHashMap::new);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized ConnectionHolderImpl createOrGetHolder(DataSource dataSource) {
        Objects.requireNonNull(dataSource);
        ThreadLocal<Map<DataSource, ConnectionHolder>> threadLocal = holderMap;
        synchronized (threadLocal) {
            Map<DataSource, ConnectionHolder> localMap = holderMap.get();
            return (ConnectionHolderImpl)localMap.computeIfAbsent(dataSource, ConnectionHolderImpl::new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void triggerClose(DataSource dataSource) {
        ThreadLocal<Map<DataSource, ConnectionHolder>> threadLocal = holderMap;
        synchronized (threadLocal) {
            Map<DataSource, ConnectionHolder> dsMap = holderMap.get();
            if (dsMap.containsKey(dataSource) && dsMap.get(dataSource).getRefCount() == 0) {
                dsMap.remove(dataSource);
            }
        }
    }

    public static synchronized ConnectionHolder getHolder(DataSource dataSource) {
        return DataSourceUtils.createOrGetHolder(dataSource);
    }

    protected static void unsafeResetHolder(DataSource dataSource, ConnectionHolder holder) {
        Objects.requireNonNull(dataSource);
        Objects.requireNonNull(holder);
        Map<DataSource, ConnectionHolder> localMap = holderMap.get();
        localMap.put(dataSource, holder);
    }

    protected static void unsafeClearHolder(DataSource dataSource) {
        Objects.requireNonNull(dataSource);
        Map<DataSource, ConnectionHolder> localMap = holderMap.get();
        localMap.remove(dataSource);
    }

    public static Connection getConnection(DataSource dataSource) {
        ConnectionHolderImpl holder = DataSourceUtils.createOrGetHolder(dataSource);
        holder.requested();
        CloseSuppressingInvocationHandlerForHolder handler = new CloseSuppressingInvocationHandlerForHolder(holder);
        return (ConnectionProxy)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class, Closeable.class}, (InvocationHandler)handler);
    }

    private static class CloseSuppressingInvocationHandlerForHolder
    implements InvocationHandler {
        private final ConnectionHolderImpl holder;
        private final AtomicBoolean closed;

        CloseSuppressingInvocationHandlerForHolder(ConnectionHolderImpl holder) {
            this.holder = holder;
            this.closed = new AtomicBoolean(false);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "getTargetSource": {
                    return this.holder.getDataSource();
                }
                case "toString": {
                    return this.holder.toString();
                }
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
            }
            if (this.closed.get()) {
                throw new IllegalStateException("connection is close.");
            }
            Connection conn = this.holder.getConnection();
            switch (method.getName()) {
                case "getTargetConnection": {
                    return conn;
                }
                case "setSavepoint": {
                    if (args.length != 0) break;
                    return this.holder.createSavepoint();
                }
                case "close": {
                    if (this.holder.isOpen()) {
                        this.holder.released();
                    }
                    this.closed.set(true);
                    return null;
                }
            }
            try {
                return method.invoke((Object)conn, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

