/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.transaction.support;

import java.sql.SQLException;
import java.sql.Savepoint;
import net.hasor.dbvisitor.transaction.Isolation;
import net.hasor.dbvisitor.transaction.Propagation;
import net.hasor.dbvisitor.transaction.TransactionStatus;
import net.hasor.dbvisitor.transaction.support.SavepointManager;
import net.hasor.dbvisitor.transaction.support.TransactionObject;

public class LocalTransactionStatus
implements TransactionStatus {
    private Savepoint savepoint = null;
    private TransactionObject tranConn = null;
    private TransactionObject suspendConn = null;
    private final Propagation propagation;
    private final Isolation level;
    private boolean completed = false;
    private boolean rollbackOnly = false;
    private boolean newConnection = false;
    private boolean readOnly = false;

    public LocalTransactionStatus(Propagation propagation, Isolation level) {
        this.propagation = propagation;
        this.level = level;
    }

    protected SavepointManager getSavepointManager() {
        return (SavepointManager)((Object)this.tranConn.getHolder());
    }

    public void markSavepoint() throws SQLException {
        if (this.hasSavepoint()) {
            throw new SQLException("TransactionStatus has Savepoint");
        }
        SavepointManager manager = this.getSavepointManager();
        if (!manager.supportSavepoint()) {
            throw new SQLException("Connection does not support Savepoint.");
        }
        this.savepoint = manager.createSavepoint();
    }

    public void releaseSavepoint() throws SQLException {
        if (!this.hasSavepoint()) {
            throw new SQLException("TransactionStatus has not Savepoint");
        }
        SavepointManager manager = this.getSavepointManager();
        if (!manager.supportSavepoint()) {
            throw new SQLException("Connection does not support Savepoint.");
        }
        manager.releaseSavepoint(this.savepoint);
        this.savepoint = null;
    }

    public void rollbackToSavepoint() throws SQLException {
        if (!this.hasSavepoint()) {
            throw new SQLException("TransactionStatus has not Savepoint");
        }
        SavepointManager manager = this.getSavepointManager();
        if (!manager.supportSavepoint()) {
            throw new SQLException("Connection does not support Savepoint.");
        }
        manager.rollback(this.savepoint);
    }

    void setCompleted() {
        this.completed = true;
    }

    void markNewConnection() {
        this.newConnection = true;
    }

    TransactionObject getTranConn() {
        return this.tranConn;
    }

    void setTranConn(TransactionObject tranConn) {
        this.tranConn = tranConn;
    }

    TransactionObject getSuspendConn() {
        return this.suspendConn;
    }

    void setSuspendConn(TransactionObject suspendConn) {
        this.suspendConn = suspendConn;
    }

    @Override
    public Propagation getPropagation() {
        return this.propagation;
    }

    @Override
    public Isolation getIsolationLevel() {
        return this.level;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isNewConnection() {
        return this.newConnection;
    }

    @Override
    public boolean isSuspend() {
        return this.suspendConn != null;
    }

    @Override
    public boolean hasSavepoint() {
        return this.savepoint != null;
    }

    @Override
    public void setRollback() throws SQLException {
        if (this.isCompleted()) {
            throw new SQLException("Transaction is already completed.");
        }
        this.rollbackOnly = true;
    }

    @Override
    public void setReadOnly() throws SQLException {
        if (this.isCompleted()) {
            throw new SQLException("Transaction is already completed.");
        }
        this.readOnly = true;
    }
}

