/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.types;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.time.chrono.JapaneseDate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.reflect.ConstructorUtils;
import net.hasor.cobble.reflect.TypeReference;
import net.hasor.dbvisitor.types.BindTypeHandler;
import net.hasor.dbvisitor.types.MappedArg;
import net.hasor.dbvisitor.types.MappedCross;
import net.hasor.dbvisitor.types.MappedJavaTypes;
import net.hasor.dbvisitor.types.MappedJdbcTypes;
import net.hasor.dbvisitor.types.TypeHandler;
import net.hasor.dbvisitor.types.UnknownTypeHandler;
import net.hasor.dbvisitor.types.handler.ArrayTypeHandler;
import net.hasor.dbvisitor.types.handler.BigDecimalTypeHandler;
import net.hasor.dbvisitor.types.handler.BigIntegerTypeHandler;
import net.hasor.dbvisitor.types.handler.BlobAsBytesTypeHandler;
import net.hasor.dbvisitor.types.handler.BlobAsBytesWrapTypeHandler;
import net.hasor.dbvisitor.types.handler.BlobAsInputStreamTypeHandler;
import net.hasor.dbvisitor.types.handler.BooleanTypeHandler;
import net.hasor.dbvisitor.types.handler.ByteTypeHandler;
import net.hasor.dbvisitor.types.handler.BytesAsBytesWrapTypeHandler;
import net.hasor.dbvisitor.types.handler.BytesAsInputStreamTypeHandler;
import net.hasor.dbvisitor.types.handler.BytesTypeHandler;
import net.hasor.dbvisitor.types.handler.ClobAsReaderTypeHandler;
import net.hasor.dbvisitor.types.handler.ClobAsStringTypeHandler;
import net.hasor.dbvisitor.types.handler.DoubleTypeHandler;
import net.hasor.dbvisitor.types.handler.EnumTypeHandler;
import net.hasor.dbvisitor.types.handler.FloatTypeHandler;
import net.hasor.dbvisitor.types.handler.IntegerAsMonthDayTypeHandler;
import net.hasor.dbvisitor.types.handler.IntegerAsMonthTypeHandler;
import net.hasor.dbvisitor.types.handler.IntegerAsYearMonthTypeHandler;
import net.hasor.dbvisitor.types.handler.IntegerAsYearTypeHandler;
import net.hasor.dbvisitor.types.handler.IntegerTypeHandler;
import net.hasor.dbvisitor.types.handler.JapaneseDateAsSqlDateTypeHandler;
import net.hasor.dbvisitor.types.handler.LocalDateTimeAsLocalDateTypeHandler;
import net.hasor.dbvisitor.types.handler.LocalDateTimeTypeHandler;
import net.hasor.dbvisitor.types.handler.LocalTimeTypeHandler;
import net.hasor.dbvisitor.types.handler.LongTypeHandler;
import net.hasor.dbvisitor.types.handler.NClobAsReaderTypeHandler;
import net.hasor.dbvisitor.types.handler.NClobAsStringTypeHandler;
import net.hasor.dbvisitor.types.handler.NStringAsCharTypeHandler;
import net.hasor.dbvisitor.types.handler.NStringAsReaderTypeHandler;
import net.hasor.dbvisitor.types.handler.NStringTypeHandler;
import net.hasor.dbvisitor.types.handler.NumberTypeHandler;
import net.hasor.dbvisitor.types.handler.ObjectTypeHandler;
import net.hasor.dbvisitor.types.handler.OffsetDateTimeAsZonedDateTimeTypeHandler;
import net.hasor.dbvisitor.types.handler.OffsetDateTimeTypeHandler;
import net.hasor.dbvisitor.types.handler.OffsetTimeTypeHandler;
import net.hasor.dbvisitor.types.handler.ShortTypeHandler;
import net.hasor.dbvisitor.types.handler.SqlDateAsDateHandler;
import net.hasor.dbvisitor.types.handler.SqlDateTypeHandler;
import net.hasor.dbvisitor.types.handler.SqlTimeAsDateTypeHandler;
import net.hasor.dbvisitor.types.handler.SqlTimeTypeHandler;
import net.hasor.dbvisitor.types.handler.SqlTimestampAsDateTypeHandler;
import net.hasor.dbvisitor.types.handler.SqlTimestampAsInstantTypeHandler;
import net.hasor.dbvisitor.types.handler.SqlTimestampAsMonthDayTypeHandler;
import net.hasor.dbvisitor.types.handler.SqlTimestampAsMonthTypeHandler;
import net.hasor.dbvisitor.types.handler.SqlTimestampAsYearMonthTypeHandler;
import net.hasor.dbvisitor.types.handler.SqlTimestampAsYearTypeHandler;
import net.hasor.dbvisitor.types.handler.SqlTimestampTypeHandler;
import net.hasor.dbvisitor.types.handler.SqlXmlForInputStreamTypeHandler;
import net.hasor.dbvisitor.types.handler.SqlXmlForReaderTypeHandler;
import net.hasor.dbvisitor.types.handler.SqlXmlTypeHandler;
import net.hasor.dbvisitor.types.handler.StringAsCharTypeHandler;
import net.hasor.dbvisitor.types.handler.StringAsMonthDayTypeHandler;
import net.hasor.dbvisitor.types.handler.StringAsMonthTypeHandler;
import net.hasor.dbvisitor.types.handler.StringAsReaderTypeHandler;
import net.hasor.dbvisitor.types.handler.StringAsYearMonthTypeHandler;
import net.hasor.dbvisitor.types.handler.StringAsYearTypeHandler;
import net.hasor.dbvisitor.types.handler.StringTypeHandler;
import net.hasor.dbvisitor.types.handler.URITypeHandler;
import net.hasor.dbvisitor.types.handler.URLTypeHandler;

public final class TypeHandlerRegistry {
    private static final Map<Class<? extends TypeHandler<?>>, TypeHandler<?>> cachedSingleHandlers = new ConcurrentHashMap();
    private static final Map<String, Integer> javaTypeToJdbcTypeMap = new ConcurrentHashMap<String, Integer>();
    public static final TypeHandlerRegistry DEFAULT = new TypeHandlerRegistry();
    private final UnknownTypeHandler defaultTypeHandler = new UnknownTypeHandler(this);
    private final Map<String, TypeHandler<?>> javaTypeHandlerMap = new ConcurrentHashMap();
    private final Map<Integer, TypeHandler<?>> jdbcTypeHandlerMap = new ConcurrentHashMap();
    private final Map<String, Map<Integer, TypeHandler<?>>> typeHandlerMap = new ConcurrentHashMap();

    public TypeHandlerRegistry() {
        this.register(Boolean.class, this.createSingleTypeHandler(BooleanTypeHandler.class));
        this.register(Boolean.TYPE, this.createSingleTypeHandler(BooleanTypeHandler.class));
        this.register(Byte.class, this.createSingleTypeHandler(ByteTypeHandler.class));
        this.register(Byte.TYPE, this.createSingleTypeHandler(ByteTypeHandler.class));
        this.register(Short.class, this.createSingleTypeHandler(ShortTypeHandler.class));
        this.register(Short.TYPE, this.createSingleTypeHandler(ShortTypeHandler.class));
        this.register(Integer.class, this.createSingleTypeHandler(IntegerTypeHandler.class));
        this.register(Integer.TYPE, this.createSingleTypeHandler(IntegerTypeHandler.class));
        this.register(Long.class, this.createSingleTypeHandler(LongTypeHandler.class));
        this.register(Long.TYPE, this.createSingleTypeHandler(LongTypeHandler.class));
        this.register(Float.class, this.createSingleTypeHandler(FloatTypeHandler.class));
        this.register(Float.TYPE, this.createSingleTypeHandler(FloatTypeHandler.class));
        this.register(Double.class, this.createSingleTypeHandler(DoubleTypeHandler.class));
        this.register(Double.TYPE, this.createSingleTypeHandler(DoubleTypeHandler.class));
        this.register(Character.class, this.createSingleTypeHandler(StringAsCharTypeHandler.class));
        this.register(Character.TYPE, this.createSingleTypeHandler(StringAsCharTypeHandler.class));
        this.register(Date.class, this.createSingleTypeHandler(SqlTimestampAsDateTypeHandler.class));
        this.register(java.sql.Date.class, this.createSingleTypeHandler(SqlDateTypeHandler.class));
        this.register(Timestamp.class, this.createSingleTypeHandler(SqlTimestampTypeHandler.class));
        this.register(Time.class, this.createSingleTypeHandler(SqlTimeTypeHandler.class));
        this.register(Instant.class, this.createSingleTypeHandler(SqlTimestampAsInstantTypeHandler.class));
        this.register(JapaneseDate.class, this.createSingleTypeHandler(JapaneseDateAsSqlDateTypeHandler.class));
        this.register(Year.class, this.createSingleTypeHandler(SqlTimestampAsYearTypeHandler.class));
        this.register(Month.class, this.createSingleTypeHandler(SqlTimestampAsMonthTypeHandler.class));
        this.register(YearMonth.class, this.createSingleTypeHandler(SqlTimestampAsYearMonthTypeHandler.class));
        this.register(MonthDay.class, this.createSingleTypeHandler(SqlTimestampAsMonthDayTypeHandler.class));
        this.register(LocalDate.class, this.createSingleTypeHandler(LocalDateTimeAsLocalDateTypeHandler.class));
        this.register(LocalTime.class, this.createSingleTypeHandler(LocalTimeTypeHandler.class));
        this.register(LocalDateTime.class, this.createSingleTypeHandler(LocalDateTimeTypeHandler.class));
        this.register(ZonedDateTime.class, this.createSingleTypeHandler(OffsetDateTimeAsZonedDateTimeTypeHandler.class));
        this.register(OffsetDateTime.class, this.createSingleTypeHandler(OffsetDateTimeTypeHandler.class));
        this.register(OffsetTime.class, this.createSingleTypeHandler(OffsetTimeTypeHandler.class));
        this.register(String.class, this.createSingleTypeHandler(StringTypeHandler.class));
        this.register(BigInteger.class, this.createSingleTypeHandler(BigIntegerTypeHandler.class));
        this.register(BigDecimal.class, this.createSingleTypeHandler(BigDecimalTypeHandler.class));
        this.register(Reader.class, this.createSingleTypeHandler(StringAsReaderTypeHandler.class));
        this.register(InputStream.class, this.createSingleTypeHandler(BytesAsInputStreamTypeHandler.class));
        this.register(Byte[].class, this.createSingleTypeHandler(BytesAsBytesWrapTypeHandler.class));
        this.register(byte[].class, this.createSingleTypeHandler(BytesTypeHandler.class));
        this.register(Object[].class, this.createSingleTypeHandler(ArrayTypeHandler.class));
        this.register(Object.class, this.createSingleTypeHandler(UnknownTypeHandler.class));
        this.register(Number.class, this.createSingleTypeHandler(NumberTypeHandler.class));
        this.register(Clob.class, this.createSingleTypeHandler(ClobAsStringTypeHandler.class));
        this.register(NClob.class, this.createSingleTypeHandler(NClobAsStringTypeHandler.class));
        this.register(Blob.class, this.createSingleTypeHandler(BlobAsBytesTypeHandler.class));
        this.register(URL.class, this.createSingleTypeHandler(URLTypeHandler.class));
        this.register(URI.class, this.createSingleTypeHandler(URITypeHandler.class));
        this.register(-7, this.createSingleTypeHandler(BooleanTypeHandler.class));
        this.register(16, this.createSingleTypeHandler(BooleanTypeHandler.class));
        this.register(-6, this.createSingleTypeHandler(ByteTypeHandler.class));
        this.register(5, this.createSingleTypeHandler(ShortTypeHandler.class));
        this.register(4, this.createSingleTypeHandler(IntegerTypeHandler.class));
        this.register(-5, this.createSingleTypeHandler(LongTypeHandler.class));
        this.register(6, this.createSingleTypeHandler(FloatTypeHandler.class));
        this.register(8, this.createSingleTypeHandler(DoubleTypeHandler.class));
        this.register(7, this.createSingleTypeHandler(BigDecimalTypeHandler.class));
        this.register(2, this.createSingleTypeHandler(BigDecimalTypeHandler.class));
        this.register(3, this.createSingleTypeHandler(BigDecimalTypeHandler.class));
        this.register(1, this.createSingleTypeHandler(StringAsCharTypeHandler.class));
        this.register(-15, this.createSingleTypeHandler(NStringAsCharTypeHandler.class));
        this.register(2005, this.createSingleTypeHandler(ClobAsStringTypeHandler.class));
        this.register(12, this.createSingleTypeHandler(StringTypeHandler.class));
        this.register(-1, this.createSingleTypeHandler(StringTypeHandler.class));
        this.register(2011, this.createSingleTypeHandler(NClobAsStringTypeHandler.class));
        this.register(-9, this.createSingleTypeHandler(NStringTypeHandler.class));
        this.register(-16, this.createSingleTypeHandler(NStringTypeHandler.class));
        this.register(93, this.createSingleTypeHandler(SqlTimestampAsDateTypeHandler.class));
        this.register(91, this.createSingleTypeHandler(SqlDateAsDateHandler.class));
        this.register(92, this.createSingleTypeHandler(SqlTimeAsDateTypeHandler.class));
        this.register(2013, this.createSingleTypeHandler(OffsetTimeTypeHandler.class));
        this.register(2014, this.createSingleTypeHandler(OffsetDateTimeTypeHandler.class));
        this.register(2009, this.createSingleTypeHandler(SqlXmlTypeHandler.class));
        this.register(-2, this.createSingleTypeHandler(BytesTypeHandler.class));
        this.register(-3, this.createSingleTypeHandler(BytesTypeHandler.class));
        this.register(-4, this.createSingleTypeHandler(BytesTypeHandler.class));
        this.register(2004, this.createSingleTypeHandler(BlobAsBytesTypeHandler.class));
        this.register(2000, this.createSingleTypeHandler(ObjectTypeHandler.class));
        this.register(2003, this.createSingleTypeHandler(ArrayTypeHandler.class));
        this.register(70, this.createSingleTypeHandler(URLTypeHandler.class));
        this.register(-8, this.createSingleTypeHandler(StringTypeHandler.class));
        this.register(1111, this.createSingleTypeHandler(UnknownTypeHandler.class));
        this.registerCrossChars(MonthDay.class, this.createSingleTypeHandler(StringAsMonthDayTypeHandler.class));
        this.registerCrossNChars(MonthDay.class, this.createSingleTypeHandler(StringAsMonthDayTypeHandler.class));
        this.registerCrossNumber(MonthDay.class, this.createSingleTypeHandler(IntegerAsMonthDayTypeHandler.class));
        this.registerCrossChars(YearMonth.class, this.createSingleTypeHandler(StringAsYearMonthTypeHandler.class));
        this.registerCrossNChars(YearMonth.class, this.createSingleTypeHandler(StringAsYearMonthTypeHandler.class));
        this.registerCrossNumber(YearMonth.class, this.createSingleTypeHandler(IntegerAsYearMonthTypeHandler.class));
        this.registerCrossChars(Year.class, this.createSingleTypeHandler(StringAsYearTypeHandler.class));
        this.registerCrossNChars(Year.class, this.createSingleTypeHandler(StringAsYearTypeHandler.class));
        this.registerCrossNumber(Year.class, this.createSingleTypeHandler(IntegerAsYearTypeHandler.class));
        this.registerCrossChars(Month.class, this.createSingleTypeHandler(StringAsMonthTypeHandler.class));
        this.registerCrossNChars(Month.class, this.createSingleTypeHandler(StringAsMonthTypeHandler.class));
        this.registerCrossNumber(Month.class, this.createSingleTypeHandler(IntegerAsMonthTypeHandler.class));
        this.registerCrossChars(String.class, this.createSingleTypeHandler(StringTypeHandler.class));
        this.registerCrossNChars(String.class, this.createSingleTypeHandler(NStringTypeHandler.class));
        this.registerCross(2005, String.class, this.createSingleTypeHandler(ClobAsStringTypeHandler.class));
        this.registerCross(2011, String.class, this.createSingleTypeHandler(NClobAsStringTypeHandler.class));
        this.registerCrossChars(Reader.class, this.createSingleTypeHandler(StringAsReaderTypeHandler.class));
        this.registerCrossNChars(Reader.class, this.createSingleTypeHandler(NStringAsReaderTypeHandler.class));
        this.registerCross(2005, Reader.class, this.createSingleTypeHandler(ClobAsReaderTypeHandler.class));
        this.registerCross(2011, Reader.class, this.createSingleTypeHandler(NClobAsReaderTypeHandler.class));
        this.registerCross(2009, String.class, this.createSingleTypeHandler(SqlXmlTypeHandler.class));
        this.registerCross(2009, Reader.class, this.createSingleTypeHandler(SqlXmlForReaderTypeHandler.class));
        this.registerCross(2009, InputStream.class, this.createSingleTypeHandler(SqlXmlForInputStreamTypeHandler.class));
        this.registerCross(-2, byte[].class, this.createSingleTypeHandler(BytesTypeHandler.class));
        this.registerCross(-2, Byte[].class, this.createSingleTypeHandler(BytesAsBytesWrapTypeHandler.class));
        this.registerCross(-3, byte[].class, this.createSingleTypeHandler(BytesTypeHandler.class));
        this.registerCross(-3, Byte[].class, this.createSingleTypeHandler(BytesAsBytesWrapTypeHandler.class));
        this.registerCross(2004, byte[].class, this.createSingleTypeHandler(BlobAsBytesTypeHandler.class));
        this.registerCross(2004, Byte[].class, this.createSingleTypeHandler(BlobAsBytesWrapTypeHandler.class));
        this.registerCross(-4, byte[].class, this.createSingleTypeHandler(BytesTypeHandler.class));
        this.registerCross(-4, Byte[].class, this.createSingleTypeHandler(BytesAsBytesWrapTypeHandler.class));
        this.registerCross(-2, InputStream.class, this.createSingleTypeHandler(BytesAsInputStreamTypeHandler.class));
        this.registerCross(-3, InputStream.class, this.createSingleTypeHandler(BytesAsInputStreamTypeHandler.class));
        this.registerCross(-4, InputStream.class, this.createSingleTypeHandler(BytesAsInputStreamTypeHandler.class));
        this.registerCross(2004, InputStream.class, this.createSingleTypeHandler(BlobAsInputStreamTypeHandler.class));
        this.registerCross(2003, Object.class, this.createSingleTypeHandler(ArrayTypeHandler.class));
        this.registerCross(70, String.class, this.createSingleTypeHandler(StringTypeHandler.class));
        this.registerCross(70, URL.class, this.createSingleTypeHandler(URLTypeHandler.class));
        this.registerCross(70, URI.class, this.createSingleTypeHandler(URITypeHandler.class));
        this.registerCross(-8, byte[].class, this.createSingleTypeHandler(BytesTypeHandler.class));
        this.registerCross(-8, Byte[].class, this.createSingleTypeHandler(BytesAsBytesWrapTypeHandler.class));
        this.registerCross(-8, String.class, this.createSingleTypeHandler(StringTypeHandler.class));
    }

    private TypeHandler<?> createSingleTypeHandler(Class<? extends TypeHandler<?>> typeHandler) {
        cachedSingleHandlers.computeIfAbsent(typeHandler, type -> {
            try {
                if (typeHandler == UnknownTypeHandler.class) {
                    return this.defaultTypeHandler;
                }
                return (TypeHandler)typeHandler.newInstance();
            }
            catch (Exception e) {
                throw ExceptionUtils.toRuntime((Throwable)e);
            }
        });
        return cachedSingleHandlers.get(typeHandler);
    }

    public void register(int jdbcType, TypeHandler<?> typeHandler) {
        this.jdbcTypeHandlerMap.put(jdbcType, typeHandler);
    }

    public void register(Class<?> javaType, TypeHandler<?> typeHandler) {
        this.javaTypeHandlerMap.put(javaType.getName(), typeHandler);
    }

    public void registerCross(int jdbcType, Class<?> javaType, TypeHandler<?> typeHandler) {
        Map typeClassMap = this.typeHandlerMap.computeIfAbsent(javaType.getName(), k -> new ConcurrentHashMap());
        typeClassMap.put(jdbcType, typeHandler);
    }

    private void registerCrossChars(Class<?> jdbcType, TypeHandler<?> typeHandler) {
        this.registerCross(1, jdbcType, typeHandler);
        this.registerCross(12, jdbcType, typeHandler);
        this.registerCross(-1, jdbcType, typeHandler);
    }

    private void registerCrossNChars(Class<?> jdbcType, TypeHandler<?> typeHandler) {
        this.registerCross(-15, jdbcType, typeHandler);
        this.registerCross(-9, jdbcType, typeHandler);
        this.registerCross(-16, jdbcType, typeHandler);
    }

    private void registerCrossNumber(Class<?> jdbcType, TypeHandler<?> typeHandler) {
        this.registerCross(-6, jdbcType, typeHandler);
        this.registerCross(5, jdbcType, typeHandler);
        this.registerCross(4, jdbcType, typeHandler);
        this.registerCross(-5, jdbcType, typeHandler);
        this.registerCross(6, jdbcType, typeHandler);
        this.registerCross(8, jdbcType, typeHandler);
        this.registerCross(7, jdbcType, typeHandler);
        this.registerCross(2, jdbcType, typeHandler);
        this.registerCross(3, jdbcType, typeHandler);
    }

    public void registerHandler(Class<? extends TypeHandler<?>> handlerClass, TypeHandler<?> typeHandler) {
        MappedCross[] mappedCrosses;
        MappedJdbcTypes mappedJdbcTypes;
        MappedJavaTypes mappedTypes = handlerClass.getAnnotation(MappedJavaTypes.class);
        if (mappedTypes != null) {
            for (Class<?> handledType : mappedTypes.value()) {
                this.register(handledType, typeHandler);
            }
        }
        if ((mappedJdbcTypes = handlerClass.getAnnotation(MappedJdbcTypes.class)) != null) {
            for (int jdbcType : mappedJdbcTypes.value()) {
                if (typeHandler instanceof TypeReference) {
                    this.registerCross(jdbcType, ((TypeReference)typeHandler).getRawType(), typeHandler);
                    continue;
                }
                this.register(jdbcType, typeHandler);
            }
        }
        for (MappedCross cross : mappedCrosses = (MappedCross[])handlerClass.getAnnotationsByType(MappedCross.class)) {
            MappedJdbcTypes jdbcTypes = cross.jdbcType();
            MappedJavaTypes javaTypes = cross.javaTypes();
            for (Class<?> javaType : javaTypes.value()) {
                for (int jdbcType : jdbcTypes.value()) {
                    this.registerCross(jdbcType, javaType, typeHandler);
                }
            }
        }
    }

    public Collection<TypeHandler<?>> getTypeHandlers() {
        return Collections.unmodifiableCollection(this.javaTypeHandlerMap.values());
    }

    public Collection<String> getHandlerJavaTypes() {
        return Collections.unmodifiableCollection(this.javaTypeHandlerMap.keySet());
    }

    public static int toSqlType(String javaType) {
        Integer jdbcType = javaTypeToJdbcTypeMap.get(javaType);
        if (jdbcType != null) {
            return jdbcType;
        }
        return 2000;
    }

    public static int toSqlType(Class<?> javaType) {
        Integer jdbcType = javaTypeToJdbcTypeMap.get(javaType.getName());
        if (jdbcType != null) {
            return jdbcType;
        }
        return 2000;
    }

    public boolean hasTypeHandler(Class<?> typeClass) {
        Objects.requireNonNull(typeClass, "typeClass is null.");
        if (typeClass.isEnum()) {
            return true;
        }
        if (typeClass.isAnnotationPresent(BindTypeHandler.class)) {
            return true;
        }
        return this.javaTypeHandlerMap.containsKey(typeClass.getName());
    }

    public boolean hasTypeHandler(String typeName) {
        Objects.requireNonNull(typeName, "typeName is null.");
        return this.javaTypeHandlerMap.containsKey(typeName);
    }

    public boolean hasTypeHandler(int jdbcType) {
        return this.jdbcTypeHandlerMap.containsKey(jdbcType);
    }

    public boolean hasTypeHandler(Class<?> typeClass, int jdbcType) {
        Objects.requireNonNull(typeClass, "typeClass is null.");
        if (typeClass.isEnum()) {
            return true;
        }
        Map<Integer, TypeHandler<?>> jdbcHandlerMap = this.typeHandlerMap.get(typeClass.getName());
        if (jdbcHandlerMap != null) {
            return jdbcHandlerMap.containsKey(jdbcType);
        }
        return typeClass.isAnnotationPresent(BindTypeHandler.class);
    }

    public TypeHandler<?> getTypeHandler(String typeName) {
        if (StringUtils.isBlank((String)typeName)) {
            throw new NullPointerException("typeName is null.");
        }
        UnknownTypeHandler typeHandler = this.javaTypeHandlerMap.get(typeName);
        return typeHandler != null ? typeHandler : this.defaultTypeHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeHandler<?> getTypeHandler(Class<?> typeClass) {
        Objects.requireNonNull(typeClass, "typeClass is null.");
        String typeClassName = typeClass.getName();
        TypeHandler typeHandler = this.javaTypeHandlerMap.get(typeClassName);
        if (typeHandler != null) {
            return typeHandler;
        }
        if (typeClass.isAnnotationPresent(BindTypeHandler.class)) {
            TypeHandlerRegistry typeHandlerRegistry = this;
            synchronized (typeHandlerRegistry) {
                if (this.javaTypeHandlerMap.containsKey(typeClassName)) {
                    return this.javaTypeHandlerMap.get(typeClassName);
                }
                try {
                    BindTypeHandler handler = typeClass.getAnnotation(BindTypeHandler.class);
                    Constructor constructor = ConstructorUtils.getAccessibleConstructor(handler.value(), Class.class);
                    typeHandler = constructor == null ? (TypeHandler)handler.value().newInstance() : (TypeHandler)ConstructorUtils.invokeConstructor(handler.value(), typeClass);
                }
                catch (Exception e) {
                    throw ExceptionUtils.toRuntime((Throwable)e);
                }
                this.javaTypeHandlerMap.put(typeClassName, typeHandler);
                return typeHandler;
            }
        }
        if (Enum.class.isAssignableFrom(typeClass)) {
            return this.javaTypeHandlerMap.computeIfAbsent(typeClass.getName(), s -> {
                Class enumType = typeClass.isAnonymousClass() ? typeClass.getSuperclass() : typeClass;
                return new EnumTypeHandler(enumType);
            });
        }
        this.javaTypeHandlerMap.put(typeClassName, this.defaultTypeHandler);
        return this.defaultTypeHandler;
    }

    public TypeHandler<?> getTypeHandler(int jdbcType) {
        UnknownTypeHandler typeHandler = this.jdbcTypeHandlerMap.get(jdbcType);
        return typeHandler != null ? typeHandler : this.defaultTypeHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeHandler<?> getTypeHandler(Class<?> typeClass, int jdbcType) {
        TypeHandler<?> typeHandler;
        if (typeClass == null) {
            return this.defaultTypeHandler;
        }
        String typeClassName = typeClass.getName();
        Map<Integer, TypeHandler<?>> handlerMap = this.typeHandlerMap.get(typeClassName);
        if (handlerMap != null && (typeHandler = handlerMap.get(jdbcType)) != null) {
            return typeHandler;
        }
        typeHandler = this.javaTypeHandlerMap.get(typeClassName);
        if (typeHandler != null) {
            return typeHandler;
        }
        if (typeClass.isAnnotationPresent(BindTypeHandler.class)) {
            TypeHandlerRegistry typeHandlerRegistry = this;
            synchronized (typeHandlerRegistry) {
                if (this.typeHandlerMap.containsKey(typeClassName) && (handlerMap = this.typeHandlerMap.get(typeClassName)).containsKey(jdbcType)) {
                    return handlerMap.get(jdbcType);
                }
                try {
                    BindTypeHandler handler = typeClass.getAnnotation(BindTypeHandler.class);
                    Constructor constructor = ConstructorUtils.getAccessibleConstructor(handler.value(), Class.class);
                    typeHandler = constructor == null ? (TypeHandler<?>)handler.value().newInstance() : (TypeHandler)ConstructorUtils.invokeConstructor(handler.value(), typeClass);
                }
                catch (Exception e) {
                    throw ExceptionUtils.toRuntime((Throwable)e);
                }
                this.registerCross(jdbcType, typeClass, typeHandler);
                return typeHandler;
            }
        }
        if (Enum.class.isAssignableFrom(typeClass) && (typeHandler = this.javaTypeHandlerMap.get((typeClass = typeClass.isAnonymousClass() ? typeClass.getSuperclass() : typeClass).getName())) == null) {
            EnumTypeHandler enumOfStringTypeHandler = new EnumTypeHandler(typeClass);
            this.registerCross(jdbcType, typeClass, enumOfStringTypeHandler);
            return enumOfStringTypeHandler;
        }
        this.registerCross(jdbcType, typeClass, this.defaultTypeHandler);
        return this.defaultTypeHandler;
    }

    public UnknownTypeHandler getDefaultTypeHandler() {
        return this.defaultTypeHandler;
    }

    public void setParameterValue(PreparedStatement ps, int parameterPosition, Object value) throws SQLException {
        if (value == null) {
            ps.setObject(parameterPosition, null);
            return;
        }
        if (value instanceof MappedArg) {
            Integer argType = ((MappedArg)value).getJdbcType();
            TypeHandler<?> argHandler = ((MappedArg)value).getTypeHandler();
            Object argValue = ((MappedArg)value).getValue();
            if (argType == null && argValue != null) {
                argType = TypeHandlerRegistry.toSqlType(argValue.getClass());
            }
            if (argHandler == null && argValue != null) {
                argHandler = this.getTypeHandler(argValue.getClass());
            }
            if (argHandler != null) {
                argHandler.setParameter(ps, parameterPosition, argValue, argType);
                return;
            }
            if (argValue == null) {
                ps.setObject(parameterPosition, null);
                return;
            }
        }
        Class<?> valueClass = value.getClass();
        TypeHandler<?> typeHandler = this.getTypeHandler(valueClass);
        typeHandler.setParameter(ps, parameterPosition, value, TypeHandlerRegistry.toSqlType(valueClass));
    }

    static {
        javaTypeToJdbcTypeMap.put(Boolean.class.getName(), -7);
        javaTypeToJdbcTypeMap.put(Boolean.TYPE.getName(), -7);
        javaTypeToJdbcTypeMap.put(Byte.class.getName(), -6);
        javaTypeToJdbcTypeMap.put(Byte.TYPE.getName(), -6);
        javaTypeToJdbcTypeMap.put(Short.class.getName(), 5);
        javaTypeToJdbcTypeMap.put(Short.TYPE.getName(), 5);
        javaTypeToJdbcTypeMap.put(Integer.class.getName(), 4);
        javaTypeToJdbcTypeMap.put(Integer.TYPE.getName(), 4);
        javaTypeToJdbcTypeMap.put(Long.class.getName(), -5);
        javaTypeToJdbcTypeMap.put(Long.TYPE.getName(), -5);
        javaTypeToJdbcTypeMap.put(Float.class.getName(), 6);
        javaTypeToJdbcTypeMap.put(Float.TYPE.getName(), 6);
        javaTypeToJdbcTypeMap.put(Double.class.getName(), 8);
        javaTypeToJdbcTypeMap.put(Double.TYPE.getName(), 8);
        javaTypeToJdbcTypeMap.put(Character.class.getName(), 1);
        javaTypeToJdbcTypeMap.put(Character.TYPE.getName(), 1);
        javaTypeToJdbcTypeMap.put(Date.class.getName(), 93);
        javaTypeToJdbcTypeMap.put(java.sql.Date.class.getName(), 91);
        javaTypeToJdbcTypeMap.put(Timestamp.class.getName(), 93);
        javaTypeToJdbcTypeMap.put(Time.class.getName(), 92);
        javaTypeToJdbcTypeMap.put(Instant.class.getName(), 93);
        javaTypeToJdbcTypeMap.put(LocalDateTime.class.getName(), 93);
        javaTypeToJdbcTypeMap.put(LocalDate.class.getName(), 91);
        javaTypeToJdbcTypeMap.put(LocalTime.class.getName(), 92);
        javaTypeToJdbcTypeMap.put(ZonedDateTime.class.getName(), 2014);
        javaTypeToJdbcTypeMap.put(JapaneseDate.class.getName(), 93);
        javaTypeToJdbcTypeMap.put(YearMonth.class.getName(), 12);
        javaTypeToJdbcTypeMap.put(Year.class.getName(), 5);
        javaTypeToJdbcTypeMap.put(Month.class.getName(), 5);
        javaTypeToJdbcTypeMap.put(OffsetDateTime.class.getName(), 2014);
        javaTypeToJdbcTypeMap.put(OffsetTime.class.getName(), 2013);
        javaTypeToJdbcTypeMap.put(String.class.getName(), 12);
        javaTypeToJdbcTypeMap.put(BigInteger.class.getName(), -5);
        javaTypeToJdbcTypeMap.put(BigDecimal.class.getName(), 3);
        javaTypeToJdbcTypeMap.put(Reader.class.getName(), 2005);
        javaTypeToJdbcTypeMap.put(InputStream.class.getName(), 2004);
        javaTypeToJdbcTypeMap.put(URL.class.getName(), 70);
        javaTypeToJdbcTypeMap.put(URI.class.getName(), 70);
        javaTypeToJdbcTypeMap.put(Byte[].class.getName(), -3);
        javaTypeToJdbcTypeMap.put(byte[].class.getName(), -3);
        javaTypeToJdbcTypeMap.put(Object[].class.getName(), 2003);
        javaTypeToJdbcTypeMap.put(Object.class.getName(), 2000);
        javaTypeToJdbcTypeMap.put("oracle.jdbc.OracleBlob", 2004);
        javaTypeToJdbcTypeMap.put("oracle.jdbc.OracleClob", 2005);
        javaTypeToJdbcTypeMap.put("oracle.jdbc.OracleNClob", 2011);
        javaTypeToJdbcTypeMap.put("oracle.sql.DATE", 91);
        javaTypeToJdbcTypeMap.put("oracle.sql.TIMESTAMP", 93);
        javaTypeToJdbcTypeMap.put("oracle.sql.TIMESTAMPTZ", 2014);
        javaTypeToJdbcTypeMap.put("oracle.sql.TIMESTAMPLTZ", 2014);
    }
}

