/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.types.handler;

import java.io.ByteArrayInputStream;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.hasor.dbvisitor.types.handler.AbstractTypeHandler;

public class BlobAsBytesWrapTypeHandler
extends AbstractTypeHandler<Byte[]> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, Byte[] parameter, Integer jdbcType) throws SQLException {
        ps.setBlob(i, new ByteArrayInputStream(this.convertToPrimitiveArray(parameter)));
    }

    @Override
    public Byte[] getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.getBytes(rs.getBlob(columnName));
    }

    @Override
    public Byte[] getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.getBytes(rs.getBlob(columnIndex));
    }

    @Override
    public Byte[] getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.getBytes(cs.getBlob(columnIndex));
    }

    private Byte[] getBytes(Blob blob) throws SQLException {
        if (blob == null) {
            return null;
        }
        try {
            Byte[] byteArray = this.convertToObjectArray(blob.getBytes(1L, (int)blob.length()));
            return byteArray;
        }
        finally {
            blob.free();
        }
    }

    protected byte[] convertToPrimitiveArray(Byte[] objects) {
        byte[] bytes = new byte[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            bytes[i] = objects[i];
        }
        return bytes;
    }

    protected Byte[] convertToObjectArray(byte[] bytes) {
        Byte[] objects = new Byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            objects[i] = bytes[i];
        }
        return objects;
    }
}

