/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.types.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import net.hasor.cobble.logging.Logger;
import net.hasor.dbvisitor.types.handler.AbstractJsonTypeHandler;

public class JsonTypeHandler
extends AbstractJsonTypeHandler<Object> {
    private static final Logger logger = Logger.getLogger(JsonTypeHandler.class);
    private final Class<?> type;

    public JsonTypeHandler(Class<?> type) {
        if (logger.isTraceEnabled()) {
            logger.trace("JsonUseForFastjsonTypeHandler(" + type + ")");
        }
        this.type = type;
    }

    @Override
    public String toString() {
        return "JsonTypeHandler[" + this.type + "]@" + super.hashCode();
    }

    @Override
    protected Object parse(String json) {
        return JSON.parseObject((String)json, this.type);
    }

    @Override
    protected String toJson(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty});
    }
}

