/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.types.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.MonthDay;
import net.hasor.dbvisitor.types.handler.AbstractTypeHandler;

public class SqlTimestampAsMonthDayTypeHandler
extends AbstractTypeHandler<MonthDay> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, MonthDay parameter, Integer jdbcType) throws SQLException {
        LocalDateTime dateTime = LocalDateTime.of(0, parameter.getMonth(), parameter.getDayOfMonth(), 0, 0);
        ps.setTimestamp(i, Timestamp.valueOf(dateTime));
    }

    @Override
    public MonthDay getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(columnName);
        return this.toMonthDay(timestamp);
    }

    @Override
    public MonthDay getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(columnIndex);
        return this.toMonthDay(timestamp);
    }

    @Override
    public MonthDay getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Timestamp timestamp = cs.getTimestamp(columnIndex);
        return this.toMonthDay(timestamp);
    }

    protected MonthDay toMonthDay(Timestamp timestamp) {
        if (timestamp == null) {
            return null;
        }
        LocalDate localDate = timestamp.toLocalDateTime().toLocalDate();
        return MonthDay.of(localDate.getMonth(), localDate.getDayOfMonth());
    }
}

