/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.types.handler;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.hasor.dbvisitor.types.handler.AbstractTypeHandler;

public class URITypeHandler
extends AbstractTypeHandler<URI> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, URI parameter, Integer jdbcType) throws SQLException {
        ps.setString(i, parameter.toString());
    }

    @Override
    public URI getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.toUrl(rs.getString(columnName));
    }

    @Override
    public URI getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.toUrl(rs.getString(columnIndex));
    }

    @Override
    public URI getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.toUrl(cs.getString(columnIndex));
    }

    protected URI toUrl(String urlData) throws SQLException {
        try {
            return new URI(urlData);
        }
        catch (URISyntaxException e) {
            throw new SQLException(e);
        }
    }
}

