/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.types.handler;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.hasor.dbvisitor.types.handler.AbstractTypeHandler;

public class URLTypeHandler
extends AbstractTypeHandler<URL> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, URL parameter, Integer jdbcType) throws SQLException {
        ps.setString(i, parameter.toString());
    }

    @Override
    public URL getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.toUrl(rs.getString(columnName));
    }

    @Override
    public URL getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.toUrl(rs.getString(columnIndex));
    }

    @Override
    public URL getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.toUrl(cs.getString(columnIndex));
    }

    protected URL toUrl(String urlData) throws SQLException {
        try {
            return new URL(urlData);
        }
        catch (MalformedURLException e) {
            throw new SQLException(e);
        }
    }
}

