/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.types.handler.pg;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.types.handler.BigDecimalTypeHandler;

public class PgMoneyAsBigDecimalTypeHandler
extends BigDecimalTypeHandler {
    @Override
    public BigDecimal getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return PgMoneyAsBigDecimalTypeHandler.toNumber(rs.getString(columnName));
    }

    @Override
    public BigDecimal getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return PgMoneyAsBigDecimalTypeHandler.toNumber(rs.getString(columnIndex));
    }

    @Override
    public BigDecimal getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return PgMoneyAsBigDecimalTypeHandler.toNumber(cs.getString(columnIndex));
    }

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, BigDecimal parameter, Integer jdbcType) throws SQLException {
        ps.setString(i, parameter.toPlainString());
    }

    protected static BigDecimal toNumber(String moneyValue) {
        String moneySign = PgMoneyAsBigDecimalTypeHandler.filerMoneySign(moneyValue);
        return StringUtils.isBlank((String)moneySign) ? null : new BigDecimal(moneySign);
    }

    protected static String filerMoneySign(String mStr) {
        if (StringUtils.isBlank((String)mStr)) {
            return null;
        }
        char[] chars = mStr.toCharArray();
        int index = -1;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (!Character.isDigit(c)) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return StringUtils.replace((String)mStr, (String)",", (String)"");
        }
        return StringUtils.replace((String)mStr.substring(index), (String)",", (String)"");
    }
}

