/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.dynamic.rule;

import java.sql.SQLException;
import java.util.Map;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.dal.dynamic.DynamicContext;
import net.hasor.dbvisitor.dal.dynamic.DynamicSql;
import net.hasor.dbvisitor.dal.dynamic.rule.SqlBuildRule;
import net.hasor.dbvisitor.dialect.SqlBuilder;

public class IncludeRule
implements SqlBuildRule {
    public static final SqlBuildRule INSTANCE = new IncludeRule();

    @Override
    public void executeRule(Map<String, Object> data, DynamicContext context, SqlBuilder sqlBuilder, String activeExpr, String ruleValue) throws SQLException {
        DynamicSql includeSql = context.findDynamic(ruleValue = ruleValue.trim());
        if (includeSql == null) {
            throw new SQLException("include sql '" + ruleValue + "' not found.");
        }
        SqlBuilder includeBuilder = includeSql.buildQuery(data, context);
        if (StringUtils.isBlank((String)includeBuilder.getSqlString())) {
            return;
        }
        if (!sqlBuilder.lastSpaceCharacter()) {
            sqlBuilder.appendSql(" ");
        }
        sqlBuilder.appendBuilder(includeBuilder);
        if (!includeBuilder.lastSpaceCharacter()) {
            sqlBuilder.appendSql(" ");
        }
    }

    public String toString() {
        return "include [" + this.hashCode() + "]";
    }
}

