/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.execute;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.io.IOUtils;
import net.hasor.cobble.logging.Logger;
import net.hasor.cobble.logging.LoggerFactory;
import net.hasor.dbvisitor.dal.dynamic.DynamicContext;
import net.hasor.dbvisitor.dal.dynamic.DynamicSql;
import net.hasor.dbvisitor.dal.dynamic.SqlArg;
import net.hasor.dbvisitor.dal.dynamic.SqlMode;
import net.hasor.dbvisitor.dal.execute.DalResultSetExtractor;
import net.hasor.dbvisitor.dal.repository.MultipleResultsType;
import net.hasor.dbvisitor.dal.repository.ResultSetType;
import net.hasor.dbvisitor.dal.repository.config.DmlSqlConfig;
import net.hasor.dbvisitor.dal.repository.config.InsertSqlConfig;
import net.hasor.dbvisitor.dal.repository.config.QuerySqlConfig;
import net.hasor.dbvisitor.dialect.BoundSql;
import net.hasor.dbvisitor.dialect.PageSqlDialect;
import net.hasor.dbvisitor.dialect.SqlBuilder;
import net.hasor.dbvisitor.jdbc.extractor.MultipleProcessType;
import net.hasor.dbvisitor.mapping.TableReader;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.mapping.reader.ResultTableReader;
import net.hasor.dbvisitor.page.Page;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;

public abstract class AbstractStatementExecute<T> {
    protected static final Logger logger = LoggerFactory.getLogger(AbstractStatementExecute.class);
    private final DynamicContext context;

    public AbstractStatementExecute(DynamicContext context) {
        this.context = context;
    }

    protected DynamicContext getContext() {
        return this.context;
    }

    public final T execute(Connection conn, DynamicSql dynamicSql, Map<String, Object> data) throws SQLException {
        return this.execute(conn, dynamicSql, data, null, false, null, false);
    }

    public final T execute(Connection conn, DynamicSql dynamicSql, Map<String, Object> data, Page pageInfo, boolean pageResult, PageSqlDialect dialect) throws SQLException {
        return this.execute(conn, dynamicSql, data, pageInfo, pageResult, dialect, false);
    }

    public final T execute(Connection conn, DynamicSql dynamicSql, Map<String, Object> data, Page pageInfo, boolean pageResult, PageSqlDialect dialect, boolean resultAsMap) throws SQLException {
        SqlBuilder queryBuilder = dynamicSql.buildQuery(data, this.context);
        ExecuteInfo executeInfo = new ExecuteInfo();
        executeInfo.pageInfo = pageInfo;
        executeInfo.timeout = -1;
        executeInfo.resultMap = "";
        executeInfo.resultType = Map.class.getName();
        executeInfo.fetchSize = 256;
        executeInfo.resultSetType = ResultSetType.DEFAULT;
        executeInfo.multipleResultType = MultipleResultsType.LAST;
        executeInfo.pageDialect = dialect;
        executeInfo.pageResult = pageResult;
        executeInfo.data = data;
        executeInfo.hasSelectKey = false;
        if (dynamicSql instanceof DmlSqlConfig) {
            executeInfo.timeout = ((DmlSqlConfig)dynamicSql).getTimeout();
            boolean bl = executeInfo.hasSelectKey = ((DmlSqlConfig)dynamicSql).getSelectKey() != null;
        }
        if (dynamicSql instanceof QuerySqlConfig) {
            executeInfo.resultMap = ((QuerySqlConfig)dynamicSql).getResultMap();
            executeInfo.resultType = ((QuerySqlConfig)dynamicSql).getResultType();
            executeInfo.fetchSize = ((QuerySqlConfig)dynamicSql).getFetchSize();
            executeInfo.resultSetType = ((QuerySqlConfig)dynamicSql).getResultSetType();
            executeInfo.multipleResultType = ((QuerySqlConfig)dynamicSql).getMultipleResultType();
        }
        if (dynamicSql instanceof InsertSqlConfig && !executeInfo.hasSelectKey) {
            executeInfo.useGeneratedKeys = ((InsertSqlConfig)dynamicSql).isUseGeneratedKeys();
            executeInfo.keyProperty = ((InsertSqlConfig)dynamicSql).getKeyProperty();
            executeInfo.parameterType = ((InsertSqlConfig)dynamicSql).getParameterType();
        }
        if (resultAsMap) {
            executeInfo.resultType = Map.class.getName();
            executeInfo.resultMap = "";
        }
        return this.executeQuery(conn, executeInfo, queryBuilder);
    }

    protected boolean usingPage(ExecuteInfo executeInfo) {
        return executeInfo.pageInfo != null && executeInfo.pageInfo.getPageSize() > 0L;
    }

    protected boolean refreshTotalCount(ExecuteInfo executeInfo) {
        return executeInfo.pageInfo.isRefreshTotalCount() || executeInfo.pageInfo.getTotalCount() <= 0L;
    }

    protected abstract T executeQuery(Connection var1, ExecuteInfo var2, SqlBuilder var3) throws SQLException;

    protected void configStatement(ExecuteInfo executeInfo, Statement statement) throws SQLException {
        if (executeInfo.timeout > 0) {
            statement.setQueryTimeout(executeInfo.timeout);
        }
        if (executeInfo.fetchSize > 0) {
            statement.setFetchSize(executeInfo.fetchSize);
        }
    }

    protected DalResultSetExtractor buildExtractor(ExecuteInfo executeInfo) {
        TableReader[] tableReaders = null;
        if (StringUtils.isBlank((String)executeInfo.resultType) && StringUtils.isBlank((String)executeInfo.resultMap)) {
            tableReaders = new TableReader[]{this.getDefaultTableReader(executeInfo, this.context)};
        } else if (StringUtils.isNotBlank((String)executeInfo.resultType)) {
            String[] resultTypeSplit = executeInfo.resultType.split(",");
            tableReaders = new TableReader[resultTypeSplit.length];
            for (int i = 0; i < resultTypeSplit.length; ++i) {
                if (StringUtils.isBlank((String)resultTypeSplit[i])) {
                    throw new NullPointerException("resultType is blank '" + resultTypeSplit[i] + "' of '" + executeInfo.resultType + "'");
                }
                tableReaders[i] = this.context.findTableReader(resultTypeSplit[i]);
                if (tableReaders[i] != null) continue;
                throw new NoSuchElementException("not found resultType '" + resultTypeSplit[i] + "' of '" + executeInfo.resultType + "'");
            }
        } else if (StringUtils.isNotBlank((String)executeInfo.resultMap)) {
            String[] resultMapSplit = executeInfo.resultMap.split(",");
            tableReaders = new TableReader[resultMapSplit.length];
            for (int i = 0; i < resultMapSplit.length; ++i) {
                if (StringUtils.isBlank((String)resultMapSplit[i])) {
                    throw new NullPointerException("resultMap is blank '" + resultMapSplit[i] + "' of '" + executeInfo.resultMap + "'");
                }
                TableMapping<?> tableMapping = this.context.findTableMapping(resultMapSplit[i]);
                if (tableMapping == null) {
                    throw new NoSuchElementException("not found resultMap '" + resultMapSplit[i] + "' of '" + executeInfo.resultMap + "'");
                }
                tableReaders[i] = tableMapping.toReader();
            }
        } else {
            throw new IllegalStateException("doesn't trigger here");
        }
        MultipleProcessType multipleType = MultipleProcessType.valueOf(executeInfo.multipleResultType.getTypeName());
        return new DalResultSetExtractor(executeInfo.caseInsensitive, this.context, multipleType, tableReaders);
    }

    private ResultTableReader getDefaultTableReader(ExecuteInfo executeInfo, DynamicContext context) {
        return new ResultTableReader(executeInfo.caseInsensitive, context.getTypeRegistry());
    }

    protected Object getResult(List<Object> result, ExecuteInfo executeInfo) {
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (executeInfo.multipleResultType == MultipleResultsType.FIRST) {
            return result.get(0);
        }
        if (executeInfo.multipleResultType == MultipleResultsType.LAST) {
            return result.get(result.size() - 1);
        }
        return result;
    }

    protected List<SqlArg> toArgs(BoundSql boundSql) {
        Object[] oriArgs = boundSql.getArgs();
        return Arrays.stream(oriArgs).map(o -> {
            if (o instanceof SqlArg) {
                return (SqlArg)o;
            }
            SqlArg sqlArg = SqlArg.valueOf(o);
            sqlArg.setSqlMode(SqlMode.In);
            if (o == null) {
                sqlArg.setTypeHandler(this.getContext().getTypeRegistry().getDefaultTypeHandler());
                sqlArg.setJdbcType(0);
            } else {
                sqlArg.setTypeHandler(this.getContext().findTypeHandler(o.getClass()));
                sqlArg.setJdbcType(TypeHandlerRegistry.toSqlType(o.getClass()));
            }
            return sqlArg;
        }).collect(Collectors.toList());
    }

    protected static StringBuilder fmtBoundSql(BoundSql boundSql) {
        StringBuilder builder = new StringBuilder("querySQL: ");
        try {
            List lines = IOUtils.readLines((Reader)new StringReader(boundSql.getSqlString()));
            for (String line : lines) {
                if (!StringUtils.isNotBlank((String)line)) continue;
                builder.append(line.trim()).append(" ");
            }
        }
        catch (Exception e) {
            builder.append(boundSql.getSqlString().replace("\n", ""));
        }
        builder.append(" ");
        builder.append(",parameter: [");
        int i = 0;
        for (Object arg : boundSql.getArgs()) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(AbstractStatementExecute.fmtValue(arg));
            ++i;
        }
        builder.append("] ");
        return builder;
    }

    protected static String fmtBoundSql(BoundSql boundSql, Map<String, Object> userData) {
        StringBuilder builder = AbstractStatementExecute.fmtBoundSql(boundSql);
        builder.append(",userData: {");
        int j = 0;
        for (String key : userData.keySet()) {
            if (j > 0) {
                builder.append(", ");
            }
            builder.append(key);
            builder.append(" = ");
            builder.append(AbstractStatementExecute.fmtValue(userData.get(key)));
            ++j;
        }
        builder.append("}");
        return builder.toString();
    }

    protected static String fmtValue(Object value) {
        Object object;
        Object object2 = object = value instanceof SqlArg ? ((SqlArg)value).getValue() : value;
        if (object == null) {
            return "null";
        }
        if (object instanceof String) {
            if (((String)object).length() > 2048) {
                return "'" + ((String)object).substring(0, 2048) + "...'";
            }
            return "'" + ((String)object).replace("'", "\\'") + "'";
        }
        if (object instanceof Page) {
            return "page[pageSize=" + ((Page)object).getPageSize() + ", currentPage=" + ((Page)object).getCurrentPage() + ", pageNumberOffset=" + ((Page)object).getPageNumberOffset() + "]";
        }
        return object.toString();
    }

    protected static class ExecuteInfo {
        public int timeout = -1;
        public int fetchSize = 256;
        public ResultSetType resultSetType = ResultSetType.FORWARD_ONLY;
        public String resultType;
        public String resultMap;
        public boolean caseInsensitive = true;
        public MultipleResultsType multipleResultType = MultipleResultsType.LAST;
        public boolean hasSelectKey;
        public boolean useGeneratedKeys;
        public String keyProperty;
        public String parameterType;
        public Page pageInfo;
        public PageSqlDialect pageDialect;
        public boolean pageResult;
        public Map<String, Object> data;

        protected ExecuteInfo() {
        }
    }
}

