/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.execute;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import net.hasor.dbvisitor.dal.dynamic.DynamicContext;
import net.hasor.dbvisitor.dal.dynamic.SqlArg;
import net.hasor.dbvisitor.dal.dynamic.SqlMode;
import net.hasor.dbvisitor.dal.execute.AbstractStatementExecute;
import net.hasor.dbvisitor.dal.execute.DalResultSetExtractor;
import net.hasor.dbvisitor.dal.repository.ResultSetType;
import net.hasor.dbvisitor.dialect.BoundSql;
import net.hasor.dbvisitor.dialect.SqlBuilder;
import net.hasor.dbvisitor.jars.OgnlUtils;
import net.hasor.dbvisitor.types.TypeHandler;

public class CallableStatementExecute
extends AbstractStatementExecute<Object> {
    public CallableStatementExecute(DynamicContext context) {
        super(context);
    }

    protected CallableStatement createCallableStatement(Connection conn, String queryString, ResultSetType resultSetType) throws SQLException {
        if (resultSetType == null || resultSetType.getResultSetType() == null) {
            return conn.prepareCall(queryString);
        }
        int resultSetTypeInt = resultSetType.getResultSetType();
        return conn.prepareCall(queryString, resultSetTypeInt, 1007);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object executeQuery(Connection con, AbstractStatementExecute.ExecuteInfo executeInfo, SqlBuilder boundSql) throws SQLException {
        if (!con.getMetaData().supportsStoredProcedures()) {
            throw new UnsupportedOperationException("procedure DataSource Unsupported.");
        }
        if (this.usingPage(executeInfo)) {
            throw new UnsupportedOperationException("procedure does not support page query.");
        }
        String querySQL = boundSql.getSqlString();
        try (CallableStatement ps = this.createCallableStatement(con, querySQL, executeInfo.resultSetType);){
            this.configStatement(executeInfo, ps);
            Object object = this.executeQuery(ps, executeInfo, (BoundSql)boundSql);
            return object;
        }
        catch (SQLException e) {
            logger.error("executeQuery failed, " + CallableStatementExecute.fmtBoundSql(boundSql, executeInfo.data), (Throwable)e);
            throw e;
        }
    }

    protected Object executeQuery(CallableStatement cs, AbstractStatementExecute.ExecuteInfo executeInfo, BoundSql queryBuilder) throws SQLException {
        SqlArg arg;
        List<SqlArg> sqlArgs = this.toArgs(queryBuilder);
        block5: for (int i = 0; i < sqlArgs.size(); ++i) {
            int sqlColIndex = i + 1;
            arg = sqlArgs.get(i);
            TypeHandler<?> typeHandler = arg.getTypeHandler();
            switch (arg.getSqlMode()) {
                case In: {
                    typeHandler.setParameter(cs, sqlColIndex, arg.getValue(), arg.getJdbcType());
                    continue block5;
                }
                case InOut: {
                    typeHandler.setParameter(cs, sqlColIndex, arg.getValue(), arg.getJdbcType());
                    cs.registerOutParameter(sqlColIndex, (int)arg.getJdbcType());
                    continue block5;
                }
                case Out: {
                    cs.registerOutParameter(sqlColIndex, (int)arg.getJdbcType());
                }
            }
        }
        boolean retVal = cs.execute();
        for (int i = 0; i < sqlArgs.size(); ++i) {
            arg = sqlArgs.get(i);
            TypeHandler<?> argHandler = arg.getTypeHandler();
            if (arg.getSqlMode() != SqlMode.Out) continue;
            if (arg.getJdbcType() == 2012) {
                throw new UnsupportedOperationException("Types.REF_CURSOR Unsupported.");
            }
            String expr = arg.getExpr();
            Object resultValue = argHandler.getResult(cs, i + 1);
            OgnlUtils.writeByExpr(expr, executeInfo.data, resultValue);
        }
        DalResultSetExtractor extractor = super.buildExtractor(executeInfo);
        List<Object> resultSet = extractor.doResult(retVal, cs);
        return this.getResult(resultSet, executeInfo);
    }
}

