/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.execute;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.dbvisitor.dal.dynamic.DynamicContext;
import net.hasor.dbvisitor.dal.dynamic.SqlArg;
import net.hasor.dbvisitor.dal.execute.AbstractStatementExecute;
import net.hasor.dbvisitor.dal.execute.DalResultSetExtractor;
import net.hasor.dbvisitor.dal.repository.ResultSetType;
import net.hasor.dbvisitor.dialect.BoundSql;
import net.hasor.dbvisitor.dialect.PageSqlDialect;
import net.hasor.dbvisitor.dialect.SqlBuilder;
import net.hasor.dbvisitor.page.PageResult;
import net.hasor.dbvisitor.types.TypeHandler;

public class PreparedStatementExecute
extends AbstractStatementExecute<Object> {
    public PreparedStatementExecute(DynamicContext context) {
        super(context);
    }

    protected PreparedStatement createPreparedStatement(Connection conn, String queryString, ResultSetType resultSetType) throws SQLException {
        if (resultSetType == null || resultSetType.getResultSetType() == null) {
            return conn.prepareStatement(queryString);
        }
        int resultSetTypeInt = resultSetType.getResultSetType();
        return conn.prepareStatement(queryString, resultSetTypeInt, 1007);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object executeQuery(Connection con, AbstractStatementExecute.ExecuteInfo executeInfo, SqlBuilder sqlBuilder) throws SQLException {
        Object resultData;
        BoundSql boundSql = sqlBuilder;
        BoundSql countSql = null;
        long resultCount = 0L;
        if (this.usingPage(executeInfo)) {
            PageSqlDialect dialect = executeInfo.pageDialect;
            long position = executeInfo.pageInfo.getFirstRecordPosition();
            long pageSize = executeInfo.pageInfo.getPageSize();
            boundSql = dialect.pageSql(sqlBuilder, position, pageSize);
            if (this.refreshTotalCount(executeInfo)) {
                countSql = dialect.countSql(sqlBuilder);
            }
            resultCount = executeInfo.pageInfo.getTotalCount();
            if (countSql != null) {
                try (PreparedStatement ps2 = this.createPreparedStatement(con, countSql.getSqlString(), executeInfo.resultSetType);){
                    this.configStatement(executeInfo, ps2);
                    resultCount = this.executeCount(ps2, countSql);
                    executeInfo.pageInfo.setTotalCount(resultCount);
                }
                catch (SQLException e) {
                    logger.error("executeCount failed, " + ExceptionUtils.getRootCauseMessage((Throwable)e) + ", " + PreparedStatementExecute.fmtBoundSql(countSql, executeInfo.data), (Throwable)e);
                    throw e;
                }
            }
        }
        try (PreparedStatement ps = this.createPreparedStatement(con, boundSql.getSqlString(), executeInfo.resultSetType);){
            this.configStatement(executeInfo, ps);
            resultData = this.executeQuery(ps, executeInfo, boundSql);
            if (!executeInfo.pageResult) {
                Object object = resultData;
                return object;
            }
        }
        catch (SQLException e) {
            logger.error("executeQuery failed, " + ExceptionUtils.getRootCauseMessage((Throwable)e) + ", " + PreparedStatementExecute.fmtBoundSql(boundSql, executeInfo.data), (Throwable)e);
            throw e;
        }
        List<Object> records = resultData instanceof List ? (List<Object>)resultData : Collections.singletonList(resultData);
        PageResult<Object> pageResult = new PageResult<Object>(executeInfo.pageInfo.getPageSize(), resultCount, records);
        pageResult.setPageNumberOffset(executeInfo.pageInfo.getPageNumberOffset());
        pageResult.setCurrentPage(executeInfo.pageInfo.getCurrentPage());
        return pageResult;
    }

    protected void statementSet(PreparedStatement ps, BoundSql boundSql) throws SQLException {
        List<SqlArg> sqlArgs = this.toArgs(boundSql);
        for (int i = 0; i < sqlArgs.size(); ++i) {
            SqlArg arg = sqlArgs.get(i);
            TypeHandler<?> typeHandler = arg.getTypeHandler();
            typeHandler.setParameter(ps, i + 1, arg.getValue(), arg.getJdbcType());
        }
    }

    protected Object executeQuery(PreparedStatement ps, AbstractStatementExecute.ExecuteInfo executeInfo, BoundSql boundSql) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace(PreparedStatementExecute.fmtBoundSql(boundSql).toString());
        }
        this.statementSet(ps, boundSql);
        DalResultSetExtractor extractor = super.buildExtractor(executeInfo);
        boolean retVal = ps.execute();
        List<Object> result = extractor.doResult(retVal, ps);
        return this.getResult(result, executeInfo);
    }

    protected int executeCount(PreparedStatement ps, BoundSql boundSql) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace(PreparedStatementExecute.fmtBoundSql(boundSql).toString());
        }
        this.statementSet(ps, boundSql);
        try (ResultSet resultSet = ps.executeQuery();){
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            int n = -1;
            return n;
        }
    }
}

