/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.execute;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import net.hasor.dbvisitor.dal.dynamic.DynamicContext;
import net.hasor.dbvisitor.dal.execute.AbstractStatementExecute;
import net.hasor.dbvisitor.dal.execute.DalResultSetExtractor;
import net.hasor.dbvisitor.dal.repository.ResultSetType;
import net.hasor.dbvisitor.dialect.BoundSql;
import net.hasor.dbvisitor.dialect.SqlBuilder;

public class StatementExecute
extends AbstractStatementExecute<Object> {
    public StatementExecute(DynamicContext context) {
        super(context);
    }

    protected Statement createStatement(Connection conn, ResultSetType resultSetType) throws SQLException {
        if (resultSetType == null || resultSetType.getResultSetType() == null) {
            return conn.createStatement();
        }
        int resultSetTypeInt = resultSetType.getResultSetType();
        return conn.createStatement(resultSetTypeInt, 1007);
    }

    @Override
    protected Object executeQuery(Connection con, AbstractStatementExecute.ExecuteInfo executeInfo, SqlBuilder sqlBuilder) throws SQLException {
        if (this.usingPage(executeInfo)) {
            throw new UnsupportedOperationException("Statement does not support page query, please using PreparedStatement.");
        }
        try (Statement stat = this.createStatement(con, executeInfo.resultSetType);){
            this.configStatement(executeInfo, stat);
            Object object = this.executeQuery(stat, executeInfo, (BoundSql)sqlBuilder);
            return object;
        }
    }

    protected Object executeQuery(Statement statement, AbstractStatementExecute.ExecuteInfo executeInfo, BoundSql boundSql) throws SQLException {
        boolean retVal;
        if (logger.isTraceEnabled()) {
            logger.trace(StatementExecute.fmtBoundSql(boundSql).toString());
        }
        String querySQL = boundSql.getSqlString();
        DalResultSetExtractor extractor = super.buildExtractor(executeInfo);
        try {
            retVal = statement.execute(querySQL);
        }
        catch (SQLException e) {
            logger.error("executeQuery failed, " + StatementExecute.fmtBoundSql(boundSql, executeInfo.data), (Throwable)e);
            throw e;
        }
        List<Object> result = extractor.doResult(retVal, statement);
        return this.getResult(result, executeInfo);
    }
}

