/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.mapper;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import net.hasor.dbvisitor.dal.mapper.Mapper;
import net.hasor.dbvisitor.dal.session.DalSession;
import net.hasor.dbvisitor.dal.session.RuntimeSQLException;
import net.hasor.dbvisitor.lambda.EntityDeleteOperation;
import net.hasor.dbvisitor.lambda.EntityQueryOperation;
import net.hasor.dbvisitor.lambda.EntityUpdateOperation;
import net.hasor.dbvisitor.lambda.InsertOperation;
import net.hasor.dbvisitor.lambda.LambdaTemplate;
import net.hasor.dbvisitor.page.Page;
import net.hasor.dbvisitor.page.PageResult;

public interface BaseMapper<T>
extends Mapper {
    public Class<T> entityType();

    public LambdaTemplate template();

    public DalSession getSession();

    default public InsertOperation<T> insert() {
        return this.template().lambdaInsert(this.entityType());
    }

    default public EntityDeleteOperation<T> delete() {
        return this.template().lambdaDelete(this.entityType());
    }

    default public EntityUpdateOperation<T> update() {
        return this.template().lambdaUpdate(this.entityType());
    }

    default public EntityQueryOperation<T> query() {
        return this.template().lambdaQuery(this.entityType());
    }

    default public int executeStatement(String stId, Object parameter) throws RuntimeSQLException {
        try {
            return this.getSession().executeStatement(stId, parameter);
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    default public <E> List<E> queryStatement(String stId, Object parameter) throws RuntimeSQLException {
        return this.queryStatement(stId, parameter, null);
    }

    default public <E> List<E> queryStatement(String stId, Object parameter, Page page) throws RuntimeSQLException {
        try {
            return this.getSession().queryStatement(stId, parameter, page);
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    default public int insert(T entity) throws RuntimeSQLException {
        try {
            return ((InsertOperation)this.insert().applyEntity(entity)).executeSumResult();
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    default public int insert(List<T> entity) throws RuntimeSQLException {
        try {
            return ((InsertOperation)this.insert().applyEntity(entity)).executeSumResult();
        }
        catch (SQLException e) {
            throw new RuntimeSQLException(e);
        }
    }

    public int updateById(T var1) throws RuntimeSQLException;

    public int upsertById(T var1) throws RuntimeSQLException;

    public int updateByMap(Map<String, Object> var1) throws RuntimeSQLException;

    public int delete(T var1) throws RuntimeSQLException;

    public int deleteById(Serializable var1) throws RuntimeSQLException;

    public int deleteByIds(List<? extends Serializable> var1) throws RuntimeSQLException;

    public T selectById(Serializable var1) throws RuntimeSQLException;

    public List<T> selectByIds(List<? extends Serializable> var1) throws RuntimeSQLException;

    public List<T> listBySample(T var1) throws RuntimeSQLException;

    public int countBySample(T var1) throws RuntimeSQLException;

    public int countAll() throws RuntimeSQLException;

    public PageResult<T> pageBySample(Object var1, Page var2) throws RuntimeSQLException;

    default public Page initPageBySample(Object sample, int pageSize) throws RuntimeSQLException {
        return this.initPageBySample(sample, pageSize, 0);
    }

    public Page initPageBySample(Object var1, int var2, int var3) throws RuntimeSQLException;
}

