/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.repository;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.ParserConfigurationException;
import net.hasor.cobble.ClassUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.reflect.resolvable.ResolvableType;
import net.hasor.dbvisitor.dal.dynamic.DynamicSql;
import net.hasor.dbvisitor.dal.dynamic.rule.RuleRegistry;
import net.hasor.dbvisitor.dal.mapper.BaseMapper;
import net.hasor.dbvisitor.dal.repository.DalMapper;
import net.hasor.dbvisitor.dal.repository.Query;
import net.hasor.dbvisitor.dal.repository.RefMapper;
import net.hasor.dbvisitor.dal.repository.config.QuerySqlConfig;
import net.hasor.dbvisitor.dal.repository.parser.ClassDynamicResolve;
import net.hasor.dbvisitor.dal.repository.parser.DynamicResolve;
import net.hasor.dbvisitor.dal.repository.parser.XmlDynamicResolve;
import net.hasor.dbvisitor.mapping.MappingRegistry;
import net.hasor.dbvisitor.mapping.TableReader;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.mapping.reader.ResultTableReader;
import net.hasor.dbvisitor.mapping.resolve.MappingOptions;
import net.hasor.dbvisitor.types.TypeHandler;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DalRegistry
extends MappingRegistry {
    public static final DalRegistry DEFAULT = new DalRegistry(null, null, null, MappingOptions.buildNew());
    private final Map<String, Map<String, DynamicSql>> dynamicMap = new ConcurrentHashMap<String, Map<String, DynamicSql>>();
    private final Map<String, Map<String, TableReader<?>>> readerCacheMap = new ConcurrentHashMap();
    private final RuleRegistry ruleRegistry;

    public DalRegistry() {
        this(null, null, null, null);
    }

    public DalRegistry(MappingOptions options) {
        this(null, null, null, options);
    }

    public DalRegistry(ClassLoader classLoader, TypeHandlerRegistry typeRegistry, RuleRegistry ruleRegistry, MappingOptions options) {
        super(classLoader, typeRegistry, options);
        this.ruleRegistry = ruleRegistry == null ? RuleRegistry.DEFAULT : ruleRegistry;
        this.initReaderCacheMap();
    }

    private void initReaderCacheMap() {
        Map cacheMap = this.readerCacheMap.computeIfAbsent("", s -> new ConcurrentHashMap());
        for (String javaType : this.typeRegistry.getHandlerJavaTypes()) {
            TypeHandler<?> typeHandler = this.typeRegistry.getTypeHandler(javaType);
            TableReader<Object> tableReader = (columns, rs, rowNum) -> typeHandler.getResult(rs, 1);
            cacheMap.put(javaType, tableReader);
        }
        boolean caseInsensitive = this.global == null || this.global.getCaseInsensitive() == null || Boolean.TRUE.equals(this.global.getCaseInsensitive());
        ResultTableReader mapReader = new ResultTableReader(caseInsensitive, this.typeRegistry);
        cacheMap.put(Map.class.getName(), mapReader);
        cacheMap.put(Map.class.getSimpleName(), mapReader);
        cacheMap.put(StringUtils.firstCharToLowerCase((String)Map.class.getSimpleName()), mapReader);
    }

    public RuleRegistry getRuleRegistry() {
        return this.ruleRegistry;
    }

    public boolean hasScope(Class<?> space) {
        return this.hasScope(space == null ? "" : space.getName());
    }

    public boolean hasScope(String space) {
        return this.dynamicMap.containsKey(space);
    }

    public DynamicSql findDynamicSql(Class<?> space, String dynamicId) {
        return this.findDynamicSql(space == null ? "" : space.getName(), dynamicId);
    }

    public DynamicSql findDynamicSql(String space, String dynamicId) {
        space = StringUtils.isBlank((String)space) ? "" : space;
        Objects.requireNonNull(dynamicId, "'dynamicId' cannot be null.");
        Map<String, DynamicSql> dynamicSqlMap = this.dynamicMap.get(space);
        if (dynamicSqlMap == null) {
            return null;
        }
        return dynamicSqlMap.get(dynamicId);
    }

    @Override
    public <T> TableMapping<T> findMapping(String space, String identify) {
        space = StringUtils.isBlank((String)space) ? "" : space;
        Objects.requireNonNull(identify, "'identify' cannot be null.");
        TableMapping mapping = super.findMapping(space, identify);
        if (mapping != null) {
            return mapping;
        }
        if (StringUtils.isNotBlank((String)space)) {
            return super.findMapping("", identify);
        }
        return this != DEFAULT ? DEFAULT.findMapping(space, identify) : null;
    }

    public <T> TableMapping<T> findMapping(String space, Class<?> type) {
        String[] names;
        space = StringUtils.isBlank((String)space) ? "" : space;
        for (String name : names = new String[]{type.getName(), type.getSimpleName(), StringUtils.firstCharToLowerCase((String)type.getSimpleName())}) {
            TableMapping<T> mapping = this.findMapping(space, name);
            if (mapping == null) continue;
            return mapping;
        }
        return null;
    }

    public <T> TableReader<T> findTableReader(String space, String identify) {
        Map<String, TableReader<?>> readerMap;
        space = StringUtils.isBlank((String)space) ? "" : space;
        Objects.requireNonNull(identify, "'identify' cannot be null.");
        if (this.readerCacheMap.containsKey(space) && (readerMap = this.readerCacheMap.get(space)).containsKey(identify)) {
            return readerMap.get(identify);
        }
        if (!StringUtils.equals((String)space, (String)"") && (readerMap = this.readerCacheMap.get("")).containsKey(identify)) {
            return readerMap.get(identify);
        }
        TableMapping mapping = super.findMapping(space, identify);
        if (mapping != null) {
            Map map = this.readerCacheMap.computeIfAbsent(space, s -> new ConcurrentHashMap());
            TableReader tableReader = mapping.toReader();
            map.put(identify, tableReader);
            return tableReader;
        }
        mapping = super.findMapping("", identify);
        if (mapping != null) {
            Map map = this.readerCacheMap.computeIfAbsent("", s -> new ConcurrentHashMap());
            TableReader tableReader = mapping.toReader();
            map.put(identify, tableReader);
            return tableReader;
        }
        return this != DEFAULT ? DEFAULT.findTableReader(space, identify) : null;
    }

    public void loadMapper(Class<?> refRepository) throws IOException, ReflectiveOperationException {
        Annotation[] annotations;
        if (!refRepository.isInterface()) {
            throw new UnsupportedOperationException("the '" + refRepository.getName() + "' must interface.");
        }
        String namespace = refRepository.getName();
        boolean simpleMapper = false;
        for (Annotation annotation : annotations = refRepository.getDeclaredAnnotations()) {
            if (!(annotation instanceof DalMapper) && annotation.annotationType().getAnnotation(DalMapper.class) == null) continue;
            simpleMapper = true;
            break;
        }
        if (!simpleMapper) {
            throw new UnsupportedOperationException("type '" + refRepository.getName() + "' need @RefMapper or @SimpleMapper or @DalMapper");
        }
        RefMapper refMapper = refRepository.getAnnotation(RefMapper.class);
        if (refMapper != null) {
            String resource = refMapper.value();
            if (StringUtils.isBlank((String)resource)) {
                resource = refRepository.getName().replace('.', '/') + ".xml";
            }
            if (resource.startsWith("/")) {
                resource = resource.substring(1);
            }
            if (StringUtils.isBlank((String)resource) && !ClassDynamicResolve.matchType(refRepository)) {
                return;
            }
            if (StringUtils.isNotBlank((String)resource)) {
                try {
                    Throwable throwable = null;
                    try (InputStream stream = this.classLoader.getResourceAsStream(resource);){
                        if (stream == null) {
                            return;
                        }
                        Document document = this.loadXmlRoot(stream);
                        Element root = document.getDocumentElement();
                        this.loadReader(namespace, root);
                        this.loadDynamic(namespace, root);
                    }
                    catch (Throwable document) {
                        Throwable throwable2 = document;
                        throw document;
                    }
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new IOException(e);
                }
            }
        }
        Method[] dalTypeMethods = refRepository.getMethods();
        DynamicResolve<Method> resolve = this.getMethodDynamicResolve();
        for (Method method : dalTypeMethods) {
            if (!ClassDynamicResolve.matchMethod(method)) continue;
            Class<?> resultType = null;
            for (Annotation anno : method.getAnnotations()) {
                if (!(anno instanceof Query)) continue;
                resultType = ((Query)anno).resultType();
                break;
            }
            Class<?> clazz = resultType = resultType == Object.class ? null : resultType;
            if (resultType != null && this.findTableReader(namespace, resultType.getName()) == null) {
                this.asResultMap(namespace, resultType);
            }
            String identify = method.getName();
            DynamicSql dynamicSql = resolve.parseSqlConfig(method);
            if (dynamicSql == null) continue;
            this.saveDynamic(namespace, identify, dynamicSql);
        }
        if (BaseMapper.class.isAssignableFrom(refRepository)) {
            ResolvableType resolvableType = ResolvableType.forClass(refRepository).as(BaseMapper.class);
            Class[] generics = resolvableType.resolveGenerics(Object.class);
            Class entityType = generics[0];
            Class clazz = entityType = entityType == Object.class ? null : entityType;
            if (entityType != null && this.findEntity(entityType) == null) {
                this.loadEntity(entityType.getName(), entityType);
            }
        }
    }

    @Override
    public void loadMapper(InputStream stream) throws IOException, ReflectiveOperationException {
        Objects.requireNonNull(stream, "load InputStream is null.");
        try {
            Document document = this.loadXmlRoot(stream);
            Element root = document.getDocumentElement();
            NamedNodeMap rootAttributes = root.getAttributes();
            String namespace = this.readAttribute("namespace", rootAttributes);
            namespace = StringUtils.isBlank((String)namespace) ? "" : namespace;
            this.loadReader(namespace, root);
            this.loadDynamic(namespace, root);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    private void loadDynamic(String space, Element configRoot) throws IOException, ClassNotFoundException {
        NodeList childNodes = configRoot.getChildNodes();
        DynamicResolve<Node> resolve = this.getXmlDynamicResolve();
        int len = childNodes.getLength();
        for (int i = 0; i < len; ++i) {
            String idString;
            Node node = childNodes.item(i);
            String elementName = node.getNodeName();
            if (node.getNodeType() != 1) continue;
            boolean isResultMap = StringUtils.equalsIgnoreCase((String)"resultMap", (String)elementName);
            boolean isEntity = StringUtils.equalsIgnoreCase((String)"entity", (String)elementName);
            if (isResultMap || isEntity) continue;
            NamedNodeMap nodeAttributes = node.getAttributes();
            Node idNode = nodeAttributes.getNamedItem("id");
            String string = idString = idNode != null ? idNode.getNodeValue() : null;
            if (StringUtils.isBlank((String)idString)) {
                throw new IOException("the <" + node.getNodeName() + "> tag is missing an ID.");
            }
            DynamicSql dynamicSql = resolve.parseSqlConfig(node);
            if (dynamicSql instanceof QuerySqlConfig) {
                String resultMap = ((QuerySqlConfig)dynamicSql).getResultMap();
                String resultType = ((QuerySqlConfig)dynamicSql).getResultType();
                if (StringUtils.isNotBlank((String)resultMap)) {
                    String[] tableMappings;
                    for (String mapping : tableMappings = resultMap.split(",")) {
                        if (this.findMapping(space, mapping) != null) continue;
                        throw new IOException("loadMapper failed, '" + idString + "', resultMap/entity '" + resultMap + "' is undefined ,resource '" + space + "'");
                    }
                }
                if (StringUtils.isNotBlank((String)resultType)) {
                    String[] resultTypes;
                    for (String type : resultTypes = resultType.split(",")) {
                        if (this.findTableReader(space, type) != null) continue;
                        Class resultClass = ClassUtils.getClass((ClassLoader)this.getClassLoader(), (String)type);
                        this.asResultMap(space, resultClass);
                    }
                }
            }
            if (dynamicSql == null) continue;
            this.saveDynamic(space, idString, dynamicSql);
        }
    }

    private void asResultMap(String space, Class<?> resultClass) {
        TableReader<Object> tableReader;
        String identify = resultClass.getName();
        if (this.typeRegistry.hasTypeHandler(resultClass)) {
            TypeHandler<?> typeHandler = this.typeRegistry.getTypeHandler(resultClass);
            tableReader = (columns, rs, rowNum) -> typeHandler.getResult(rs, 1);
        } else {
            super.loadResultMap(space, resultClass.getSimpleName(), resultClass);
            TableMapping mapping = super.findMapping(space, resultClass.getSimpleName());
            tableReader = mapping.toReader();
        }
        Map map = this.readerCacheMap.computeIfAbsent(space, s -> new ConcurrentHashMap());
        map.put(identify, tableReader);
    }

    protected void saveDynamic(String space, String identify, DynamicSql dynamicSql) throws IOException {
        Map<String, DynamicSql> sqlMap;
        Objects.requireNonNull(identify, "'identify' cannot be null.");
        if (identify.contains(".")) {
            throw new IllegalStateException("identify cannot contain the character '.'");
        }
        String string = space = StringUtils.isBlank((String)space) ? "" : space;
        if (!this.dynamicMap.containsKey(space)) {
            this.dynamicMap.put(space, new ConcurrentHashMap());
        }
        if ((sqlMap = this.dynamicMap.get(space)).containsKey(identify)) {
            throw new IOException("repeat '" + identify + "' in " + (StringUtils.isBlank((String)space) ? "default namespace" : "'" + space + "' namespace."));
        }
        sqlMap.put(identify, dynamicSql);
    }

    protected DynamicResolve<Method> getMethodDynamicResolve() {
        return new ClassDynamicResolve();
    }

    protected DynamicResolve<Node> getXmlDynamicResolve() {
        return new XmlDynamicResolve();
    }
}

