/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.repository.parser;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.dal.dynamic.DynamicParser;
import net.hasor.dbvisitor.dal.dynamic.DynamicSql;
import net.hasor.dbvisitor.dal.repository.QueryType;
import net.hasor.dbvisitor.dal.repository.config.DeleteSqlConfig;
import net.hasor.dbvisitor.dal.repository.config.InsertSqlConfig;
import net.hasor.dbvisitor.dal.repository.config.QuerySqlConfig;
import net.hasor.dbvisitor.dal.repository.config.SegmentSqlConfig;
import net.hasor.dbvisitor.dal.repository.config.UpdateSqlConfig;
import net.hasor.dbvisitor.dal.repository.parser.DynamicResolve;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlDynamicResolve
extends DynamicParser
implements DynamicResolve<Node> {
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();

    @Override
    public DynamicSql parseSqlConfig(String sqlString) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder documentBuilder = FACTORY.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(new StringReader(sqlString)));
        Element root = document.getDocumentElement();
        return this.parseSqlConfig(root);
    }

    @Override
    public DynamicSql parseSqlConfig(Node configNode) {
        QueryType queryType = this.getQueryType(configNode.getNodeName().toLowerCase().trim());
        if (queryType == null) {
            return null;
        }
        DynamicSql dynamicSql = super.parseDynamicSql(configNode);
        if (dynamicSql == null) {
            return null;
        }
        switch (queryType) {
            case Insert: {
                return new InsertSqlConfig(dynamicSql, configNode);
            }
            case Delete: {
                return new DeleteSqlConfig(dynamicSql, configNode);
            }
            case Update: {
                return new UpdateSqlConfig(dynamicSql, configNode);
            }
            case Query: {
                return new QuerySqlConfig(dynamicSql, configNode);
            }
            case Segment: {
                return new SegmentSqlConfig(dynamicSql);
            }
        }
        throw new UnsupportedOperationException("queryType '" + queryType.name() + "' Unsupported.");
    }

    protected QueryType getQueryType(String elementName) {
        if (StringUtils.isBlank((String)elementName)) {
            throw new UnsupportedOperationException("tag name is Empty.");
        }
        return QueryType.valueOfTag(elementName);
    }
}

