/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dal.session;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.convert.ConverterBean;
import net.hasor.cobble.ref.BeanMap;
import net.hasor.dbvisitor.dal.dynamic.DynamicSql;
import net.hasor.dbvisitor.dal.execute.ExecuteProxy;
import net.hasor.dbvisitor.dal.mapper.BaseMapper;
import net.hasor.dbvisitor.dal.repository.DalRegistry;
import net.hasor.dbvisitor.dal.repository.Param;
import net.hasor.dbvisitor.dal.session.BaseMapperHandler;
import net.hasor.dbvisitor.dal.session.DalContext;
import net.hasor.dbvisitor.dal.session.DalSession;
import net.hasor.dbvisitor.dal.session.MergedMap;
import net.hasor.dbvisitor.dialect.PageSqlDialect;
import net.hasor.dbvisitor.page.Page;
import net.hasor.dbvisitor.page.PageResult;

class ExecuteInvocationHandler
implements InvocationHandler {
    private final String space;
    private final DalSession dalSession;
    private final Map<String, ExecuteProxy> dynamicSqlMap = new HashMap<String, ExecuteProxy>();
    private final Map<String, Integer> pageInfoMap = new HashMap<String, Integer>();
    private final Map<String, Map<String, Integer>> argNamesMap = new HashMap<String, Map<String, Integer>>();
    private final BaseMapperHandler mapperHandler;
    private static final Constructor<MethodHandles.Lookup> lookupConstructor;
    private static final Method privateLookupInMethod;
    private static final int ALLOWED_MODES = 15;

    public ExecuteInvocationHandler(DalSession dalSession, Class<?> dalType, DalRegistry dalRegistry, BaseMapperHandler mapperHandler) {
        this.space = dalType.getName();
        this.dalSession = dalSession;
        this.initDynamicSqlMap(dalType, dalRegistry);
        this.mapperHandler = mapperHandler;
    }

    private void initDynamicSqlMap(Class<?> dalType, DalRegistry dalRegistry) {
        for (Method method : dalType.getMethods()) {
            String dynamicId;
            DynamicSql parseXml;
            if (method.getDeclaringClass() == BaseMapper.class || method.getDeclaringClass() == Object.class || (parseXml = dalRegistry.findDynamicSql(this.space, dynamicId = method.getName())) == null) continue;
            DalContext context = new DalContext(this.space, dalRegistry);
            this.dynamicSqlMap.put(dynamicId, new ExecuteProxy(dynamicId, context));
            Map argNames = this.argNamesMap.computeIfAbsent(dynamicId, s -> new HashMap());
            int parameterCount = method.getParameterCount();
            Annotation[][] annotations = method.getParameterAnnotations();
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterCount; ++i) {
                String fixedName = "arg" + i;
                argNames.put(fixedName, i);
                String name = method.getParameters()[i].getName();
                if (!argNames.containsKey(name)) {
                    argNames.put(name, i);
                }
                for (Annotation paramAnno : annotations[i]) {
                    String paramName;
                    if (!(paramAnno instanceof Param) || StringUtils.isBlank((String)(paramName = ((Param)paramAnno).value())) || argNames.containsKey(paramName)) continue;
                    argNames.put(paramName, i);
                }
                if (!Page.class.isAssignableFrom(parameterTypes[i])) continue;
                this.pageInfoMap.put(dynamicId, i);
            }
        }
    }

    protected Page extractPage(String dynamicId, Object[] objects) {
        Integer integer = this.pageInfoMap.get(dynamicId);
        if (integer == null || integer < 0) {
            return null;
        }
        return (Page)objects[integer];
    }

    protected Map<String, Object> extractData(String dynamicId, Object[] objects) {
        if (objects == null || objects.length == 0) {
            return new HashMap<String, Object>();
        }
        Map<String, Integer> argNames = this.argNamesMap.get(dynamicId);
        MergedMap<String, Object> mergedMap = new MergedMap<String, Object>();
        HashMap argMap = new HashMap();
        argNames.forEach((key, idx) -> argMap.put(key, objects[idx]));
        mergedMap.appendMap(argMap, false);
        if (objects.length == 1) {
            if (objects[0] instanceof Map) {
                mergedMap.appendMap((Map)objects[0], true);
            } else if (!(objects[0] instanceof Collection)) {
                BeanMap beanMap = new BeanMap(objects[0]);
                beanMap.setTransformConvert(ConverterBean.getInstance());
                mergedMap.appendMap((Map<String, Object>)beanMap, true);
            }
        }
        return mergedMap;
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        if (method.getName().equals("toString") && method.getParameterCount() == 0) {
            return "Mapper Proxy " + this.space + " [" + this.dalSession + "]";
        }
        if (this.mapperHandler != null && method.getDeclaringClass() == BaseMapper.class) {
            return method.invoke((Object)this.mapperHandler, objects);
        }
        String dynamicId = method.getName();
        ExecuteProxy execute = this.dynamicSqlMap.get(dynamicId);
        if (execute != null) {
            Object result = this.executeByMapper(dynamicId, execute, method, objects);
            return this.processResult(result, method.getReturnType());
        }
        if (method.isDefault()) {
            MethodHandle handle = privateLookupInMethod == null ? ExecuteInvocationHandler.getMethodHandleJava8(method) : ExecuteInvocationHandler.getMethodHandleJava9(method);
            return handle.bindTo(o).invokeWithArguments(objects);
        }
        throw new NoSuchMethodException("method '" + method.getDeclaringClass().getName() + "." + method.getName() + "' does not exist in mapper.");
    }

    private Object executeByMapper(String dynamicId, ExecuteProxy execute, Method method, Object[] objects) throws SQLException {
        Page page = this.extractPage(dynamicId, objects);
        boolean pageResult = method.getReturnType() == PageResult.class;
        Map<String, Object> data = this.extractData(dynamicId, objects);
        PageSqlDialect dialect = this.dalSession.getDialect();
        return this.dalSession.lambdaTemplate().execute(con -> execute.execute(con, data, page, pageResult, dialect));
    }

    private Object processResult(Object result, Class<?> returnType) throws SQLException {
        if (List.class == returnType || Collection.class == returnType || Iterable.class == returnType) {
            if (result instanceof List) {
                return result;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(result);
            return list;
        }
        if (Map.class == returnType) {
            if (result instanceof Map) {
                return result;
            }
            if (result instanceof Iterable) {
                HashMap map = new HashMap();
                int i = 0;
                for (Object obj : (Iterable)result) {
                    map.put("result-" + i++, obj);
                }
                return map;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("result", result);
            return map;
        }
        if (result instanceof List) {
            int nrOfColumns = ((List)result).size();
            if (nrOfColumns > 1) {
                throw new SQLException("Incorrect row count: expected 1, actual " + nrOfColumns);
            }
            return ((List)result).get(0);
        }
        return result;
    }

    private static MethodHandle getMethodHandleJava9(Method method) throws ReflectiveOperationException {
        Class<?> declaringClass = method.getDeclaringClass();
        MethodHandles.Lookup lookup = (MethodHandles.Lookup)privateLookupInMethod.invoke(null, declaringClass, MethodHandles.lookup());
        MethodType methodType = MethodType.methodType(method.getReturnType(), method.getParameterTypes());
        return lookup.findSpecial(declaringClass, method.getName(), methodType, declaringClass);
    }

    private static MethodHandle getMethodHandleJava8(Method method) throws ReflectiveOperationException {
        Class<?> declaringClass = method.getDeclaringClass();
        return lookupConstructor.newInstance(declaringClass, 15).unreflectSpecial(method, declaringClass);
    }

    static {
        Method privateLookupIn;
        try {
            privateLookupIn = MethodHandles.class.getMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
        }
        catch (NoSuchMethodException e) {
            privateLookupIn = null;
        }
        privateLookupInMethod = privateLookupIn;
        Constructor lookup = null;
        if (privateLookupInMethod == null) {
            try {
                lookup = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
                lookup.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("There is neither 'privateLookupIn(Class, Lookup)' nor 'Lookup(Class, int)' method in java.lang.invoke.MethodHandles.", e);
            }
            catch (Throwable t) {
                lookup = null;
            }
        }
        lookupConstructor = lookup;
    }
}

