/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dialect;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.dialect.BoundSql;
import net.hasor.dbvisitor.dialect.ConditionSqlDialect;
import net.hasor.dbvisitor.dialect.InsertSqlDialect;
import net.hasor.dbvisitor.dialect.PageSqlDialect;

public class DefaultSqlDialect
implements ConditionSqlDialect,
PageSqlDialect,
InsertSqlDialect {
    public static final DefaultSqlDialect DEFAULT = new DefaultSqlDialect();

    @Override
    public Set<String> keywords() {
        return Collections.emptySet();
    }

    @Override
    public String leftQualifier() {
        return "";
    }

    @Override
    public String rightQualifier() {
        return "";
    }

    @Override
    public String tableName(boolean useQualifier, String catalog, String schema, String table) {
        if (StringUtils.isBlank((String)schema)) {
            return table;
        }
        return schema + "." + table;
    }

    @Override
    public String fmtName(boolean useQualifier, String name) {
        return name;
    }

    @Override
    public BoundSql countSql(BoundSql boundSql) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BoundSql pageSql(BoundSql boundSql, long start, long limit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportInto(List<String> primaryKey, List<String> columns) {
        return true;
    }

    @Override
    public String insertInto(boolean useQualifier, String catalog, String schema, String table, List<String> primaryKey, List<String> columns, Map<String, String> columnValueTerms) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("INSERT INTO ");
        strBuilder.append(this.tableName(useQualifier, catalog, schema, table));
        strBuilder.append(" ");
        strBuilder.append("(");
        StringBuilder argBuilder = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            String valueTerm;
            String colName = columns.get(i);
            if (i > 0) {
                strBuilder.append(", ");
                argBuilder.append(", ");
            }
            strBuilder.append(this.fmtName(useQualifier, colName));
            String string = valueTerm = columnValueTerms != null ? columnValueTerms.get(colName) : null;
            if (StringUtils.isNotBlank((String)valueTerm)) {
                argBuilder.append(valueTerm);
                continue;
            }
            argBuilder.append("?");
        }
        strBuilder.append(") VALUES (");
        strBuilder.append((CharSequence)argBuilder);
        strBuilder.append(")");
        return strBuilder.toString();
    }

    @Override
    public boolean supportIgnore(List<String> primaryKey, List<String> columns) {
        return false;
    }

    @Override
    public String insertIgnore(boolean useQualifier, String catalog, String schema, String table, List<String> primaryKey, List<String> columns, Map<String, String> columnValueTerms) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportReplace(List<String> primaryKey, List<String> columns) {
        return false;
    }

    @Override
    public String insertReplace(boolean useQualifier, String catalog, String schema, String table, List<String> primaryKey, List<String> columns, Map<String, String> columnValueTerms) {
        throw new UnsupportedOperationException();
    }
}

