/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dialect.provider;

import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.hasor.cobble.ResourcesUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.io.IOUtils;
import net.hasor.cobble.io.input.AutoCloseInputStream;
import net.hasor.cobble.logging.Logger;
import net.hasor.cobble.logging.LoggerFactory;
import net.hasor.dbvisitor.dialect.ConditionSqlDialect;
import net.hasor.dbvisitor.dialect.SqlDialect;

public abstract class AbstractDialect
implements SqlDialect,
ConditionSqlDialect {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDialect.class);
    private static final Set<String> FIRST_CHAR = new HashSet<String>();
    private Set<String> keyWords;

    @Override
    public final Set<String> keywords() {
        if (this.keyWords == null) {
            this.keyWords = new HashSet<String>();
            try {
                List ins = ResourcesUtils.getResources((String)"/META-INF/custom.keywords");
                if (ins != null) {
                    for (URL in : ins) {
                        try {
                            AutoCloseInputStream input = new AutoCloseInputStream(in.openStream());
                            List strings = IOUtils.readLines((InputStream)input, (Charset)StandardCharsets.UTF_8);
                            this.loadKeyWords(strings);
                        }
                        catch (Exception e) {
                            logger.error("load '" + in + "' failed." + e.getMessage());
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("load 'custom.keywords' failed." + e.getMessage());
            }
            String keyWordsResource = this.keyWordsResource();
            if (StringUtils.isBlank((String)keyWordsResource)) {
                return this.keyWords;
            }
            try {
                List strings = IOUtils.readLines((InputStream)ResourcesUtils.getResourceAsStream((String)keyWordsResource), (Charset)StandardCharsets.UTF_8);
                this.loadKeyWords(strings);
            }
            catch (Exception e) {
                logger.error("load keywords '" + keyWordsResource + "' failed." + e.getMessage());
            }
        }
        return this.keyWords;
    }

    private void loadKeyWords(List<String> strings) {
        for (String term : strings) {
            if (StringUtils.isBlank((String)(term = term.trim().toUpperCase())) || term.charAt(0) == '#') continue;
            this.keyWords.add(term);
        }
    }

    protected String keyWordsResource() {
        return null;
    }

    @Override
    public String tableName(boolean useQualifier, String catalog, String schema, String table) {
        if (StringUtils.isBlank((String)schema)) {
            return this.fmtName(useQualifier, table);
        }
        return this.fmtName(useQualifier, schema) + "." + this.fmtName(useQualifier, table);
    }

    @Override
    public String fmtName(boolean useQualifier, String name) {
        if (StringUtils.isBlank((String)name)) {
            return name;
        }
        if (this.keywords().contains(name.toUpperCase())) {
            useQualifier = true;
        }
        if (!useQualifier && name.length() > 0) {
            useQualifier = FIRST_CHAR.contains(String.valueOf(name.charAt(0)));
        }
        String leftQualifier = useQualifier ? this.leftQualifier() : "";
        String rightQualifier = useQualifier ? this.rightQualifier() : "";
        return leftQualifier + name + rightQualifier;
    }

    protected String defaultQualifier() {
        return "";
    }

    @Override
    public String leftQualifier() {
        return this.defaultQualifier();
    }

    @Override
    public String rightQualifier() {
        return this.defaultQualifier();
    }

    static {
        FIRST_CHAR.addAll(Arrays.asList("!", "@", "#", "$", "%", "^", "&", "*", "(", ")", "-", "=", "+", "~", "`", " "));
        FIRST_CHAR.addAll(Arrays.asList("{", "}", "[", "]", "\\", "|", ";", ":", "\"", "'", ",", "<", ".", ">", "/", "?"));
        FIRST_CHAR.addAll(Arrays.asList("0", "1", "2", "3", "4", "5", "6", "7", "8", "9"));
    }
}

