/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dialect.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.dialect.BoundSql;
import net.hasor.dbvisitor.dialect.ConditionSqlDialect;
import net.hasor.dbvisitor.dialect.InsertSqlDialect;
import net.hasor.dbvisitor.dialect.PageSqlDialect;
import net.hasor.dbvisitor.dialect.provider.AbstractDialect;

public class OracleDialect
extends AbstractDialect
implements PageSqlDialect,
InsertSqlDialect {
    @Override
    protected String keyWordsResource() {
        return "/META-INF/db-keywords/oracle.keywords";
    }

    @Override
    protected String defaultQualifier() {
        return "\"";
    }

    @Override
    public String tableName(boolean useQualifier, String catalog, String schema, String table) {
        boolean catalogBlank = StringUtils.isBlank((String)catalog);
        boolean schemaBlank = StringUtils.isBlank((String)schema);
        if (!catalogBlank && !schemaBlank) {
            return this.fmtName(useQualifier, catalog) + "." + this.fmtName(useQualifier, table);
        }
        if (!catalogBlank) {
            return this.fmtName(useQualifier, catalog) + "." + this.fmtName(useQualifier, table);
        }
        if (!schemaBlank) {
            return this.fmtName(useQualifier, schema) + "." + this.fmtName(useQualifier, table);
        }
        return this.fmtName(useQualifier, table);
    }

    @Override
    public String like(ConditionSqlDialect.SqlLike likeType, Object value) {
        if (value == null || StringUtils.isBlank((String)value.toString())) {
            return "%";
        }
        switch (likeType) {
            case LEFT: {
                return "CONCAT('%', ? )";
            }
            case RIGHT: {
                return "CONCAT( ? ,'%')";
            }
        }
        return "CONCAT(CONCAT('%', ? ) ,'%')";
    }

    @Override
    public BoundSql countSql(BoundSql boundSql) {
        String sqlBuilder = "SELECT COUNT(*) FROM (" + boundSql.getSqlString() + ") TEMP_T";
        return new BoundSql.BoundSqlObj(sqlBuilder, boundSql.getArgs());
    }

    @Override
    public BoundSql pageSql(BoundSql boundSql, long start, long limit) {
        String sqlString = boundSql.getSqlString();
        ArrayList<Object> paramArrays = new ArrayList<Object>(Arrays.asList(boundSql.getArgs()));
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("SELECT * FROM ( SELECT TMP.*, ROWNUM ROW_ID FROM ( ");
        sqlBuilder.append(sqlString);
        sqlBuilder.append(" ) TMP WHERE ROWNUM <= ? ) WHERE ROW_ID > ?");
        paramArrays.add(start + limit);
        paramArrays.add(start);
        return new BoundSql.BoundSqlObj(sqlBuilder.toString(), paramArrays.toArray());
    }

    @Override
    public boolean supportInto(List<String> primaryKey, List<String> columns) {
        return true;
    }

    @Override
    public String insertInto(boolean useQualifier, String catalog, String schema, String table, List<String> primaryKey, List<String> columns, Map<String, String> columnValueTerms) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("INSERT INTO ");
        strBuilder.append(this.tableName(useQualifier, catalog, schema, table));
        strBuilder.append(" (");
        StringBuilder argBuilder = new StringBuilder();
        for (int i = 0; i < columns.size(); ++i) {
            String valueTerm;
            String colName = columns.get(i);
            if (i > 0) {
                strBuilder.append(", ");
                argBuilder.append(", ");
            }
            strBuilder.append(this.fmtName(useQualifier, colName));
            String string = valueTerm = columnValueTerms != null ? columnValueTerms.get(colName) : null;
            if (StringUtils.isNotBlank((String)valueTerm)) {
                argBuilder.append(valueTerm);
                continue;
            }
            argBuilder.append("?");
        }
        strBuilder.append(") VALUES (");
        strBuilder.append((CharSequence)argBuilder);
        strBuilder.append(")");
        return strBuilder.toString();
    }

    @Override
    public boolean supportIgnore(List<String> primaryKey, List<String> columns) {
        return !primaryKey.isEmpty();
    }

    @Override
    public String insertIgnore(boolean useQualifier, String catalog, String schema, String table, List<String> primaryKey, List<String> columns, Map<String, String> columnValueTerms) {
        StringBuilder mergeBuilder = new StringBuilder();
        this.buildMergeInfoBasic(useQualifier, catalog, schema, table, primaryKey, columns, columnValueTerms, mergeBuilder);
        this.buildMergeInfoWhenNotMatched(useQualifier, catalog, schema, table, columns, mergeBuilder);
        return mergeBuilder.toString();
    }

    @Override
    public boolean supportReplace(List<String> primaryKey, List<String> columns) {
        return !primaryKey.isEmpty();
    }

    @Override
    public String insertReplace(boolean useQualifier, String catalog, String schema, String table, List<String> primaryKey, List<String> columns, Map<String, String> columnValueTerms) {
        StringBuilder mergeBuilder = new StringBuilder();
        this.buildMergeInfoBasic(useQualifier, catalog, schema, table, primaryKey, columns, columnValueTerms, mergeBuilder);
        this.buildMergeInfoWhenMatched(useQualifier, catalog, schema, table, columns, mergeBuilder);
        this.buildMergeInfoWhenNotMatched(useQualifier, catalog, schema, table, columns, mergeBuilder);
        return mergeBuilder.toString();
    }

    private void buildMergeInfoBasic(boolean useQualifier, String catalog, String schema, String table, List<String> primaryKey, List<String> columns, Map<String, String> columnValueTerms, StringBuilder mergeBuilder) {
        int i;
        mergeBuilder.append("MERGE INTO ");
        mergeBuilder.append(this.tableName(useQualifier, catalog, schema, table));
        mergeBuilder.append(" TMP USING (SELECT ");
        for (i = 0; i < columns.size(); ++i) {
            String valueTerm;
            String colName = columns.get(i);
            if (i > 0) {
                mergeBuilder.append(", ");
            }
            String string = valueTerm = columnValueTerms != null ? columnValueTerms.get(colName) : null;
            if (StringUtils.isNotBlank((String)valueTerm)) {
                mergeBuilder.append(valueTerm);
            } else {
                mergeBuilder.append("?");
            }
            mergeBuilder.append(this.fmtName(useQualifier, columns.get(i)));
        }
        mergeBuilder.append(" FROM dual ) SRC ON (");
        for (i = 0; i < primaryKey.size(); ++i) {
            if (i != 0) {
                mergeBuilder.append(" AND ");
            }
            String pkColumn = this.fmtName(useQualifier, primaryKey.get(i));
            mergeBuilder.append("TMP." + pkColumn + " = SRC." + pkColumn);
        }
        mergeBuilder.append(") ");
    }

    private void buildMergeInfoWhenNotMatched(boolean useQualifier, String catalog, String schema, String table, List<String> allColumns, StringBuilder mergeBuilder) {
        mergeBuilder.append("WHEN NOT MATCHED THEN ");
        mergeBuilder.append("INSERT (");
        StringBuilder argBuilder = new StringBuilder();
        for (int i = 0; i < allColumns.size(); ++i) {
            if (i > 0) {
                mergeBuilder.append(", ");
                argBuilder.append(", ");
            }
            mergeBuilder.append(this.fmtName(useQualifier, allColumns.get(i)));
            argBuilder.append("SRC.").append(this.fmtName(useQualifier, allColumns.get(i)));
        }
        mergeBuilder.append(") VALUES( ");
        mergeBuilder.append((CharSequence)argBuilder);
        mergeBuilder.append(") ");
    }

    private void buildMergeInfoWhenMatched(boolean useQualifier, String catalog, String schema, String table, List<String> allColumns, StringBuilder mergeBuilder) {
        mergeBuilder.append("WHEN MATCHED THEN ");
        mergeBuilder.append("UPDATE SET ");
        for (int i = 0; i < allColumns.size(); ++i) {
            String column = allColumns.get(i);
            if (i != 0) {
                mergeBuilder.append(", ");
            }
            mergeBuilder.append(this.fmtName(useQualifier, column));
            mergeBuilder.append(" = SRC.");
            mergeBuilder.append(this.fmtName(useQualifier, column));
        }
        mergeBuilder.append(" ");
    }

    @Override
    public String randomQuery(boolean useQualifier, String catalog, String schema, String table, List<String> selectColumns, Map<String, String> columnTerms, int recordSize) {
        String tableName = this.tableName(useQualifier, catalog, schema, table);
        StringBuilder select = new StringBuilder();
        if (selectColumns == null || selectColumns.isEmpty()) {
            select.append("*");
        } else {
            for (String col : selectColumns) {
                String valueTerm;
                if (select.length() > 0) {
                    select.append(", ");
                }
                String string = valueTerm = columnTerms != null ? columnTerms.get(col) : null;
                if (StringUtils.isNotBlank((String)valueTerm)) {
                    select.append(valueTerm);
                    continue;
                }
                select.append(this.fmtName(useQualifier, col));
            }
        }
        return "select " + select + " from (select " + select + " from " + tableName + " order by sys_guid()) where rownum <= " + recordSize;
    }

    @Override
    public boolean supportBatch() {
        return false;
    }
}

