/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.dialect.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.dialect.BoundSql;
import net.hasor.dbvisitor.dialect.PageSqlDialect;
import net.hasor.dbvisitor.dialect.provider.AbstractDialect;

public class SqlServerDialect
extends AbstractDialect
implements PageSqlDialect {
    @Override
    protected String keyWordsResource() {
        return "/META-INF/db-keywords/sqlserver.keywords";
    }

    @Override
    public String leftQualifier() {
        return "[";
    }

    @Override
    public String rightQualifier() {
        return "]";
    }

    @Override
    public String fmtName(boolean useQualifier, String name) {
        if (name.contains("]")) {
            return super.fmtName(true, name.replace("]", "]]"));
        }
        return super.fmtName(useQualifier, name);
    }

    @Override
    public String tableName(boolean useQualifier, String catalog, String schema, String table) {
        StringBuilder strBuilder = new StringBuilder();
        if (StringUtils.isNotBlank((String)catalog)) {
            strBuilder.append(this.fmtName(useQualifier, catalog));
            strBuilder.append(".");
        }
        if (StringUtils.isNotBlank((String)schema)) {
            strBuilder.append(this.fmtName(useQualifier, schema));
            strBuilder.append(".");
        } else if (StringUtils.isNotBlank((String)catalog)) {
            strBuilder.append("dbo.");
        }
        strBuilder.append(this.fmtName(useQualifier, table));
        return strBuilder.toString();
    }

    private static String getOrderByPart(String sql) {
        String loweredString = sql.toLowerCase();
        int orderByIndex = loweredString.indexOf("order by");
        if (orderByIndex != -1) {
            return sql.substring(orderByIndex);
        }
        return "";
    }

    @Override
    public BoundSql pageSql(BoundSql boundSql, long start, long limit) {
        String sqlString = boundSql.getSqlString();
        ArrayList<Object> paramArrays = new ArrayList<Object>(Arrays.asList(boundSql.getArgs()));
        StringBuilder pagingBuilder = new StringBuilder();
        String orderby = SqlServerDialect.getOrderByPart(sqlString);
        String distinctStr = "";
        String loweredString = sqlString.toLowerCase();
        String sqlPartString = sqlString;
        if (loweredString.trim().toLowerCase().startsWith("select")) {
            int index = 6;
            if (loweredString.toLowerCase().startsWith("select distinct")) {
                distinctStr = "DISTINCT ";
                index = 15;
            }
            sqlPartString = sqlPartString.substring(index);
        }
        pagingBuilder.append(sqlPartString);
        if (StringUtils.isBlank((String)orderby)) {
            orderby = "ORDER BY CURRENT_TIMESTAMP";
        }
        long firstParam = start + 1L;
        long secondParam = start + limit;
        sqlString = "WITH selectTemp AS (SELECT " + distinctStr + "TOP 100 PERCENT  ROW_NUMBER() OVER (" + orderby + ") as __row_number__, " + pagingBuilder + ") SELECT * FROM selectTemp WHERE __row_number__ BETWEEN " + firstParam + " AND " + secondParam + " ORDER BY __row_number__";
        paramArrays.add(firstParam);
        paramArrays.add(secondParam);
        return new BoundSql.BoundSqlObj(sqlString, paramArrays.toArray());
    }

    public String randomQuery(boolean useQualifier, String catalog, String schema, String table, List<String> selectColumns, int recordSize) {
        String tableName = this.tableName(useQualifier, catalog, schema, table);
        StringBuilder select = new StringBuilder();
        if (selectColumns == null || selectColumns.isEmpty()) {
            select.append("*");
        } else {
            for (String col : selectColumns) {
                if (select.length() > 0) {
                    select.append(", ");
                }
                select.append(this.fmtName(useQualifier, col));
            }
        }
        return "select top " + recordSize + " " + select + " from " + tableName + " order by newid()";
    }
}

