/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.jars.javassist.bytecode.annotation;

import java.io.IOException;
import java.lang.reflect.Method;
import net.hasor.dbvisitor.jars.javassist.ClassPool;
import net.hasor.dbvisitor.jars.javassist.bytecode.ConstPool;
import net.hasor.dbvisitor.jars.javassist.bytecode.annotation.AnnotationsWriter;
import net.hasor.dbvisitor.jars.javassist.bytecode.annotation.MemberValue;
import net.hasor.dbvisitor.jars.javassist.bytecode.annotation.MemberValueVisitor;

public class IntegerMemberValue
extends MemberValue {
    int valueIndex;

    public IntegerMemberValue(int index, ConstPool cp) {
        super('I', cp);
        this.valueIndex = index;
    }

    public IntegerMemberValue(ConstPool cp, int value) {
        super('I', cp);
        this.setValue(value);
    }

    public IntegerMemberValue(ConstPool cp) {
        super('I', cp);
        this.setValue(0);
    }

    @Override
    Object getValue(ClassLoader cl, ClassPool cp, Method m) {
        return this.getValue();
    }

    @Override
    Class<?> getType(ClassLoader cl) {
        return Integer.TYPE;
    }

    public int getValue() {
        return this.cp.getIntegerInfo(this.valueIndex);
    }

    public void setValue(int newValue) {
        this.valueIndex = this.cp.addIntegerInfo(newValue);
    }

    public String toString() {
        return Integer.toString(this.getValue());
    }

    @Override
    public void write(AnnotationsWriter writer) throws IOException {
        writer.constValueIndex(this.getValue());
    }

    @Override
    public void accept(MemberValueVisitor visitor) {
        visitor.visitIntegerMemberValue(this);
    }
}

