/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.jdbc;

import java.util.Objects;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.jdbc.ResultSetExtractor;
import net.hasor.dbvisitor.jdbc.RowCallbackHandler;
import net.hasor.dbvisitor.jdbc.RowMapper;
import net.hasor.dbvisitor.jdbc.SqlParameter;
import net.hasor.dbvisitor.types.TypeHandler;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;

public class SqlParameterUtils
implements SqlParameter {
    private final String name;

    protected SqlParameterUtils(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static SqlParameter.OutSqlParameter withOutput(Integer jdbcType) {
        return new OutSqlParameterUtilsImpl(null, jdbcType, null, null, null);
    }

    public static SqlParameter.OutSqlParameter withOutput(Integer jdbcType, Integer scale) {
        return new OutSqlParameterUtilsImpl(null, jdbcType, null, scale, null);
    }

    public static SqlParameter.OutSqlParameter withOutput(Integer jdbcType, String typeName) {
        return new OutSqlParameterUtilsImpl(null, jdbcType, typeName, null, null);
    }

    public static SqlParameter.OutSqlParameter withOutput(Integer jdbcType, TypeHandler<?> typeHandler) {
        return new OutSqlParameterUtilsImpl(null, jdbcType, null, null, typeHandler);
    }

    public static SqlParameter.OutSqlParameter withOutput(Integer jdbcType, Integer scale, TypeHandler<?> typeHandler) {
        return new OutSqlParameterUtilsImpl(null, jdbcType, null, scale, typeHandler);
    }

    public static SqlParameter.OutSqlParameter withOutput(Integer jdbcType, String typeName, TypeHandler<?> typeHandler) {
        return new OutSqlParameterUtilsImpl(null, jdbcType, typeName, null, typeHandler);
    }

    public static SqlParameter.OutSqlParameter withOutputName(String paramName, Integer jdbcType) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new OutSqlParameterUtilsImpl(paramName, jdbcType, null, null, null);
    }

    public static SqlParameter.OutSqlParameter withOutputName(String paramName, Integer jdbcType, Integer scale) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new OutSqlParameterUtilsImpl(paramName, jdbcType, null, scale, null);
    }

    public static SqlParameter.OutSqlParameter withOutputName(String paramName, Integer jdbcType, String typeName) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new OutSqlParameterUtilsImpl(paramName, jdbcType, typeName, null, null);
    }

    public static SqlParameter.OutSqlParameter withOutputName(String paramName, Integer jdbcType, TypeHandler<?> typeHandler) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new OutSqlParameterUtilsImpl(paramName, jdbcType, null, null, typeHandler);
    }

    public static SqlParameter.OutSqlParameter withOutputName(String paramName, Integer jdbcType, Integer scale, TypeHandler<?> typeHandler) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new OutSqlParameterUtilsImpl(paramName, jdbcType, null, scale, typeHandler);
    }

    public static SqlParameter.OutSqlParameter withOutputName(String paramName, Integer jdbcType, String typeName, TypeHandler<?> typeHandler) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new OutSqlParameterUtilsImpl(paramName, jdbcType, typeName, null, typeHandler);
    }

    public static SqlParameter.InSqlParameter withInput(Object value) {
        Integer jdbcType = TypeHandlerRegistry.toSqlType(Objects.requireNonNull(value, "only value, can not be null.").getClass());
        return new InSqlParameterUtilsImpl(null, jdbcType, null, null, null, value);
    }

    public static SqlParameter.InSqlParameter withInput(Object value, Integer jdbcType) {
        return new InSqlParameterUtilsImpl(null, jdbcType, null, null, null, value);
    }

    public static SqlParameter.InSqlParameter withInput(Object value, Integer jdbcType, TypeHandler<?> typeHandler) {
        return new InSqlParameterUtilsImpl(null, jdbcType, null, null, typeHandler, value);
    }

    public static SqlParameter withInOut(Object value, Integer jdbcType) {
        return new InOutSqlParameterUtilsImpl(null, jdbcType, null, null, null, value);
    }

    public static SqlParameter withInOut(Object value, Integer jdbcType, Integer scale) {
        return new InOutSqlParameterUtilsImpl(null, jdbcType, null, scale, null, value);
    }

    public static SqlParameter withInOut(Object value, Integer jdbcType, String typeName) {
        return new InOutSqlParameterUtilsImpl(null, jdbcType, typeName, null, null, value);
    }

    public static SqlParameter withInOut(Object value, Integer jdbcType, TypeHandler<?> typeHandler) {
        return new InOutSqlParameterUtilsImpl(null, jdbcType, null, null, typeHandler, value);
    }

    public static SqlParameter withInOut(Object value, Integer jdbcType, Integer scale, TypeHandler<?> typeHandler) {
        return new InOutSqlParameterUtilsImpl(null, jdbcType, null, scale, typeHandler, value);
    }

    public static SqlParameter withInOut(Object value, Integer jdbcType, String typeName, TypeHandler<?> typeHandler) {
        return new InOutSqlParameterUtilsImpl(null, jdbcType, typeName, null, typeHandler, value);
    }

    public static SqlParameter withInOutName(String paramName, Object value, Integer jdbcType) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new InOutSqlParameterUtilsImpl(paramName, jdbcType, null, null, null, value);
    }

    public static SqlParameter withInOutName(String paramName, Object value, Integer jdbcType, Integer scale) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new InOutSqlParameterUtilsImpl(paramName, jdbcType, null, scale, null, value);
    }

    public static SqlParameter withInOutName(String paramName, Object value, Integer jdbcType, String typeName) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new InOutSqlParameterUtilsImpl(paramName, jdbcType, typeName, null, null, value);
    }

    public static SqlParameter withInOutName(String paramName, Object value, Integer jdbcType, TypeHandler<?> typeHandler) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new InOutSqlParameterUtilsImpl(paramName, jdbcType, null, null, typeHandler, value);
    }

    public static SqlParameter withInOutName(String paramName, Object value, Integer jdbcType, Integer scale, TypeHandler<?> typeHandler) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new InOutSqlParameterUtilsImpl(paramName, jdbcType, null, scale, typeHandler, value);
    }

    public static SqlParameter withInOutName(String paramName, Object value, Integer jdbcType, String typeName, TypeHandler<?> typeHandler) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new InOutSqlParameterUtilsImpl(paramName, jdbcType, typeName, null, typeHandler, value);
    }

    public static SqlParameter.ReturnSqlParameter withReturnValue(String paramName) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new ReturnSqlParameterUtilsImpl(paramName, null, null, null);
    }

    public static SqlParameter.ReturnSqlParameter withReturnResult(String paramName, ResultSetExtractor<?> resultSetExtractor) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new ReturnSqlParameterUtilsImpl(paramName, resultSetExtractor, null, null);
    }

    public static SqlParameter.ReturnSqlParameter withReturnResult(String paramName, RowCallbackHandler rowCallbackHandler) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new ReturnSqlParameterUtilsImpl(paramName, null, rowCallbackHandler, null);
    }

    public static SqlParameter.ReturnSqlParameter withReturnResult(String paramName, RowMapper<?> rowMapper) {
        if (StringUtils.isBlank((String)paramName)) {
            throw new IllegalStateException("paramName can not be empty or null.");
        }
        return new ReturnSqlParameterUtilsImpl(paramName, null, null, rowMapper);
    }

    private static final class ReturnSqlParameterUtilsImpl
    extends SqlParameterUtils
    implements SqlParameter.ReturnSqlParameter {
        private final ResultSetExtractor<?> resultSetExtractor;
        private final RowCallbackHandler rowCallbackHandler;
        private final RowMapper<?> rowMapper;

        public ReturnSqlParameterUtilsImpl(String name, ResultSetExtractor<?> resultSetExtractor, RowCallbackHandler rowCallbackHandler, RowMapper<?> rowMapper) {
            super(name);
            this.resultSetExtractor = resultSetExtractor;
            this.rowCallbackHandler = rowCallbackHandler;
            this.rowMapper = rowMapper;
        }

        @Override
        public ResultSetExtractor<?> getResultSetExtractor() {
            return this.resultSetExtractor;
        }

        @Override
        public RowCallbackHandler getRowCallbackHandler() {
            return this.rowCallbackHandler;
        }

        @Override
        public RowMapper<?> getRowMapper() {
            return this.rowMapper;
        }
    }

    private static final class InOutSqlParameterUtilsImpl
    extends ValueSqlParameterUtilsImpl
    implements SqlParameter.InSqlParameter,
    SqlParameter.OutSqlParameter {
        private final Object value;
        private final TypeHandler<?> typeHandler;

        public InOutSqlParameterUtilsImpl(String name, Integer jdbcType, String typeName, Integer scale, TypeHandler<?> typeHandler, Object value) {
            super(name, jdbcType, typeName, scale);
            this.typeHandler = typeHandler;
            this.value = value;
        }

        @Override
        public TypeHandler<?> getTypeHandler() {
            return this.typeHandler;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    private static final class OutSqlParameterUtilsImpl
    extends ValueSqlParameterUtilsImpl
    implements SqlParameter.OutSqlParameter {
        private final TypeHandler<?> typeHandler;

        public OutSqlParameterUtilsImpl(String name, Integer jdbcType, String typeName, Integer scale, TypeHandler<?> typeHandler) {
            super(name, jdbcType, typeName, scale);
            this.typeHandler = typeHandler;
        }

        @Override
        public TypeHandler<?> getTypeHandler() {
            return this.typeHandler;
        }
    }

    private static final class InSqlParameterUtilsImpl
    extends ValueSqlParameterUtilsImpl
    implements SqlParameter.InSqlParameter {
        private final Object value;
        private final TypeHandler<?> typeHandler;

        public InSqlParameterUtilsImpl(String name, Integer jdbcType, String typeName, Integer scale, TypeHandler<?> typeHandler, Object value) {
            super(name, jdbcType, typeName, scale);
            this.typeHandler = typeHandler;
            this.value = value;
        }

        @Override
        public TypeHandler<?> getTypeHandler() {
            return this.typeHandler;
        }

        @Override
        public Object getValue() {
            return this.value;
        }
    }

    private static abstract class ValueSqlParameterUtilsImpl
    extends SqlParameterUtils
    implements SqlParameter.ValueSqlParameter {
        private final Integer jdbcType;
        private final String typeName;
        private final Integer scale;

        public ValueSqlParameterUtilsImpl(String name, Integer jdbcType, String typeName, Integer scale) {
            super(name);
            this.jdbcType = Objects.requireNonNull(jdbcType, "jdbcType can not be null.");
            this.typeName = typeName;
            this.scale = scale;
        }

        @Override
        public Integer getJdbcType() {
            return this.jdbcType;
        }

        @Override
        public String getTypeName() {
            return this.typeName;
        }

        @Override
        public Integer getScale() {
            return this.scale;
        }
    }
}

