/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.jdbc.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Objects;
import javax.sql.DataSource;
import net.hasor.cobble.logging.Logger;
import net.hasor.cobble.logging.LoggerFactory;
import net.hasor.dbvisitor.jdbc.ConnectionCallback;
import net.hasor.dbvisitor.jdbc.DynamicConnection;
import net.hasor.dbvisitor.jdbc.StatementCallback;
import net.hasor.dbvisitor.jdbc.core.JdbcAccessor;
import net.hasor.dbvisitor.transaction.ConnectionProxy;
import net.hasor.dbvisitor.transaction.DataSourceUtils;

public class JdbcConnection
extends JdbcAccessor {
    private static final Logger logger = LoggerFactory.getLogger(JdbcConnection.class);
    private int fetchSize = 0;
    private int maxRows = 0;
    private int queryTimeout = 0;
    private boolean ignoreWarnings = true;
    private boolean printStmtError = false;

    public JdbcConnection() {
    }

    public JdbcConnection(DataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public JdbcConnection(Connection conn) {
        this.setConnection(conn);
    }

    public JdbcConnection(DynamicConnection dynamicConn) {
        this.setDynamic(dynamicConn);
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public boolean isIgnoreWarnings() {
        return this.ignoreWarnings;
    }

    public void setIgnoreWarnings(boolean ignoreWarnings) {
        this.ignoreWarnings = ignoreWarnings;
    }

    public boolean isPrintStmtError() {
        return this.printStmtError;
    }

    public void setPrintStmtError(boolean printStmtError) {
        this.printStmtError = printStmtError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T execute(ConnectionCallback<T> action) throws SQLException {
        Connection useConn;
        boolean usingDS;
        Objects.requireNonNull(action, "Callback object must not be null");
        Connection localConn = this.getConnection();
        DataSource localDS = this.getDataSource();
        DynamicConnection localDynamic = this.getDynamic();
        boolean usingConn = localConn != null;
        boolean usingDynamic = !usingConn && localDynamic != null;
        boolean bl = usingDS = !usingConn && !usingDynamic && localDS != null;
        if (!(usingConn || usingDynamic || usingDS)) {
            throw new IllegalArgumentException("Connection unavailable, any of (Connection/DynamicConnection/DataSource) is required.");
        }
        if (logger.isDebugEnabled()) {
            logger.trace("database connection using " + (usingConn ? "connection" : (usingDynamic ? "dynamic" : "dataSource")));
        }
        Connection oriConn = localConn;
        if (usingConn) {
            useConn = this.newProxyConnection(localConn);
        } else if (usingDynamic) {
            oriConn = localDynamic.getConnection();
            useConn = this.newProxyConnection(oriConn);
        } else {
            oriConn = DataSourceUtils.getConnection(localDS);
            useConn = oriConn;
        }
        try {
            T t = action.doInConnection(useConn);
            return t;
        }
        finally {
            if (usingDynamic) {
                localDynamic.releaseConnection(oriConn);
            } else if (usingDS) {
                oriConn.close();
            }
        }
    }

    public <T> T execute(StatementCallback<T> action) throws SQLException {
        Objects.requireNonNull(action, "Callback object must not be null");
        return (T)this.execute((Connection con) -> {
            String stmtSQL = "";
            try (Statement stmt = con.createStatement();){
                this.applyStatementSettings(stmt);
                stmtSQL = stmt.toString();
                Object result = action.doInStatement(stmt);
                this.handleWarnings(stmt);
                Object t = result;
                return t;
            }
            catch (SQLException ex) {
                if (!this.printStmtError) throw ex;
                logger.error(stmtSQL, (Throwable)ex);
                throw ex;
            }
        });
    }

    protected void applyStatementSettings(Statement stmt) throws SQLException {
        int timeout;
        int maxRows;
        int fetchSize = this.getFetchSize();
        if (fetchSize > 0) {
            stmt.setFetchSize(fetchSize);
        }
        if ((maxRows = this.getMaxRows()) > 0) {
            stmt.setMaxRows(maxRows);
        }
        if ((timeout = this.getQueryTimeout()) > 0) {
            stmt.setQueryTimeout(timeout);
        }
    }

    protected void handleWarnings(Statement stmt) throws SQLException {
        if (this.isIgnoreWarnings()) {
            if (logger.isDebugEnabled()) {
                for (SQLWarning warningToLog = stmt.getWarnings(); warningToLog != null; warningToLog = warningToLog.getNextWarning()) {
                    logger.trace("SQLWarning ignored: SQL state '" + warningToLog.getSQLState() + "', error code '" + warningToLog.getErrorCode() + "', message [" + warningToLog.getMessage() + "].");
                }
            }
        } else {
            SQLWarning warning = stmt.getWarnings();
            if (warning != null) {
                throw new SQLException("Warning not ignored", warning);
            }
        }
    }

    private ConnectionProxy newProxyConnection(Connection target) {
        Objects.requireNonNull(target, "Connection is null.");
        CloseSuppressingInvocationHandler handler = new CloseSuppressingInvocationHandler(target);
        return (ConnectionProxy)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)handler);
    }

    private class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;

        public CloseSuppressingInvocationHandler(Connection target) {
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "getTargetConnection": {
                    return this.target;
                }
                case "equals": {
                    return proxy == args[0];
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "close": {
                    return null;
                }
            }
            try {
                Object retVal = method.invoke((Object)this.target, args);
                if (retVal instanceof Statement) {
                    JdbcConnection.this.applyStatementSettings((Statement)retVal);
                }
                return retVal;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

