/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.jdbc.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.hasor.cobble.ResourcesUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.io.IOUtils;
import net.hasor.cobble.logging.Logger;
import net.hasor.cobble.logging.LoggerFactory;
import net.hasor.cobble.ref.LinkedCaseInsensitiveMap;
import net.hasor.dbvisitor.jdbc.BatchPreparedStatementSetter;
import net.hasor.dbvisitor.jdbc.CallableStatementCallback;
import net.hasor.dbvisitor.jdbc.CallableStatementCreator;
import net.hasor.dbvisitor.jdbc.CallableStatementSetter;
import net.hasor.dbvisitor.jdbc.DynamicConnection;
import net.hasor.dbvisitor.jdbc.JdbcOperations;
import net.hasor.dbvisitor.jdbc.PreparedStatementCallback;
import net.hasor.dbvisitor.jdbc.PreparedStatementCreator;
import net.hasor.dbvisitor.jdbc.PreparedStatementSetter;
import net.hasor.dbvisitor.jdbc.ResultSetExtractor;
import net.hasor.dbvisitor.jdbc.RowCallbackHandler;
import net.hasor.dbvisitor.jdbc.RowMapper;
import net.hasor.dbvisitor.jdbc.SqlParameter;
import net.hasor.dbvisitor.jdbc.SqlParameterSource;
import net.hasor.dbvisitor.jdbc.SqlParameterUtils;
import net.hasor.dbvisitor.jdbc.SqlProvider;
import net.hasor.dbvisitor.jdbc.StatementCallback;
import net.hasor.dbvisitor.jdbc.core.ArgPreparedStatementSetter;
import net.hasor.dbvisitor.jdbc.core.JdbcConnection;
import net.hasor.dbvisitor.jdbc.core.ParameterDisposer;
import net.hasor.dbvisitor.jdbc.core.ParsedSql;
import net.hasor.dbvisitor.jdbc.core.StatementSetterUtils;
import net.hasor.dbvisitor.jdbc.core.UncategorizedSQLException;
import net.hasor.dbvisitor.jdbc.extractor.ColumnMapResultSetExtractor;
import net.hasor.dbvisitor.jdbc.extractor.MultipleProcessType;
import net.hasor.dbvisitor.jdbc.extractor.RowCallbackHandlerResultSetExtractor;
import net.hasor.dbvisitor.jdbc.extractor.RowMapperResultSetExtractor;
import net.hasor.dbvisitor.jdbc.extractor.SimpleCallableStatementCallback;
import net.hasor.dbvisitor.jdbc.mapper.ColumnMapRowMapper;
import net.hasor.dbvisitor.jdbc.mapper.MappingResultSetExtractor;
import net.hasor.dbvisitor.jdbc.mapper.MappingRowMapper;
import net.hasor.dbvisitor.jdbc.mapper.SingleColumnRowMapper;
import net.hasor.dbvisitor.jdbc.paramer.MapSqlParameterSource;
import net.hasor.dbvisitor.types.TypeHandler;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;

public class JdbcTemplate
extends JdbcConnection
implements JdbcOperations {
    private static final Logger logger = LoggerFactory.getLogger(JdbcTemplate.class);
    private boolean resultsCaseInsensitive = true;
    private TypeHandlerRegistry typeRegistry = TypeHandlerRegistry.DEFAULT;
    private final Map<String, ParsedSql> parsedSqlCache = new HashMap<String, ParsedSql>();

    public JdbcTemplate() {
    }

    public JdbcTemplate(DataSource dataSource) {
        super(dataSource);
    }

    public JdbcTemplate(DataSource dataSource, TypeHandlerRegistry typeRegistry) {
        super(dataSource);
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry is null.");
    }

    public JdbcTemplate(Connection conn) {
        super(conn);
    }

    public JdbcTemplate(Connection conn, TypeHandlerRegistry typeRegistry) {
        super(conn);
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry is null.");
    }

    public JdbcTemplate(DynamicConnection dynamicConn) {
        super(dynamicConn);
    }

    public JdbcTemplate(DynamicConnection dynamicConn, TypeHandlerRegistry typeRegistry) {
        super(dynamicConn);
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry is null.");
    }

    public boolean isResultsCaseInsensitive() {
        return this.resultsCaseInsensitive;
    }

    public void setResultsCaseInsensitive(boolean resultsCaseInsensitive) {
        this.resultsCaseInsensitive = resultsCaseInsensitive;
    }

    public TypeHandlerRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public void setTypeRegistry(TypeHandlerRegistry typeRegistry) {
        this.typeRegistry = typeRegistry;
    }

    public void loadSQL(String sqlResource) throws IOException, SQLException {
        this.loadSplitSQL(null, StandardCharsets.UTF_8, sqlResource);
    }

    public void loadSQL(Charset charset, String sqlResource) throws IOException, SQLException {
        this.loadSplitSQL(null, charset, sqlResource);
    }

    public void loadSQL(Reader sqlReader) throws IOException, SQLException {
        this.loadSplitSQL(null, sqlReader);
    }

    public void loadSplitSQL(String splitChars, String sqlResource) throws IOException, SQLException {
        this.loadSplitSQL(splitChars, StandardCharsets.UTF_8, sqlResource);
    }

    public void loadSplitSQL(String splitChars, Charset charset, String sqlResource) throws IOException, SQLException {
        InputStream inStream = ResourcesUtils.getResourceAsStream((String)sqlResource);
        if (inStream == null) {
            String msg = "can't find resource '" + sqlResource + "'";
            if (logger.isDebugEnabled()) {
                logger.debug(msg);
            }
            throw new IOException(msg);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("loadSplitSQL resource '" + sqlResource + "', splitChars = " + splitChars);
        }
        this.loadSplitSQL(splitChars, new InputStreamReader(inStream, charset));
    }

    public void loadSplitSQL(String splitChars, Reader sqlReader) throws IOException, SQLException {
        if (sqlReader == null) {
            logger.warn("loadSplitSQL by Reader, the Reader is null.");
            return;
        }
        StringWriter outWriter = new StringWriter();
        IOUtils.copy((Reader)sqlReader, (Writer)outWriter);
        List<String> taskList = StringUtils.isBlank((String)splitChars) ? Collections.singletonList(outWriter.toString()) : Arrays.asList(outWriter.toString().split(splitChars));
        taskList = taskList.parallelStream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
        if (logger.isDebugEnabled()) {
            logger.debug("loadSplitSQL by Reader, taskSQL = " + outWriter);
        }
        for (String str : taskList) {
            if (str.trim().startsWith("--")) continue;
            this.execute(str);
        }
    }

    @Override
    public boolean execute(final String sql) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.trace("Executing SQL statement [" + sql + "].");
        }
        class ExecuteStatementCallback
        implements StatementCallback<Boolean>,
        SqlProvider {
            ExecuteStatementCallback() {
            }

            @Override
            public Boolean doInStatement(Statement stmt) throws SQLException {
                return stmt.execute(sql);
            }

            @Override
            public String getSql() {
                return sql;
            }
        }
        return this.execute(new ExecuteStatementCallback());
    }

    private <T> T execute(SimpleStatementCreator sc, StatementCallback<T> action) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.trace("Executing SQL statement [" + JdbcTemplate.getSql(sc) + "].");
        }
        return (T)this.execute((Connection con) -> {
            try (Statement s = sc.createStatement(con);){
                this.applyStatementSettings(s);
                Object result = action.doInStatement(s);
                this.handleWarnings(s);
                Object t = result;
                return t;
            }
            catch (SQLException ex) {
                String sql = JdbcTemplate.getSql(sc);
                if (!this.isPrintStmtError()) throw new UncategorizedSQLException(sql, ex.getMessage(), ex);
                logger.error("Failed SQL statement [" + sql + "].", (Throwable)ex);
                throw new UncategorizedSQLException(sql, ex.getMessage(), ex);
            }
        });
    }

    @Override
    public <T> T executeCreator(PreparedStatementCreator psc, PreparedStatementCallback<T> action) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.trace("Executing SQL statement [" + JdbcTemplate.getSql(psc) + "].");
        }
        return (T)this.execute((Connection con) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @Override
    public <T> T executeCreator(PreparedStatementCreator psc, ResultSetExtractor<T> rse) throws SQLException {
        return (T)this.executeCreator(psc, (PreparedStatement cs) -> {
            boolean retVal = cs.execute();
            if (retVal) {
                try (ResultSet rs = cs.getResultSet();){
                    Object t = rse.extractData(rs);
                    return t;
                }
            }
            int cnt = cs.getUpdateCount();
            return null;
        });
    }

    @Override
    public void executeCreator(PreparedStatementCreator psc, RowCallbackHandler rch) throws SQLException {
        this.executeCreator(psc, new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public <T> List<T> executeCreator(PreparedStatementCreator psc, RowMapper<T> rowMapper) throws SQLException {
        List result = (List)this.executeCreator(psc, new RowMapperResultSetExtractor<T>(rowMapper));
        return result == null ? Collections.emptyList() : result;
    }

    @Override
    public <T> T executeCall(CallableStatementCreator csc, ResultSetExtractor<T> rse) throws SQLException {
        return (T)this.executeCall(csc, (CallableStatement cs) -> {
            boolean retVal = cs.execute();
            if (retVal) {
                try (ResultSet rs = cs.getResultSet();){
                    Object t = rse.extractData(rs);
                    return t;
                }
            }
            int cnt = cs.getUpdateCount();
            return null;
        });
    }

    @Override
    public void executeCall(CallableStatementCreator csc, RowCallbackHandler rch) throws SQLException {
        this.executeCall(csc, (CallableStatement cs) -> {
            boolean retVal = cs.execute();
            if (retVal) {
                try (ResultSet rs = cs.getResultSet();){
                    Void void_ = new RowCallbackHandlerResultSetExtractor(rch).extractData(rs);
                    return void_;
                }
            }
            int cnt = cs.getUpdateCount();
            return null;
        });
    }

    @Override
    public <T> List<T> executeCall(CallableStatementCreator csc, RowMapper<T> rowMapper) throws SQLException {
        return this.executeCall(csc, (CallableStatement cs) -> {
            boolean retVal = cs.execute();
            if (retVal) {
                try (ResultSet rs = cs.getResultSet();){
                    Object object = new RowMapperResultSetExtractor(rowMapper).extractData(rs);
                    return object;
                }
            }
            int cnt = cs.getUpdateCount();
            return Collections.emptyList();
        });
    }

    @Override
    public <T> T executeCall(CallableStatementCreator csc, CallableStatementCallback<T> action) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.trace("Executing SQL statement [" + JdbcTemplate.getSql(csc) + "].");
        }
        return (T)this.execute((Connection con) -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    @Override
    public <T> T executeCallback(String sql, PreparedStatementCallback<T> action) throws SQLException {
        PreparedStatementSetter EmptySetter = ps -> {};
        return this.executeCreator(this.getPreparedStatementCreator(sql, EmptySetter), action);
    }

    @Override
    public <T> T executeCallback(String sql, CallableStatementCallback<T> action) throws SQLException {
        CallableStatementSetter EmptySetter = ps -> {};
        return this.executeCall(this.getCallableStatementCreator(sql, EmptySetter), action);
    }

    @Override
    public List<Object> multipleExecute(String sql) throws SQLException {
        return this.execute(this.getStatementCreator(sql), s -> {
            boolean retVal = s.execute(sql);
            return this.receiveMultipleResult(retVal, s);
        });
    }

    @Override
    public List<Object> multipleExecute(String sql, Object[] args) throws SQLException {
        PreparedStatementSetter setter = this.newArgPreparedStatementSetter(args);
        PreparedStatementCreator psc = this.getPreparedStatementCreator(sql, setter);
        return this.executeCreator(psc, (PreparedStatement ps) -> {
            boolean retVal = ps.execute();
            return this.receiveMultipleResult(retVal, ps);
        });
    }

    @Override
    public List<Object> multipleExecute(String sql, SqlParameterSource parameterSource) throws SQLException {
        PreparedStatementCreator psc = this.getPreparedStatementCreator(sql, parameterSource);
        return this.executeCreator(psc, (PreparedStatement ps) -> {
            boolean retVal = ps.execute();
            return this.receiveMultipleResult(retVal, ps);
        });
    }

    @Override
    public List<Object> multipleExecute(String sql, Map<String, ?> paramMap) throws SQLException {
        PreparedStatementCreator psc = this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap));
        return this.executeCreator(psc, (PreparedStatement ps) -> {
            boolean retVal = ps.execute();
            return this.receiveMultipleResult(retVal, ps);
        });
    }

    @Override
    public List<Object> multipleExecute(String sql, PreparedStatementSetter setter) throws SQLException {
        PreparedStatementCreator psc = this.getPreparedStatementCreator(sql, setter);
        return this.executeCreator(psc, (PreparedStatement ps) -> {
            boolean retVal = ps.execute();
            return this.receiveMultipleResult(retVal, ps);
        });
    }

    private List<Object> receiveMultipleResult(boolean retVal, Statement s) throws SQLException {
        if (logger.isTraceEnabled()) {
            logger.trace("statement.execute() returned '" + retVal + "'");
        }
        TypeHandlerRegistry typeRegistry = this.getTypeRegistry();
        ArrayList<Object> resultList = new ArrayList<Object>();
        if (retVal) {
            try (ResultSet resultSet = s.getResultSet();){
                ColumnMapRowMapper columnMapRowMapper = new ColumnMapRowMapper(this.isResultsCaseInsensitive(), typeRegistry);
                SqlParameter.ReturnSqlParameter result = SqlParameterUtils.withReturnResult("TMP", new RowMapperResultSetExtractor<Map<String, Object>>(columnMapRowMapper));
                resultList.add(JdbcTemplate.processResultSet(typeRegistry, this.isResultsCaseInsensitive(), resultSet, result));
            }
        } else {
            resultList.add(s.getUpdateCount());
        }
        while (s.getMoreResults() || s.getUpdateCount() != -1) {
            int updateCount = s.getUpdateCount();
            ResultSet resultSet = s.getResultSet();
            Throwable throwable = null;
            try {
                if (resultSet != null) {
                    resultList.add(JdbcTemplate.processResultSet(typeRegistry, this.isResultsCaseInsensitive(), resultSet, null));
                    continue;
                }
                resultList.add(updateCount);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (resultSet == null) continue;
                if (throwable != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                resultSet.close();
            }
        }
        return resultList;
    }

    @Override
    public <T> T query(String sql, ResultSetExtractor<T> rse) throws SQLException {
        return (T)this.execute(this.getStatementCreator(sql), stmt -> {
            try (ResultSet rs = stmt.executeQuery(sql);){
                Object t = rse.extractData(rs);
                return t;
            }
        });
    }

    @Override
    public <T> T query(String sql, Object[] args, ResultSetExtractor<T> rse) throws SQLException {
        return this.executeCreator(this.getPreparedStatementCreator(sql, this.newArgPreparedStatementSetter(args)), rse);
    }

    @Override
    public <T> T query(String sql, SqlParameterSource paramSource, ResultSetExtractor<T> rse) throws SQLException {
        return this.executeCreator(this.getPreparedStatementCreator(sql, paramSource), rse);
    }

    @Override
    public <T> T query(String sql, Map<String, ?> paramMap, ResultSetExtractor<T> rse) throws SQLException {
        return this.executeCreator(this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap)), rse);
    }

    @Override
    public <T> T query(String sql, PreparedStatementSetter pss, ResultSetExtractor<T> rse) throws SQLException {
        return this.executeCreator(this.getPreparedStatementCreator(sql, pss), rse);
    }

    @Override
    public void query(String sql, RowCallbackHandler rch) throws SQLException {
        boolean res = this.execute(this.getStatementCreator(sql), stmt -> {
            try (ResultSet rs = stmt.executeQuery(sql);){
                new RowCallbackHandlerResultSetExtractor(rch).extractData(rs);
                Boolean bl = true;
                return bl;
            }
        });
    }

    @Override
    public void query(String sql, Object[] args, RowCallbackHandler rch) throws SQLException {
        this.executeCreator(this.getPreparedStatementCreator(sql, this.newArgPreparedStatementSetter(args)), new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public void query(String sql, SqlParameterSource paramSource, RowCallbackHandler rch) throws SQLException {
        this.executeCreator(this.getPreparedStatementCreator(sql, paramSource), new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public void query(String sql, Map<String, ?> paramMap, RowCallbackHandler rch) throws SQLException {
        this.executeCreator(this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap)), new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public void query(String sql, PreparedStatementSetter setter, RowCallbackHandler rch) throws SQLException {
        this.executeCreator(this.getPreparedStatementCreator(sql, setter), new RowCallbackHandlerResultSetExtractor(rch));
    }

    @Override
    public <T> List<T> queryForList(String sql, RowMapper<T> rowMapper) throws SQLException {
        return this.execute(this.getStatementCreator(sql), stmt -> {
            try (ResultSet rs = stmt.executeQuery(sql);){
                Object object = new RowMapperResultSetExtractor(rowMapper).extractData(rs);
                return object;
            }
        });
    }

    @Override
    public <T> List<T> queryForList(String sql, Object[] args, RowMapper<T> rowMapper) throws SQLException {
        return (List)this.executeCreator(this.getPreparedStatementCreator(sql, this.newArgPreparedStatementSetter(args)), new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> queryForList(String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws SQLException {
        return (List)this.executeCreator(this.getPreparedStatementCreator(sql, paramSource), new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> queryForList(String sql, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws SQLException {
        return (List)this.executeCreator(this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap)), new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> queryForList(String sql, PreparedStatementSetter setter, RowMapper<T> rowMapper) throws SQLException {
        return (List)this.executeCreator(this.getPreparedStatementCreator(sql, setter), new RowMapperResultSetExtractor<T>(rowMapper));
    }

    @Override
    public <T> List<T> queryForList(String sql, Class<T> elementType) throws SQLException {
        return this.query(sql, this.createBeanResultSetExtractor(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, Object[] args, Class<T> elementType) throws SQLException {
        return this.executeCreator(this.getPreparedStatementCreator(sql, this.newArgPreparedStatementSetter(args)), this.createBeanResultSetExtractor(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, SqlParameterSource paramSource, Class<T> elementType) throws SQLException {
        return this.executeCreator(this.getPreparedStatementCreator(sql, paramSource), this.createBeanResultSetExtractor(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, Map<String, ?> paramMap, Class<T> elementType) throws SQLException {
        return this.executeCreator(this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap)), this.createBeanResultSetExtractor(elementType));
    }

    @Override
    public <T> List<T> queryForList(String sql, PreparedStatementSetter setter, Class<T> elementType) throws SQLException {
        return this.executeCreator(this.getPreparedStatementCreator(sql, setter), this.createBeanResultSetExtractor(elementType));
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql) throws SQLException {
        return (List)((Object)this.query(sql, new RowMapperResultSetExtractor<Map<String, Object>>(this.createMapRowMapper())));
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Object[] args) throws SQLException {
        PreparedStatementCreator psc = this.getPreparedStatementCreator(sql, this.newArgPreparedStatementSetter(args));
        return (List)((Object)this.executeCreator(psc, new RowMapperResultSetExtractor<Map<String, Object>>(this.createMapRowMapper())));
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, SqlParameterSource paramSource) throws SQLException {
        return (List)((Object)this.executeCreator(this.getPreparedStatementCreator(sql, paramSource), new RowMapperResultSetExtractor<Map<String, Object>>(this.createMapRowMapper())));
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Map<String, ?> paramMap) throws SQLException {
        return (List)((Object)this.executeCreator(this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap)), new RowMapperResultSetExtractor<Map<String, Object>>(this.createMapRowMapper())));
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, PreparedStatementSetter setter) throws SQLException {
        return (List)((Object)this.executeCreator(this.getPreparedStatementCreator(sql, setter), new RowMapperResultSetExtractor<Map<String, Object>>(this.createMapRowMapper())));
    }

    @Override
    public <T> T queryForObject(String sql, RowMapper<T> rowMapper) throws SQLException {
        return JdbcTemplate.requiredSingleResult((Collection)this.query(sql, new RowMapperResultSetExtractor<T>(rowMapper, 1)));
    }

    @Override
    public <T> T queryForObject(String sql, Object[] args, RowMapper<T> rowMapper) throws SQLException {
        PreparedStatementCreator psc = this.getPreparedStatementCreator(sql, this.newArgPreparedStatementSetter(args));
        List result = (List)this.executeCreator(psc, new RowMapperResultSetExtractor<T>(rowMapper, 1));
        return JdbcTemplate.requiredSingleResult(result);
    }

    @Override
    public <T> T queryForObject(String sql, SqlParameterSource paramSource, RowMapper<T> rowMapper) throws SQLException {
        PreparedStatementCreator psc = this.getPreparedStatementCreator(sql, paramSource);
        List result = (List)this.executeCreator(psc, new RowMapperResultSetExtractor<T>(rowMapper, 1));
        return JdbcTemplate.requiredSingleResult(result);
    }

    @Override
    public <T> T queryForObject(String sql, Map<String, ?> paramMap, RowMapper<T> rowMapper) throws SQLException {
        PreparedStatementCreator psc = this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap));
        List result = (List)this.executeCreator(psc, new RowMapperResultSetExtractor<T>(rowMapper, 1));
        return JdbcTemplate.requiredSingleResult(result);
    }

    @Override
    public <T> T queryForObject(String sql, PreparedStatementSetter setter, RowMapper<T> rowMapper) throws SQLException {
        PreparedStatementCreator psc = this.getPreparedStatementCreator(sql, setter);
        List result = (List)this.executeCreator(psc, new RowMapperResultSetExtractor<T>(rowMapper, 1));
        return JdbcTemplate.requiredSingleResult(result);
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> requiredType) throws SQLException {
        return this.queryForObject(sql, this.createBeanRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, Object[] args, Class<T> requiredType) throws SQLException {
        return this.queryForObject(sql, args, this.createBeanRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, SqlParameterSource paramSource, Class<T> requiredType) throws SQLException {
        return this.queryForObject(sql, paramSource, this.createBeanRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, Map<String, ?> paramMap, Class<T> requiredType) throws SQLException {
        return this.queryForObject(sql, paramMap, this.createBeanRowMapper(requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, PreparedStatementSetter setter, Class<T> requiredType) throws SQLException {
        return this.queryForObject(sql, setter, this.createBeanRowMapper(requiredType));
    }

    @Override
    public Map<String, Object> queryForMap(String sql) throws SQLException {
        return this.queryForObject(sql, this.createMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Object[] args) throws SQLException {
        return this.queryForObject(sql, args, this.createMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql, SqlParameterSource paramSource) throws SQLException {
        return this.queryForObject(sql, paramSource, this.createMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Map<String, ?> paramMap) throws SQLException {
        return this.queryForObject(sql, paramMap, this.createMapRowMapper());
    }

    @Override
    public Map<String, Object> queryForMap(String sql, PreparedStatementSetter setter) throws SQLException {
        return this.queryForObject(sql, setter, this.createMapRowMapper());
    }

    @Override
    public long queryForLong(String sql) throws SQLException {
        Number number = this.queryForObject(sql, this.createSingleColumnRowMapper(Long.TYPE));
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long queryForLong(String sql, Object[] args) throws SQLException {
        Number number = this.queryForObject(sql, args, this.createSingleColumnRowMapper(Long.TYPE));
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long queryForLong(String sql, SqlParameterSource paramSource) throws SQLException {
        Number number = this.queryForObject(sql, paramSource, this.createSingleColumnRowMapper(Long.TYPE));
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long queryForLong(String sql, Map<String, ?> paramMap) throws SQLException {
        Number number = this.queryForObject(sql, paramMap, this.createSingleColumnRowMapper(Long.TYPE));
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public long queryForLong(String sql, PreparedStatementSetter setter) throws SQLException {
        Number number = this.queryForObject(sql, setter, this.createSingleColumnRowMapper(Long.TYPE));
        return number != null ? number.longValue() : 0L;
    }

    @Override
    public int queryForInt(String sql) throws SQLException {
        Number number = this.queryForObject(sql, this.createSingleColumnRowMapper(Integer.TYPE));
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int queryForInt(String sql, Object[] args) throws SQLException {
        Number number = this.queryForObject(sql, args, this.createSingleColumnRowMapper(Integer.TYPE));
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int queryForInt(String sql, SqlParameterSource paramSource) throws SQLException {
        Number number = this.queryForObject(sql, paramSource, this.createSingleColumnRowMapper(Integer.TYPE));
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int queryForInt(String sql, Map<String, ?> paramMap) throws SQLException {
        Number number = this.queryForObject(sql, paramMap, this.createSingleColumnRowMapper(Integer.TYPE));
        return number != null ? number.intValue() : 0;
    }

    @Override
    public int queryForInt(String sql, PreparedStatementSetter setter) throws SQLException {
        Number number = this.queryForObject(sql, setter, this.createSingleColumnRowMapper(Integer.TYPE));
        return number != null ? number.intValue() : 0;
    }

    @Override
    public String queryForString(String sql) throws SQLException {
        return this.queryForObject(sql, this.createSingleColumnRowMapper(String.class));
    }

    @Override
    public String queryForString(String sql, Object[] args) throws SQLException {
        return this.queryForObject(sql, args, this.createSingleColumnRowMapper(String.class));
    }

    @Override
    public String queryForString(String sql, SqlParameterSource paramSource) throws SQLException {
        return this.queryForObject(sql, paramSource, this.createSingleColumnRowMapper(String.class));
    }

    @Override
    public String queryForString(String sql, Map<String, ?> paramMap) throws SQLException {
        return this.queryForObject(sql, paramMap, this.createSingleColumnRowMapper(String.class));
    }

    @Override
    public String queryForString(String sql, PreparedStatementSetter setter) throws SQLException {
        return this.queryForObject(sql, setter, this.createSingleColumnRowMapper(String.class));
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.execute(this.getStatementCreator(sql), stmt -> stmt.executeUpdate(sql));
    }

    @Override
    public int executeUpdate(String sql, Object[] args) throws SQLException {
        PreparedStatementCreator psc = this.getPreparedStatementCreator(sql, this.newArgPreparedStatementSetter(args));
        return this.executeCreator(psc, PreparedStatement::executeUpdate);
    }

    @Override
    public int executeUpdate(String sql, SqlParameterSource paramSource) throws SQLException {
        PreparedStatementCreator psc = this.getPreparedStatementCreator(sql, paramSource);
        return this.executeCreator(psc, PreparedStatement::executeUpdate);
    }

    @Override
    public int executeUpdate(String sql, Map<String, ?> paramMap) throws SQLException {
        PreparedStatementCreator psc = this.getPreparedStatementCreator(sql, new MapSqlParameterSource(paramMap));
        return this.executeCreator(psc, PreparedStatement::executeUpdate);
    }

    @Override
    public int executeUpdate(String sql, PreparedStatementSetter pss) throws SQLException {
        PreparedStatementCreator psc = this.getPreparedStatementCreator(sql, pss);
        return this.executeCreator(psc, PreparedStatement::executeUpdate);
    }

    protected RowMapper<Map<String, Object>> createMapRowMapper() {
        return new ColumnMapRowMapper(this.isResultsCaseInsensitive(), this.getTypeRegistry()){

            @Override
            protected Map<String, Object> createColumnMap(int columnCount) {
                return JdbcTemplate.this.createResultsMap();
            }
        };
    }

    protected <T> RowMapper<T> createBeanRowMapper(Class<T> requiredType) {
        Objects.requireNonNull(requiredType, "requiredType is null.");
        if (Map.class.isAssignableFrom(requiredType)) {
            return this.createMapRowMapper();
        }
        if (TypeHandlerRegistry.DEFAULT.hasTypeHandler(requiredType) || requiredType.isEnum()) {
            return this.createSingleColumnRowMapper(requiredType);
        }
        return new MappingRowMapper<T>(requiredType, this.getTypeRegistry());
    }

    protected <T> RowMapper<T> createSingleColumnRowMapper(Class<T> requiredType) {
        Objects.requireNonNull(requiredType, "requiredType is null.");
        return new SingleColumnRowMapper<T>(requiredType, this.getTypeRegistry());
    }

    protected <T> ResultSetExtractor<List<T>> createBeanResultSetExtractor(Class<T> requiredType) {
        Objects.requireNonNull(requiredType, "requiredType is null.");
        if (Map.class.isAssignableFrom(requiredType)) {
            RowMapper<Map<String, Object>> mapRowMapper = this.createMapRowMapper();
            return new RowMapperResultSetExtractor<Map<String, Object>>(mapRowMapper);
        }
        if (TypeHandlerRegistry.DEFAULT.hasTypeHandler(requiredType) || requiredType.isEnum()) {
            RowMapper<T> mapRowMapper = this.createSingleColumnRowMapper(requiredType);
            return new RowMapperResultSetExtractor<T>(mapRowMapper);
        }
        return new MappingResultSetExtractor<T>(requiredType, this.getTypeRegistry());
    }

    protected SimpleStatementCreator getStatementCreator(String sql) {
        Objects.requireNonNull(sql, "SQL must not be null.");
        if (logger.isDebugEnabled()) {
            logger.trace("Executing SQL query [" + sql + "].");
        }
        return new SimpleStatementCreator(sql);
    }

    protected PreparedStatementCreator getPreparedStatementCreator(String sql) {
        Objects.requireNonNull(sql, "SQL must not be null.");
        if (logger.isDebugEnabled()) {
            logger.trace("Executing SQL query [" + sql + "].");
        }
        return new SimplePreparedStatementCreator(sql, null);
    }

    protected PreparedStatementCreator getPreparedStatementCreator(String sql, PreparedStatementSetter setter) {
        Objects.requireNonNull(sql, "SQL must not be null.");
        Objects.requireNonNull(setter, "PreparedStatementSetter must not be null.");
        if (logger.isDebugEnabled()) {
            logger.trace("Executing SQL query [" + sql + "].");
        }
        return new SimplePreparedStatementCreator(sql, setter);
    }

    protected PreparedStatementCreator getPreparedStatementCreator(String sql, SqlParameterSource paramSource) {
        Objects.requireNonNull(sql, "SQL must not be null.");
        Objects.requireNonNull(paramSource, "SqlParameterSource must not be null.");
        if (logger.isDebugEnabled()) {
            logger.trace("Executing SQL query [" + sql + "].");
        }
        return new MapPreparedStatementCreator(sql, paramSource);
    }

    protected CallableStatementCreator getCallableStatementCreator(String sql, CallableStatementSetter setter) {
        Objects.requireNonNull(sql, "SQL must not be null.");
        Objects.requireNonNull(setter, "PreparedStatementSetter must not be null.");
        if (logger.isDebugEnabled()) {
            logger.trace("Executing SQL query [" + sql + "].");
        }
        return new SimpleCallableStatementCreator(sql, setter);
    }

    @Override
    public int[] executeBatch(final String[] sql) throws SQLException {
        if (sql == null || sql.length == 0) {
            return new int[0];
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Executing SQL batch update of " + sql.length + " statements");
        }
        class BatchUpdateStatementCallback
        implements StatementCallback<int[]>,
        SqlProvider {
            private String currSql;

            BatchUpdateStatementCallback() {
            }

            @Override
            public int[] doInStatement(Statement stmt) throws SQLException {
                DatabaseMetaData dbmd = stmt.getConnection().getMetaData();
                int[] rowsAffected = new int[sql.length];
                if (dbmd.supportsBatchUpdates()) {
                    String[] stringArray = sql;
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String sqlStmt;
                        this.currSql = sqlStmt = stringArray[i];
                        stmt.addBatch(sqlStmt);
                    }
                    rowsAffected = stmt.executeBatch();
                } else {
                    for (int i = 0; i < sql.length; ++i) {
                        this.currSql = sql[i];
                        if (stmt.execute(sql[i])) {
                            throw new UncategorizedSQLException(sql[i], "Invalid batch SQL statement");
                        }
                        rowsAffected[i] = stmt.getUpdateCount();
                    }
                }
                return rowsAffected;
            }

            @Override
            public String getSql() {
                return this.currSql;
            }
        }
        return this.execute(new BatchUpdateStatementCallback());
    }

    @Override
    public int[] executeBatch(String sql, final Object[][] batchValues) throws SQLException {
        return this.executeBatch(sql, new BatchPreparedStatementSetter(){

            @Override
            public void setValues(PreparedStatement ps, int i) throws SQLException {
                int idx = 1;
                TypeHandlerRegistry typeRegistry = JdbcTemplate.this.getTypeRegistry();
                for (Object value : batchValues[i]) {
                    if (value == null) {
                        ps.setObject(idx, null);
                    } else {
                        typeRegistry.setParameterValue(ps, idx, value);
                    }
                    ++idx;
                }
            }

            @Override
            public int getBatchSize() {
                return batchValues.length;
            }
        });
    }

    @Override
    public int[] executeBatch(String sql, SqlParameterSource[] batchArgs) throws SQLException {
        if (batchArgs == null || batchArgs.length == 0) {
            return new int[0];
        }
        return this.executeBatch(sql, new SqlParameterSourceBatchPreparedStatementSetter(sql, batchArgs));
    }

    @Override
    public int[] executeBatch(String sql, Map<String, ?>[] batchValues) throws SQLException {
        if (batchValues == null || batchValues.length == 0) {
            return new int[0];
        }
        SqlParameterSource[] batchArgs = new SqlParameterSource[batchValues.length];
        int i = 0;
        for (Map<String, ?> values : batchValues) {
            batchArgs[i] = new MapSqlParameterSource(values);
            ++i;
        }
        return this.executeBatch(sql, new SqlParameterSourceBatchPreparedStatementSetter(sql, batchArgs));
    }

    @Override
    public int[] executeBatch(String sql, BatchPreparedStatementSetter pss) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug("Executing SQL batch update [" + sql + "].");
        }
        String buildSql = this.getParsedSql(sql).buildSql(null);
        return this.executeCreator(this.getPreparedStatementCreator(buildSql), (PreparedStatement ps) -> {
            try {
                int batchSize = pss.getBatchSize();
                DatabaseMetaData dbMetaData = ps.getConnection().getMetaData();
                if (dbMetaData.supportsBatchUpdates()) {
                    for (int i = 0; i < batchSize; ++i) {
                        pss.setValues(ps, i);
                        if (pss.isBatchExhausted(i)) break;
                        ps.addBatch();
                    }
                    int[] i = ps.executeBatch();
                    return i;
                }
                ArrayList<Integer> rowsAffected = new ArrayList<Integer>();
                for (int i = 0; i < batchSize; ++i) {
                    pss.setValues(ps, i);
                    if (pss.isBatchExhausted(i)) break;
                    rowsAffected.add(ps.executeUpdate());
                }
                int[] rowsAffectedArray = new int[rowsAffected.size()];
                for (int i = 0; i < rowsAffectedArray.length; ++i) {
                    rowsAffectedArray[i] = (Integer)rowsAffected.get(i);
                }
                int[] nArray = rowsAffectedArray;
                return nArray;
            }
            finally {
                if (pss instanceof ParameterDisposer) {
                    ((ParameterDisposer)((Object)pss)).cleanupParameters();
                }
            }
        });
    }

    @Override
    public <T> T call(String callString, CallableStatementSetter setter, CallableStatementCallback<T> action) throws SQLException {
        return this.executeCall(this.getCallableStatementCreator(callString, setter), action);
    }

    @Override
    public Map<String, Object> call(CallableStatementCreator csc, List<SqlParameter> declaredParameters) throws SQLException {
        return this.executeCall(csc, new SimpleCallableStatementCallback(MultipleProcessType.ALL, declaredParameters));
    }

    @Override
    public Map<String, Object> call(String callString, List<SqlParameter> declaredParameters) throws SQLException {
        SimpleCallableStatementCallback csc = new SimpleCallableStatementCallback(MultipleProcessType.ALL, declaredParameters){

            @Override
            public boolean isResultsCaseInsensitive() {
                return JdbcTemplate.this.isResultsCaseInsensitive();
            }

            @Override
            protected Map<String, Object> createResultsMap() {
                return JdbcTemplate.this.createResultsMap();
            }
        };
        return this.executeCallback(callString, csc);
    }

    protected static Object processResultSet(TypeHandlerRegistry typeRegistry, boolean caseInsensitive, ResultSet rs, SqlParameter.ReturnSqlParameter param) throws SQLException {
        if (rs != null) {
            if (param != null) {
                if (param.getRowMapper() != null) {
                    RowMapper<?> rowMapper = param.getRowMapper();
                    return new RowMapperResultSetExtractor(rowMapper).extractData(rs);
                }
                if (param.getRowCallbackHandler() != null) {
                    RowCallbackHandler rch = param.getRowCallbackHandler();
                    new RowCallbackHandlerResultSetExtractor(rch).extractData(rs);
                    return "ResultSet returned from stored procedure was processed";
                }
                if (param.getResultSetExtractor() != null) {
                    return param.getResultSetExtractor().extractData(rs);
                }
            } else {
                return new ColumnMapResultSetExtractor(0, typeRegistry, caseInsensitive).extractData(rs);
            }
        }
        return null;
    }

    protected Map<String, Object> createResultsMap() {
        if (this.isResultsCaseInsensitive()) {
            return new LinkedCaseInsensitiveMap();
        }
        return new LinkedHashMap<String, Object>();
    }

    private static String getSql(Object sqlProvider) {
        if (sqlProvider instanceof SqlProvider) {
            return ((SqlProvider)sqlProvider).getSql();
        }
        return null;
    }

    private static <T> T requiredSingleResult(Collection<T> results) throws SQLException {
        if (results == null || results.isEmpty()) {
            return null;
        }
        int size = results.size();
        if (size > 1) {
            throw new SQLException("Incorrect record count: expected 1, actual " + size);
        }
        return results.iterator().next();
    }

    protected PreparedStatementSetter newArgPreparedStatementSetter(Object[] args) {
        return new ArgPreparedStatementSetter(args, this.getTypeRegistry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ParsedSql getParsedSql(String originalSql) {
        Map<String, ParsedSql> map = this.parsedSqlCache;
        synchronized (map) {
            ParsedSql parsedSql = this.parsedSqlCache.get(originalSql);
            if (parsedSql == null) {
                parsedSql = ParsedSql.getParsedSql(originalSql);
                this.parsedSqlCache.put(originalSql, parsedSql);
            }
            return parsedSql;
        }
    }

    private class SqlParameterSourceBatchPreparedStatementSetter
    implements BatchPreparedStatementSetter,
    ParameterDisposer {
        private final ParsedSql parsedSql;
        private final SqlParameterSource[] batchArgs;

        public SqlParameterSourceBatchPreparedStatementSetter(String sql, SqlParameterSource[] batchArgs) {
            this.parsedSql = JdbcTemplate.this.getParsedSql(sql);
            this.batchArgs = batchArgs;
        }

        @Override
        public void setValues(PreparedStatement ps, int index) throws SQLException {
            SqlParameterSource paramSource = this.batchArgs[index];
            Object[] sqlValue = this.parsedSql.buildValues(paramSource);
            int sqlColIndex = 1;
            TypeHandlerRegistry typeRegistry = JdbcTemplate.this.getTypeRegistry();
            for (Object element : sqlValue) {
                if (element instanceof SqlParameter.InSqlParameter) {
                    Object value = ((SqlParameter.InSqlParameter)element).getValue();
                    Integer jdbcType = ((SqlParameter.InSqlParameter)element).getJdbcType();
                    TypeHandler<?> typeHandler = ((SqlParameter.InSqlParameter)element).getTypeHandler();
                    if (typeHandler != null && jdbcType != null) {
                        typeHandler.setParameter(ps, sqlColIndex++, value, jdbcType);
                        continue;
                    }
                    if (typeHandler != null) {
                        if (value == null) {
                            ps.setObject(sqlColIndex++, null);
                            continue;
                        }
                        typeHandler.setParameter(ps, sqlColIndex++, value, TypeHandlerRegistry.toSqlType(value.getClass()));
                        continue;
                    }
                    element = value;
                }
                typeRegistry.setParameterValue(ps, sqlColIndex++, element);
            }
        }

        @Override
        public int getBatchSize() {
            return this.batchArgs.length;
        }

        @Override
        public void cleanupParameters() {
            for (SqlParameterSource batchItem : this.batchArgs) {
                if (!(batchItem instanceof ParameterDisposer)) continue;
                ((ParameterDisposer)((Object)batchItem)).cleanupParameters();
            }
        }
    }

    private class MapPreparedStatementCreator
    implements PreparedStatementCreator,
    ParameterDisposer,
    SqlProvider {
        private final ParsedSql parsedSql;
        private final SqlParameterSource paramSource;

        public MapPreparedStatementCreator(String originalSql, SqlParameterSource paramSource) {
            Objects.requireNonNull(originalSql, "SQL must not be null");
            this.parsedSql = JdbcTemplate.this.getParsedSql(originalSql);
            this.paramSource = paramSource;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            String sqlToUse = this.parsedSql.buildSql(this.paramSource);
            Object[] paramArray = this.parsedSql.buildValues(this.paramSource);
            PreparedStatement ps = con.prepareStatement(sqlToUse);
            TypeHandlerRegistry typeRegistry = JdbcTemplate.this.getTypeRegistry();
            for (int i = 0; i < paramArray.length; ++i) {
                typeRegistry.setParameterValue(ps, i + 1, paramArray[i]);
            }
            StatementSetterUtils.cleanupParameters(paramArray);
            return ps;
        }

        @Override
        public String getSql() {
            return this.parsedSql.getOriginalSql();
        }

        @Override
        public void cleanupParameters() {
            if (this.paramSource instanceof ParameterDisposer) {
                ((ParameterDisposer)((Object)this.paramSource)).cleanupParameters();
            }
        }
    }

    private static class SimpleCallableStatementCreator
    implements CallableStatementCreator,
    ParameterDisposer,
    SqlProvider {
        private final String sql;
        private final CallableStatementSetter setter;

        public SimpleCallableStatementCreator(String sql, CallableStatementSetter setter) {
            this.sql = Objects.requireNonNull(sql, "Call string must not be null");
            this.setter = setter;
        }

        @Override
        public CallableStatement createCallableStatement(Connection con) throws SQLException {
            if (!con.getMetaData().supportsStoredProcedures()) {
                throw new UnsupportedOperationException("target DataSource Unsupported.");
            }
            CallableStatement cs = con.prepareCall(this.sql);
            if (this.setter != null) {
                this.setter.setValues(cs);
            }
            return cs;
        }

        @Override
        public String getSql() {
            return this.sql;
        }

        @Override
        public void cleanupParameters() {
            if (this.setter instanceof ParameterDisposer) {
                ((ParameterDisposer)((Object)this.setter)).cleanupParameters();
            }
        }
    }

    private static class SimplePreparedStatementCreator
    implements PreparedStatementCreator,
    ParameterDisposer,
    SqlProvider {
        private final String sql;
        private final PreparedStatementSetter setter;

        public SimplePreparedStatementCreator(String sql, PreparedStatementSetter setter) {
            this.sql = Objects.requireNonNull(sql, "SQL must not be null");
            this.setter = setter;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            PreparedStatement ps = con.prepareStatement(this.sql);
            if (this.setter != null) {
                this.setter.setValues(ps);
            }
            return ps;
        }

        @Override
        public String getSql() {
            return this.sql;
        }

        @Override
        public void cleanupParameters() {
            if (this.setter instanceof ParameterDisposer) {
                ((ParameterDisposer)((Object)this.setter)).cleanupParameters();
            }
        }
    }

    private static class SimpleStatementCreator
    implements SqlProvider {
        private final String sql;

        public SimpleStatementCreator(String sql) {
            this.sql = Objects.requireNonNull(sql, "SQL must not be null");
        }

        public Statement createStatement(Connection con) throws SQLException {
            return con.createStatement();
        }

        @Override
        public String getSql() {
            return this.sql;
        }
    }
}

