/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.jdbc.extractor;

import java.util.Objects;
import java.util.function.Predicate;
import net.hasor.dbvisitor.jdbc.RowMapper;
import net.hasor.dbvisitor.jdbc.extractor.RowMapperResultSetExtractor;

public class FilterResultSetExtractor<T>
extends RowMapperResultSetExtractor<T> {
    private Predicate<T> rowTester;

    public FilterResultSetExtractor(RowMapper<T> rowMapper) {
        this(rowMapper, s -> true, 0);
    }

    public FilterResultSetExtractor(RowMapper<T> rowMapper, Predicate<T> rowTester) {
        this(rowMapper, rowTester, 0);
    }

    public FilterResultSetExtractor(RowMapper<T> rowMapper, Predicate<T> rowTester, int rowsExpected) {
        super(rowMapper, rowsExpected);
        this.rowTester = Objects.requireNonNull(rowTester, "rowTester is null.");
    }

    @Override
    protected boolean testRow(T mapRow) {
        return this.rowTester.test(mapRow);
    }

    public Predicate<T> getRowTester() {
        return this.rowTester;
    }

    public void setRowTester(Predicate<T> rowTester) {
        this.rowTester = Objects.requireNonNull(rowTester, "rowTester is null.");
    }
}

