/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.jdbc.extractor;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hasor.dbvisitor.jdbc.ResultSetExtractor;
import net.hasor.dbvisitor.jdbc.RowMapper;

public class RowMapperResultSetExtractor<T>
implements ResultSetExtractor<List<T>> {
    private final RowMapper<T> rowMapper;
    private final int rowsExpected;

    public RowMapperResultSetExtractor(RowMapper<T> rowMapper) {
        this(rowMapper, 0);
    }

    public RowMapperResultSetExtractor(RowMapper<T> rowMapper, int rowsExpected) {
        Objects.requireNonNull(rowMapper, "RowMapper is required");
        this.rowMapper = rowMapper;
        this.rowsExpected = rowsExpected;
    }

    @Override
    public List<T> extractData(ResultSet rs) throws SQLException {
        ArrayList<T> results = this.rowsExpected > 0 ? new ArrayList<T>(this.rowsExpected) : new ArrayList();
        int rowNum = 0;
        while (rs.next()) {
            T mapRow;
            if (!this.testRow(mapRow = this.rowMapper.mapRow(rs, rowNum++))) continue;
            results.add(mapRow);
            if (this.rowsExpected <= 0 || results.size() < this.rowsExpected) continue;
            break;
        }
        return results;
    }

    protected boolean testRow(T mapRow) {
        return true;
    }
}

