/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.jdbc.mapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.hasor.dbvisitor.jdbc.ResultSetExtractor;
import net.hasor.dbvisitor.mapping.TableReader;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.mapping.resolve.ClassTableMappingResolve;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;

public class MappingResultSetExtractor<T>
implements ResultSetExtractor<List<T>> {
    private final TableReader<T> tableReader;

    public MappingResultSetExtractor(Class<T> mapperClass, TypeHandlerRegistry typeRegistry) {
        Objects.requireNonNull(mapperClass, "mapperClass is required");
        TableMapping<?> tableMapping = ClassTableMappingResolve.resolveTableMapping(mapperClass, typeRegistry);
        this.tableReader = tableMapping.toReader();
    }

    public MappingResultSetExtractor(TableReader<T> tableReader) {
        this.tableReader = Objects.requireNonNull(tableReader, "tableReader is null.");
    }

    @Override
    public List<T> extractData(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        ArrayList<String> columnList = new ArrayList<String>();
        for (int i = 1; i <= nrOfColumns; ++i) {
            columnList.add(MappingResultSetExtractor.lookupColumnName(rsmd, i));
        }
        ArrayList<T> results = new ArrayList<T>();
        int rowNum = 0;
        while (rs.next()) {
            results.add(this.tableReader.extractRow(columnList, rs, rowNum++));
        }
        return results;
    }

    private static String lookupColumnName(ResultSetMetaData resultSetMetaData, int columnIndex) throws SQLException {
        String name = resultSetMetaData.getColumnLabel(columnIndex);
        if (name == null || name.length() < 1) {
            name = resultSetMetaData.getColumnName(columnIndex);
        }
        return name;
    }
}

