/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.jdbc.mapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import net.hasor.dbvisitor.jdbc.RowMapper;
import net.hasor.dbvisitor.mapping.TableReader;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.mapping.resolve.ClassTableMappingResolve;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;

public class MappingRowMapper<T>
implements RowMapper<T> {
    private final TableReader<T> tableReader;

    public MappingRowMapper(Class<T> mapperClass) {
        this(mapperClass, TypeHandlerRegistry.DEFAULT);
    }

    public MappingRowMapper(Class<T> mapperClass, TypeHandlerRegistry typeRegistry) {
        TableMapping<?> tableMapping = ClassTableMappingResolve.resolveTableMapping(mapperClass, typeRegistry);
        this.tableReader = tableMapping.toReader();
    }

    @Override
    public T mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int nrOfColumns = rsmd.getColumnCount();
        ArrayList<String> columnList = new ArrayList<String>();
        for (int i = 1; i <= nrOfColumns; ++i) {
            String colName = rsmd.getColumnName(i);
            columnList.add(colName);
        }
        return this.tableReader.extractRow(columnList, rs, rowNum);
    }
}

