/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.lambda;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.JdbcUtils;
import net.hasor.dbvisitor.dialect.DefaultSqlDialect;
import net.hasor.dbvisitor.dialect.SqlDialect;
import net.hasor.dbvisitor.dialect.SqlDialectRegister;
import net.hasor.dbvisitor.jdbc.DynamicConnection;
import net.hasor.dbvisitor.jdbc.core.JdbcTemplate;
import net.hasor.dbvisitor.lambda.EntityDeleteOperation;
import net.hasor.dbvisitor.lambda.EntityQueryOperation;
import net.hasor.dbvisitor.lambda.EntityUpdateOperation;
import net.hasor.dbvisitor.lambda.InsertOperation;
import net.hasor.dbvisitor.lambda.LambdaOperations;
import net.hasor.dbvisitor.lambda.MapDeleteOperation;
import net.hasor.dbvisitor.lambda.MapQueryOperation;
import net.hasor.dbvisitor.lambda.MapUpdateOperation;
import net.hasor.dbvisitor.lambda.core.BasicLambda;
import net.hasor.dbvisitor.lambda.support.entity.DeleteLambdaForEntity;
import net.hasor.dbvisitor.lambda.support.entity.InsertLambdaForEntity;
import net.hasor.dbvisitor.lambda.support.entity.SelectLambdaForEntity;
import net.hasor.dbvisitor.lambda.support.entity.UpdateLambdaForEntity;
import net.hasor.dbvisitor.lambda.support.map.DeleteLambdaForMap;
import net.hasor.dbvisitor.lambda.support.map.InsertLambdaForMap;
import net.hasor.dbvisitor.lambda.support.map.SelectLambdaForMap;
import net.hasor.dbvisitor.lambda.support.map.UpdateLambdaForMap;
import net.hasor.dbvisitor.mapping.def.TableDef;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.mapping.resolve.ClassTableMappingResolve;
import net.hasor.dbvisitor.mapping.resolve.MappingOptions;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;

public class LambdaTemplate
extends JdbcTemplate
implements LambdaOperations {
    protected final Map<Class<?>, TableMapping<?>> entMapping = new ConcurrentHashMap();
    protected final Map<String, TableMapping<?>> mapMapping = new ConcurrentHashMap();
    protected SqlDialect dialect = null;
    protected boolean useQualifier;

    public LambdaTemplate() {
        this.init();
    }

    public LambdaTemplate(DataSource dataSource) {
        super(dataSource);
        this.init();
    }

    public LambdaTemplate(DataSource dataSource, TypeHandlerRegistry typeRegistry) {
        super(dataSource, typeRegistry);
        this.init();
    }

    public LambdaTemplate(Connection conn) {
        super(conn);
        this.init();
    }

    public LambdaTemplate(Connection conn, TypeHandlerRegistry typeRegistry) {
        super(conn, typeRegistry);
    }

    public LambdaTemplate(DynamicConnection dynamicConn) {
        super(dynamicConn);
        this.init();
    }

    public LambdaTemplate(DynamicConnection dynamicConn, TypeHandlerRegistry typeRegistry) {
        super(dynamicConn, typeRegistry);
    }

    public LambdaTemplate(JdbcTemplate jdbcTemplate) {
        this.setDataSource(jdbcTemplate.getDataSource());
        this.setConnection(jdbcTemplate.getConnection());
        this.setDynamic(jdbcTemplate.getDynamic());
        this.setResultsCaseInsensitive(jdbcTemplate.isResultsCaseInsensitive());
        this.setTypeRegistry(jdbcTemplate.getTypeRegistry());
        this.setFetchSize(jdbcTemplate.getFetchSize());
        this.setMaxRows(jdbcTemplate.getMaxRows());
        this.setQueryTimeout(jdbcTemplate.getQueryTimeout());
        this.setIgnoreWarnings(jdbcTemplate.isIgnoreWarnings());
        this.setPrintStmtError(jdbcTemplate.isPrintStmtError());
    }

    protected void init() {
        this.dialect = this.fetchDialect();
    }

    protected SqlDialect fetchDialect() {
        if (this.getConnection() == null && this.getDynamic() == null && this.getDataSource() == null) {
            return DefaultSqlDialect.DEFAULT;
        }
        String tmpDbType = "";
        try {
            tmpDbType = this.execute((Connection con) -> {
                DatabaseMetaData metaData = con.getMetaData();
                return JdbcUtils.getDbType(metaData.getURL(), metaData.getDriverName());
            });
        }
        catch (Exception e) {
            tmpDbType = "";
        }
        return SqlDialectRegister.findOrCreate(tmpDbType);
    }

    public SqlDialect getDialect() {
        return this.dialect;
    }

    public void setDialect(SqlDialect dialect) {
        this.dialect = dialect;
    }

    public boolean isUseQualifier() {
        return this.useQualifier;
    }

    public void setUseQualifier(boolean useQualifier) {
        this.useQualifier = useQualifier;
    }

    protected <T> TableMapping<T> getTableMapping(Class<T> exampleType, MappingOptions options) {
        if (exampleType == null) {
            throw new NullPointerException("exampleType is null.");
        }
        if (exampleType == Map.class) {
            throw new UnsupportedOperationException("Map cannot be used as lambda exampleType.");
        }
        TableMapping mapping = this.entMapping.get(exampleType);
        if (mapping != null) {
            if (exampleType == mapping.entityType() || exampleType.isAssignableFrom(mapping.entityType())) {
                return mapping;
            }
            throw new ClassCastException("exampleType is incompatible with TableMapping.");
        }
        mapping = this.entMapping.computeIfAbsent(exampleType, key -> {
            TableDef<?> tableDef;
            MappingOptions opt = new MappingOptions(options);
            if (opt.getCaseInsensitive() == null) {
                opt.setCaseInsensitive(this.isResultsCaseInsensitive());
            }
            if (opt.getDefaultDialect() == null) {
                opt.setDefaultDialect(this.getDialect());
            }
            if (StringUtils.isBlank((String)(tableDef = new ClassTableMappingResolve(opt).resolveTableMapping(exampleType, (MappingOptions)null, exampleType.getClassLoader(), this.getTypeRegistry())).getTable())) {
                if (tableDef.isMapUnderscoreToCamelCase()) {
                    tableDef.setTable(StringUtils.humpToLine((String)exampleType.getSimpleName()));
                } else {
                    tableDef.setTable(exampleType.getSimpleName());
                }
            }
            return tableDef;
        });
        return mapping;
    }

    protected TableMapping<?> getTableMapping(String catalog, String schema, String table, MappingOptions opt) throws SQLException {
        if (StringUtils.isBlank((String)table)) {
            throw new NullPointerException("table is blank.");
        }
        String mappingKey = String.format("'%s'.'%s'.'%s'", catalog, schema, table);
        TableMapping<?> mapping = this.mapMapping.get(mappingKey);
        if (mapping != null) {
            return mapping;
        }
        MappingOptions copyOpt = MappingOptions.buildNew(opt);
        copyOpt.setUseDelimited(Boolean.TRUE.equals(copyOpt.getUseDelimited()));
        copyOpt.setCaseInsensitive(this.isResultsCaseInsensitive());
        copyOpt.setMapUnderscoreToCamelCase(Boolean.TRUE.equals(copyOpt.getMapUnderscoreToCamelCase()));
        copyOpt.setDefaultDialect(this.getDialect());
        String finalCatalog = StringUtils.isBlank((String)catalog) ? null : catalog;
        String finalSchema = StringUtils.isBlank((String)schema) ? null : schema;
        String finalTable = StringUtils.isBlank((String)table) ? null : table;
        boolean useDelimited = copyOpt.getUseDelimited();
        boolean caseInsensitive = copyOpt.getCaseInsensitive();
        boolean camelCase = copyOpt.getMapUnderscoreToCamelCase();
        TableDef<LinkedHashMap> tableDef = new TableDef<LinkedHashMap>(finalCatalog, finalSchema, finalTable, LinkedHashMap.class, true, useDelimited, caseInsensitive, camelCase);
        this.mapMapping.put(mappingKey, tableDef);
        return tableDef;
    }

    protected <E extends BasicLambda<R, T, P>, R, T, P> E configLambda(E execute) {
        if (this.useQualifier) {
            execute.useQualifier();
        }
        return execute;
    }

    @Override
    public <T> InsertOperation<T> lambdaInsert(Class<T> exampleType, MappingOptions options) {
        return this.configLambda(new InsertLambdaForEntity<T>(exampleType, this.getTableMapping(exampleType, options), this));
    }

    @Override
    public InsertOperation<Map<String, Object>> lambdaInsert(String catalog, String schema, String table, MappingOptions options) throws SQLException {
        return this.configLambda(new InsertLambdaForMap(this.getTableMapping(catalog, schema, table, options), this));
    }

    @Override
    public <T> EntityUpdateOperation<T> lambdaUpdate(Class<T> exampleType, MappingOptions options) {
        return this.configLambda(new UpdateLambdaForEntity<T>(exampleType, this.getTableMapping(exampleType, options), this));
    }

    @Override
    public MapUpdateOperation lambdaUpdate(String catalog, String schema, String table, MappingOptions options) throws SQLException {
        return this.configLambda(new UpdateLambdaForMap(this.getTableMapping(catalog, schema, table, options), this));
    }

    @Override
    public <T> EntityDeleteOperation<T> lambdaDelete(Class<T> exampleType, MappingOptions options) {
        return this.configLambda(new DeleteLambdaForEntity<T>(exampleType, this.getTableMapping(exampleType, options), this));
    }

    @Override
    public MapDeleteOperation lambdaDelete(String catalog, String schema, String table, MappingOptions options) throws SQLException {
        return this.configLambda(new DeleteLambdaForMap(this.getTableMapping(catalog, schema, table, options), this));
    }

    @Override
    public <T> EntityQueryOperation<T> lambdaQuery(Class<T> exampleType, MappingOptions options) {
        return this.configLambda(new SelectLambdaForEntity<T>(exampleType, this.getTableMapping(exampleType, options), this));
    }

    @Override
    public MapQueryOperation lambdaQuery(String catalog, String schema, String table, MappingOptions options) throws SQLException {
        return this.configLambda(new SelectLambdaForMap(this.getTableMapping(catalog, schema, table, options), this));
    }

    public void resetMapping() {
        this.entMapping.clear();
        this.mapMapping.clear();
    }

    public void resetMapping(String catalog, String schema, String table) {
        if (StringUtils.isBlank((String)table)) {
            throw new NullPointerException("table is blank.");
        }
        this.mapMapping.remove(String.format("'%s'.'%s'.'%s'", catalog, schema, table));
    }

    public void resetMapping(Class<?> exampleType) {
        this.entMapping.remove(exampleType);
    }
}

