/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.lambda.core;

import java.sql.SQLException;
import net.hasor.dbvisitor.dialect.BoundSql;
import net.hasor.dbvisitor.dialect.SqlDialect;
import net.hasor.dbvisitor.lambda.LambdaTemplate;
import net.hasor.dbvisitor.lambda.core.BasicQueryCompare;
import net.hasor.dbvisitor.lambda.core.DeleteExecute;
import net.hasor.dbvisitor.lambda.segment.MergeSqlSegment;
import net.hasor.dbvisitor.lambda.segment.Segment;
import net.hasor.dbvisitor.lambda.segment.SqlKeyword;
import net.hasor.dbvisitor.mapping.def.TableMapping;

public abstract class AbstractDeleteLambda<R, T, P>
extends BasicQueryCompare<R, T, P>
implements DeleteExecute<R> {
    private boolean allowEmptyWhere = false;

    public AbstractDeleteLambda(Class<?> exampleType, TableMapping<?> tableMapping, LambdaTemplate jdbcTemplate) {
        super(exampleType, tableMapping, jdbcTemplate);
    }

    @Override
    public int doDelete() throws SQLException {
        BoundSql boundSql = this.getBoundSql();
        String sqlString = boundSql.getSqlString();
        if (logger.isDebugEnabled()) {
            logger.trace("Executing SQL statement [" + sqlString + "].");
        }
        return this.getJdbcTemplate().executeUpdate(sqlString, boundSql.getArgs());
    }

    @Override
    public R allowEmptyWhere() {
        this.allowEmptyWhere = true;
        return this.getSelf();
    }

    @Override
    protected BoundSql buildBoundSql(SqlDialect dialect) {
        this.queryParam.clear();
        MergeSqlSegment updateTemplate = new MergeSqlSegment(new Segment[0]);
        updateTemplate.addSegment(SqlKeyword.DELETE);
        updateTemplate.addSegment(SqlKeyword.FROM);
        TableMapping<?> tableMapping = this.getTableMapping();
        String catalogName = tableMapping.getCatalog();
        String schemaName = tableMapping.getSchema();
        String tableName = tableMapping.getTable();
        String fullTableName = dialect.tableName(this.isQualifier(), catalogName, schemaName, tableName);
        updateTemplate.addSegment(() -> fullTableName);
        if (!this.queryTemplate.isEmpty()) {
            updateTemplate.addSegment(SqlKeyword.WHERE);
            updateTemplate.addSegment(this.queryTemplate.sub(1));
        } else if (!this.allowEmptyWhere) {
            throw new UnsupportedOperationException("The dangerous DELETE operation, You must call `allowEmptyWhere()` to enable DELETE ALL.");
        }
        String sqlQuery = updateTemplate.getSqlSegment();
        Object[] args = (Object[])this.queryParam.toArray().clone();
        return new BoundSql.BoundSqlObj(sqlQuery, args);
    }
}

