/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.lambda.core;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.dialect.DefaultSqlDialect;
import net.hasor.dbvisitor.dialect.InsertSqlDialect;
import net.hasor.dbvisitor.dialect.SqlDialect;
import net.hasor.dbvisitor.jdbc.core.ParameterDisposer;
import net.hasor.dbvisitor.keyholder.KeySeqHolder;
import net.hasor.dbvisitor.lambda.DuplicateKeyStrategy;
import net.hasor.dbvisitor.lambda.LambdaTemplate;
import net.hasor.dbvisitor.lambda.core.BasicLambda;
import net.hasor.dbvisitor.lambda.core.InsertExecute;
import net.hasor.dbvisitor.mapping.def.ColumnMapping;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;

public abstract class AbstractInsertLambda<R, T, P>
extends BasicLambda<R, T, P>
implements InsertExecute<R, T> {
    protected final List<ColumnMapping> insertProperties = new ArrayList<ColumnMapping>();
    protected final List<ColumnMapping> fillBeforeProperties = new ArrayList<ColumnMapping>();
    protected final List<ColumnMapping> fillAfterProperties = new ArrayList<ColumnMapping>();
    protected DuplicateKeyStrategy insertStrategy;
    protected final List<String> primaryKeys;
    protected final List<String> insertColumns;
    protected final Map<String, String> insertColumnTerms;
    protected final boolean hasKeySeqHolderColumn;
    protected final List<InsertEntity> insertValues;
    protected final List<ParameterDisposer> parameterDisposers;
    protected final List<InsertEntity> fillBackEntityList;

    public AbstractInsertLambda(Class<?> exampleType, TableMapping<?> tableMapping, LambdaTemplate jdbcTemplate) {
        super(exampleType, tableMapping, jdbcTemplate);
        this.initProperties(this.insertProperties, this.fillBeforeProperties, this.fillAfterProperties);
        if (!tableMapping.isMapEntity() && this.insertProperties.size() == 0) {
            throw new IllegalStateException("no column require INSERT.");
        }
        this.insertColumns = new ArrayList<String>();
        this.insertColumnTerms = new LinkedHashMap<String, String>();
        for (ColumnMapping colMap : this.insertProperties) {
            this.insertColumns.add(colMap.getColumn());
            if (!StringUtils.isNotBlank((String)colMap.getInsertTemplate())) continue;
            this.insertColumnTerms.put(colMap.getColumn(), colMap.getInsertTemplate());
        }
        this.insertValues = new ArrayList<InsertEntity>();
        this.insertStrategy = DuplicateKeyStrategy.Into;
        this.primaryKeys = this.getPrimaryKey().stream().map(ColumnMapping::getColumn).collect(Collectors.toList());
        this.hasKeySeqHolderColumn = !this.fillBeforeProperties.isEmpty() || !this.fillAfterProperties.isEmpty();
        this.parameterDisposers = new ArrayList<ParameterDisposer>();
        this.fillBackEntityList = new ArrayList<InsertEntity>();
    }

    protected void initProperties(List<ColumnMapping> insert, List<ColumnMapping> fillBefore, List<ColumnMapping> fillAfter) {
        TableMapping<?> tableMapping = this.getTableMapping();
        HashSet<String> insertColumns = new HashSet<String>();
        for (ColumnMapping mapping : tableMapping.getProperties()) {
            KeySeqHolder keySeqHolder = mapping.getKeySeqHolder();
            if (keySeqHolder != null) {
                if (keySeqHolder.onBefore()) {
                    fillBefore.add(mapping);
                }
                if (keySeqHolder.onAfter()) {
                    fillAfter.add(mapping);
                }
            }
            String columnName = mapping.getColumn();
            if (!mapping.isInsert()) continue;
            if (insertColumns.contains(columnName)) {
                throw new IllegalStateException("Multiple property mapping to '" + columnName + "' column");
            }
            insertColumns.add(columnName);
            insert.add(mapping);
        }
    }

    @Override
    public R onDuplicateStrategy(DuplicateKeyStrategy insertStrategy) {
        this.insertStrategy = Objects.requireNonNull(insertStrategy);
        return this.getSelf();
    }

    @Override
    public R applyEntity(List<T> entityList) throws SQLException {
        for (T entity : entityList) {
            InsertEntity ent = new InsertEntity();
            ent.isMap = this.exampleIsMap();
            ent.object = entity;
            this.insertValues.add(ent);
        }
        return this.getSelf();
    }

    @Override
    public R applyMap(List<Map<String, Object>> entityList) throws SQLException {
        for (Map<String, Object> entity : entityList) {
            InsertEntity ent = new InsertEntity();
            ent.isMap = true;
            ent.object = entity;
            this.insertValues.add(ent);
        }
        return this.getSelf();
    }

    protected String buildInsert(SqlDialect dialect, List<String> primaryKeys, List<String> insertColumns, Map<String, String> insertColumnTerms) {
        boolean isInsertSqlDialect = dialect instanceof InsertSqlDialect;
        TableMapping<?> tableMapping = this.getTableMapping();
        String catalogName = tableMapping.getCatalog();
        String schemaName = tableMapping.getSchema();
        String tableName = tableMapping.getTable();
        if (!isInsertSqlDialect) {
            return DefaultSqlDialect.DEFAULT.insertInto(this.isQualifier(), catalogName, schemaName, tableName, primaryKeys, insertColumns, insertColumnTerms);
        }
        switch (this.insertStrategy) {
            case Into: {
                InsertSqlDialect insertDialect = (InsertSqlDialect)dialect;
                if (!insertDialect.supportInto(primaryKeys, insertColumns)) break;
                return insertDialect.insertInto(this.isQualifier(), catalogName, schemaName, tableName, primaryKeys, insertColumns, insertColumnTerms);
            }
            case Ignore: {
                InsertSqlDialect insertDialect = (InsertSqlDialect)dialect;
                if (!insertDialect.supportIgnore(primaryKeys, insertColumns)) break;
                return insertDialect.insertIgnore(this.isQualifier(), catalogName, schemaName, tableName, primaryKeys, insertColumns, insertColumnTerms);
            }
            case Update: {
                InsertSqlDialect insertDialect = (InsertSqlDialect)dialect;
                if (!insertDialect.supportReplace(primaryKeys, insertColumns)) break;
                return insertDialect.insertReplace(this.isQualifier(), catalogName, schemaName, tableName, primaryKeys, insertColumns, insertColumnTerms);
            }
        }
        throw new UnsupportedOperationException((Object)((Object)this.insertStrategy) + " Unsupported.");
    }

    protected PreparedStatement createPrepareStatement(Connection con, String sqlString) throws SQLException {
        if (this.hasKeySeqHolderColumn) {
            return con.prepareStatement(sqlString, 1);
        }
        return con.prepareStatement(sqlString);
    }

    protected void applyPreparedStatement(PreparedStatement ps, Object[] batchValues, TypeHandlerRegistry typeRegistry) throws SQLException {
        int idx = 1;
        for (Object value : batchValues) {
            if (value == null) {
                ps.setObject(idx, null);
            } else {
                typeRegistry.setParameterValue(ps, idx, value);
            }
            ++idx;
        }
    }

    protected static class InsertEntity {
        public Object object;
        public boolean isMap;

        protected InsertEntity() {
        }
    }
}

