/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.lambda.core;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.hasor.cobble.CollectionUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.dialect.BoundSql;
import net.hasor.dbvisitor.dialect.SqlDialect;
import net.hasor.dbvisitor.lambda.LambdaTemplate;
import net.hasor.dbvisitor.lambda.core.BasicQueryCompare;
import net.hasor.dbvisitor.lambda.core.UpdateExecute;
import net.hasor.dbvisitor.lambda.segment.MergeSqlSegment;
import net.hasor.dbvisitor.lambda.segment.Segment;
import net.hasor.dbvisitor.lambda.segment.SqlKeyword;
import net.hasor.dbvisitor.mapping.def.ColumnMapping;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.types.MappedArg;
import net.hasor.dbvisitor.types.TypeHandler;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;

public abstract class AbstractUpdateLambda<R, T, P>
extends BasicQueryCompare<R, T, P>
implements UpdateExecute<R, T, P> {
    protected final Set<String> allowUpdateKeys;
    protected final Map<String, ColumnMapping> allowUpdateProperties = new LinkedHashMap<String, ColumnMapping>();
    protected final Map<String, MappedArg> updateValueMap;
    private boolean allowEmptyWhere = false;
    private boolean allowUpdateKey = false;
    private boolean allowReplaceRow = false;

    public AbstractUpdateLambda(Class<?> exampleType, TableMapping<?> tableMapping, LambdaTemplate jdbcTemplate) {
        super(exampleType, tableMapping, jdbcTemplate);
        this.allowUpdateKeys = new LinkedHashSet<String>();
        for (ColumnMapping mapping : tableMapping.getProperties()) {
            if (!mapping.isUpdate()) continue;
            this.allowUpdateProperties.put(mapping.getProperty(), mapping);
            this.allowUpdateKeys.add(mapping.getProperty());
        }
        this.updateValueMap = new HashMap<String, MappedArg>();
    }

    @Override
    public R resetUpdate() {
        this.updateValueMap.clear();
        return this.getSelf();
    }

    @Override
    public R allowEmptyWhere() {
        this.allowEmptyWhere = true;
        return this.getSelf();
    }

    @Override
    public R allowUpdateKey() {
        this.allowUpdateKey = true;
        return this.getSelf();
    }

    @Override
    public R allowReplaceRow() {
        this.allowReplaceRow = true;
        return this.getSelf();
    }

    @Override
    public int doUpdate() throws SQLException {
        if (this.updateValueMap.isEmpty()) {
            throw new IllegalStateException("Nothing to update.");
        }
        BoundSql boundSql = this.getBoundSql();
        String sqlString = boundSql.getSqlString();
        if (logger.isDebugEnabled()) {
            logger.trace("Executing SQL statement [" + sqlString + "].");
        }
        return this.getJdbcTemplate().executeUpdate(sqlString, boundSql.getArgs());
    }

    @Override
    public R updateToSample(T newValue) {
        return this.updateToSampleCondition(newValue, t -> true);
    }

    @Override
    public R updateToSampleCondition(T newValue, Predicate<String> condition) {
        if (newValue == null) {
            throw new NullPointerException("newValue is null.");
        }
        if (this.exampleIsMap()) {
            return this.updateToMapCondition((Map)newValue, condition);
        }
        HashMap<String, Object> tempData = new HashMap<String, Object>();
        for (Map.Entry<String, ColumnMapping> mappingEntry : this.allowUpdateProperties.entrySet()) {
            Object value = mappingEntry.getValue().getHandler().get(newValue);
            if (value == null) continue;
            tempData.put(mappingEntry.getKey(), value);
        }
        return this.updateToByCondition(true, this.allowUpdateKeys, true, s -> tempData.containsKey(s) && condition.test((String)s), tempData::get);
    }

    @Override
    public R updateToMap(Map<String, Object> newValue) {
        return this.updateToMapCondition(newValue, t -> true);
    }

    @Override
    public R updateToMapCondition(Map<String, Object> newValue, Predicate<String> condition) {
        if (newValue == null) {
            throw new NullPointerException("newValue is null.");
        }
        Map<String, String> entityKeyMap = this.extractKeysMap(newValue);
        boolean useMapping = !this.allowUpdateProperties.isEmpty();
        Set<String> keySet = useMapping ? this.allowUpdateKeys : entityKeyMap.keySet();
        return this.updateToByCondition(useMapping, keySet, true, s -> entityKeyMap.containsKey(s) && condition.test((String)s), s -> newValue.get(entityKeyMap.get(s)));
    }

    @Override
    public R updateTo(T newValue) {
        return this.updateToCondition(newValue, t -> true);
    }

    @Override
    public R updateToCondition(T newValue, Predicate<String> condition) {
        if (newValue == null) {
            throw new NullPointerException("newValue is null.");
        }
        if (!this.allowReplaceRow) {
            throw new UnsupportedOperationException("The dangerous UPDATE operation, You must call `allowReplaceRow()` to enable REPLACE row.");
        }
        if (this.exampleIsMap()) {
            Map newValueMap = (Map)newValue;
            Map<String, String> entityKeyMap = this.extractKeysMap((Map)newValue);
            boolean useMapping = !this.allowUpdateProperties.isEmpty();
            return this.updateToByCondition(useMapping, entityKeyMap.keySet(), true, condition, s -> newValueMap.get(entityKeyMap.get(s)));
        }
        return this.updateToByCondition(true, this.allowUpdateKeys, true, condition, this.createPropertyReaderFunc(newValue));
    }

    @Override
    public R updateTo(boolean test, P property, Object value) {
        if (test) {
            boolean useMapping;
            Map newValue = CollectionUtils.asMap((Object)this.getPropertyName(property), (Object)value);
            Map<String, String> entityKeyMap = this.extractKeysMap(newValue);
            boolean bl = useMapping = !this.exampleIsMap() && !this.allowUpdateProperties.isEmpty();
            if (this.exampleIsMap()) {
                return this.updateToByCondition(useMapping, entityKeyMap.keySet(), false, entityKeyMap::containsKey, s -> newValue.get(entityKeyMap.get(s)));
            }
            return this.updateToByCondition(useMapping, this.allowUpdateKeys, false, entityKeyMap::containsKey, s -> newValue.get(entityKeyMap.get(s)));
        }
        return this.getSelf();
    }

    private Function<String, Object> createPropertyReaderFunc(T newValue) {
        if (this.exampleIsMap()) {
            return ((Map)newValue)::get;
        }
        TableMapping<?> tableMapping = this.getTableMapping();
        return property -> {
            ColumnMapping propertyReader = tableMapping.getPropertyByName((String)property);
            return propertyReader == null ? null : propertyReader.getHandler().get(newValue);
        };
    }

    protected R updateToByCondition(boolean useMapping, Set<String> foreach, boolean doClear, Predicate<String> propertyTester, Function<String, Object> propertyReader) {
        if (doClear) {
            this.updateValueMap.clear();
        }
        HashSet<String> updateColumns = new HashSet<String>();
        for (String forItem : foreach) {
            String propertyName;
            String columnName;
            ColumnMapping mapping;
            if (useMapping) {
                mapping = this.allowUpdateProperties.get(forItem);
                columnName = mapping.getColumn();
                propertyName = mapping.getProperty();
            } else {
                mapping = null;
                columnName = forItem;
                propertyName = forItem;
            }
            if (!propertyTester.test(propertyName)) continue;
            if (updateColumns.contains(columnName)) {
                throw new IllegalStateException("Multiple property mapping to '" + columnName + "' column");
            }
            updateColumns.add(columnName);
            Object propertyValue = propertyReader.apply(propertyName);
            if (mapping != null && mapping.isPrimaryKey() && !this.allowUpdateKey) {
                if (propertyValue == null) continue;
                throw new UnsupportedOperationException("The dangerous UPDATE operation, You must call `allowUpdateKey()` to enable UPDATE PrimaryKey.");
            }
            if (propertyValue == null) {
                this.updateValueMap.put(propertyName, null);
                continue;
            }
            if (mapping != null) {
                MappedArg mappedArg = new MappedArg(propertyValue, mapping.getJdbcType(), this.exampleIsMap() ? null : mapping.getTypeHandler());
                this.updateValueMap.put(propertyName, mappedArg);
                continue;
            }
            int sqlType = TypeHandlerRegistry.toSqlType(propertyValue.getClass());
            TypeHandler<?> typeHandler = TypeHandlerRegistry.DEFAULT.getTypeHandler(propertyValue.getClass());
            MappedArg mappedArg = new MappedArg(propertyValue, sqlType, typeHandler);
            this.updateValueMap.put(propertyName, mappedArg);
        }
        return this.getSelf();
    }

    @Override
    protected BoundSql buildBoundSql(SqlDialect dialect) {
        if (this.updateValueMap.isEmpty()) {
            throw new IllegalStateException("nothing to update.");
        }
        this.queryParam.clear();
        MergeSqlSegment updateTemplate = new MergeSqlSegment(new Segment[0]);
        updateTemplate.addSegment(SqlKeyword.UPDATE);
        TableMapping<?> tableMapping = this.getTableMapping();
        String catalogName = tableMapping.getCatalog();
        String schemaName = tableMapping.getSchema();
        String tableName = tableMapping.getTable();
        String table = dialect.tableName(this.isQualifier(), catalogName, schemaName, tableName);
        updateTemplate.addSegment(() -> table);
        updateTemplate.addSegment(SqlKeyword.SET);
        boolean isFirstColumn = true;
        for (String propertyName : this.updateValueMap.keySet()) {
            String colValue;
            String colName;
            if (isFirstColumn) {
                isFirstColumn = false;
            } else {
                updateTemplate.addSegment(() -> ",");
            }
            ColumnMapping mapping = this.allowUpdateProperties.get(propertyName);
            if (mapping != null) {
                String specialName = mapping.getSetColTemplate();
                colName = StringUtils.isNotBlank((String)specialName) ? specialName : dialect.fmtName(this.isQualifier(), mapping.getColumn());
                String specialValue = mapping.getSetValueTemplate();
                colValue = StringUtils.isNotBlank((String)specialValue) ? specialValue : "?";
            } else {
                colName = dialect.fmtName(this.isQualifier(), propertyName);
                colValue = "?";
            }
            MappedArg columnValue = this.updateValueMap.get(propertyName);
            updateTemplate.addSegment(() -> colName, SqlKeyword.EQ, this.formatSegment(colValue, columnValue));
        }
        if (!this.queryTemplate.isEmpty()) {
            updateTemplate.addSegment(SqlKeyword.WHERE);
            updateTemplate.addSegment(this.queryTemplate.sub(1));
        } else if (!this.allowEmptyWhere) {
            throw new UnsupportedOperationException("The dangerous UPDATE operation, You must call `allowEmptyWhere()` to enable UPDATE ALL.");
        }
        String sqlQuery = updateTemplate.getSqlSegment();
        Object[] args = (Object[])this.queryParam.toArray().clone();
        return new BoundSql.BoundSqlObj(sqlQuery, args);
    }
}

