/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.lambda.core;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.function.Property;
import net.hasor.cobble.logging.Logger;
import net.hasor.cobble.logging.LoggerFactory;
import net.hasor.cobble.ref.LinkedCaseInsensitiveMap;
import net.hasor.dbvisitor.JdbcUtils;
import net.hasor.dbvisitor.dialect.BoundSql;
import net.hasor.dbvisitor.dialect.DefaultSqlDialect;
import net.hasor.dbvisitor.dialect.SqlDialect;
import net.hasor.dbvisitor.dialect.SqlDialectRegister;
import net.hasor.dbvisitor.jdbc.PreparedStatementCreator;
import net.hasor.dbvisitor.jdbc.SqlProvider;
import net.hasor.dbvisitor.jdbc.core.ParameterDisposer;
import net.hasor.dbvisitor.lambda.LambdaTemplate;
import net.hasor.dbvisitor.lambda.segment.Segment;
import net.hasor.dbvisitor.mapping.def.ColumnMapping;
import net.hasor.dbvisitor.mapping.def.TableMapping;

public abstract class BasicLambda<R, T, P> {
    protected static final Logger logger = LoggerFactory.getLogger(BasicLambda.class);
    private SqlDialect dialect;
    private final Class<?> exampleType;
    private final boolean exampleIsMap;
    private final TableMapping<?> tableMapping;
    private final List<ColumnMapping> primaryKey;
    private final LambdaTemplate jdbcTemplate;
    private boolean qualifier;

    public BasicLambda(Class<?> exampleType, TableMapping<?> tableMapping, LambdaTemplate jdbcTemplate) {
        this.exampleType = Objects.requireNonNull(exampleType, "exampleType is null.");
        this.exampleIsMap = Map.class == exampleType || Map.class.isAssignableFrom(this.exampleType());
        this.tableMapping = Objects.requireNonNull(tableMapping, "tableMapping is null.");
        this.primaryKey = this.getPrimaryKeyColumns(this.tableMapping);
        this.jdbcTemplate = jdbcTemplate;
        String tmpDbType = "";
        try {
            tmpDbType = jdbcTemplate.execute(con -> {
                DatabaseMetaData metaData = con.getMetaData();
                return JdbcUtils.getDbType(metaData.getURL(), metaData.getDriverName());
            });
        }
        catch (Exception e) {
            tmpDbType = "";
        }
        SqlDialect tempDialect = SqlDialectRegister.findOrCreate(tmpDbType);
        this.dialect = tempDialect == null ? DefaultSqlDialect.DEFAULT : tempDialect;
        this.qualifier = tableMapping.useDelimited();
    }

    public final Class<?> exampleType() {
        return this.exampleType;
    }

    public R useQualifier() {
        this.qualifier = true;
        return this.getSelf();
    }

    public final LambdaTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    protected final TableMapping<?> getTableMapping() {
        return this.tableMapping;
    }

    protected final SqlDialect dialect() {
        return this.dialect;
    }

    public final void setDialect(SqlDialect sqlDialect) {
        this.dialect = sqlDialect;
    }

    protected boolean isQualifier() {
        return this.qualifier;
    }

    protected boolean exampleIsMap() {
        return this.exampleIsMap;
    }

    protected abstract String getPropertyName(P var1);

    protected Segment buildSelectByProperty(String propertyName) {
        return this.buildGroupOrderByProperty(false, true, propertyName);
    }

    protected Segment buildConditionByProperty(String propertyName) {
        return this.buildGroupOrderByProperty(true, false, propertyName);
    }

    protected Segment buildConditionByColumn(String columnName) {
        return () -> this.dialect().fmtName(this.isQualifier(), columnName);
    }

    protected Segment buildGroupOrderByProperty(String propertyName) {
        return this.buildGroupOrderByProperty(false, false, propertyName);
    }

    private Segment buildGroupOrderByProperty(boolean isWhere, boolean isSelect, String propertyName) {
        String specialSelectCol;
        TableMapping<?> tableMapping = this.getTableMapping();
        String catalogName = tableMapping.getCatalog();
        String schemaName = tableMapping.getSchema();
        String tableName = tableMapping.getTable();
        ColumnMapping propertyInfo = tableMapping.getPropertyByName(propertyName);
        if (propertyInfo == null) {
            String tab = this.dialect.tableName(this.isQualifier(), catalogName, schemaName, tableName);
            throw new NullPointerException("tableMapping '" + tab + "', property '" + propertyName + "' is not exist.");
        }
        if (!isSelect && isWhere) {
            String specialWhereCol = propertyInfo.getWhereColTemplate();
            if (StringUtils.isNotBlank((String)specialWhereCol)) {
                return () -> specialWhereCol;
            }
        } else if (isSelect && !isWhere && StringUtils.isNotBlank((String)(specialSelectCol = propertyInfo.getSelectTemplate()))) {
            return () -> specialSelectCol;
        }
        String columnName = propertyInfo.getColumn();
        return () -> this.dialect().fmtName(this.isQualifier(), columnName);
    }

    protected Map<String, String> extractKeysMap(Map entity) {
        Object propertySet = this.getTableMapping().isCaseInsensitive() ? new LinkedCaseInsensitiveMap() : new HashMap();
        for (Object key : entity.keySet()) {
            String keyStr = key.toString();
            propertySet.put(keyStr, keyStr);
        }
        return propertySet;
    }

    public final BoundSql getBoundSql() {
        return this.getBoundSql(this.dialect());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BoundSql getBoundSql(SqlDialect dialect) {
        if (dialect == null) {
            throw new IllegalStateException("dialect is null.");
        }
        if (dialect == this.dialect) {
            return this.buildBoundSql(dialect);
        }
        SqlDialect oriDialect = this.dialect();
        try {
            this.dialect = dialect;
            BoundSql boundSql = this.buildBoundSql(dialect);
            return boundSql;
        }
        finally {
            this.dialect = oriDialect;
        }
    }

    protected abstract BoundSql buildBoundSql(SqlDialect var1);

    protected abstract R getSelf();

    protected List<ColumnMapping> getPrimaryKey() {
        return this.primaryKey;
    }

    private List<ColumnMapping> getPrimaryKeyColumns(TableMapping<?> tableMapping) {
        ArrayList<ColumnMapping> properties = new ArrayList<ColumnMapping>();
        HashSet<String> pkc = new HashSet<String>();
        for (ColumnMapping mapping : tableMapping.getProperties()) {
            String columnName = mapping.getColumn();
            if (!mapping.isPrimaryKey()) continue;
            if (pkc.contains(columnName)) {
                throw new IllegalStateException("Multiple property mapping to '" + columnName + "' column");
            }
            pkc.add(columnName);
            properties.add(mapping);
        }
        return properties;
    }

    protected String objectMsg(Object object) {
        if (object == null) {
            return "null";
        }
        Map propertyFunc = BeanUtils.getPropertyFunc(this.exampleType());
        List primaryKeys = this.getPrimaryKey().stream().map(ColumnMapping::getColumn).collect(Collectors.toList());
        StringBuilder strBuffer = new StringBuilder();
        for (String pk : primaryKeys) {
            Property property = (Property)propertyFunc.get(pk);
            if (property == null) continue;
            if (strBuffer.length() > 0) {
                strBuffer.append(", ");
            }
            strBuffer.append(pk).append("=").append(StringUtils.toString((Object)property.get(object)));
        }
        if (strBuffer.length() == 0) {
            strBuffer.append("hashCode=").append(Objects.hashCode(object));
        }
        return strBuffer.insert(0, "object[").append("]").toString();
    }

    protected static class PreparedStatementCreatorWrap
    implements PreparedStatementCreator,
    ParameterDisposer,
    SqlProvider {
        private final String sql;
        private final PreparedStatementCreator creator;

        public PreparedStatementCreatorWrap(String sql, PreparedStatementCreator creator) {
            this.sql = Objects.requireNonNull(sql, "SQL must not be null");
            this.creator = creator;
        }

        @Override
        public String getSql() {
            return this.sql;
        }

        @Override
        public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
            return this.creator.createPreparedStatement(con);
        }

        @Override
        public void cleanupParameters() {
            if (this.creator instanceof ParameterDisposer) {
                ((ParameterDisposer)((Object)this.creator)).cleanupParameters();
            }
        }
    }
}

