/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.lambda.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.hasor.cobble.ArrayUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.dialect.ConditionSqlDialect;
import net.hasor.dbvisitor.lambda.LambdaTemplate;
import net.hasor.dbvisitor.lambda.core.BasicLambda;
import net.hasor.dbvisitor.lambda.core.QueryCompare;
import net.hasor.dbvisitor.lambda.segment.MergeSqlSegment;
import net.hasor.dbvisitor.lambda.segment.Segment;
import net.hasor.dbvisitor.lambda.segment.SqlKeyword;
import net.hasor.dbvisitor.mapping.def.ColumnMapping;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.types.MappedArg;
import net.hasor.dbvisitor.types.TypeHandler;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;

public abstract class BasicQueryCompare<R, T, P>
extends BasicLambda<R, T, P>
implements QueryCompare<R, T, P> {
    protected MergeSqlSegment queryTemplate = new MergeSqlSegment(new Segment[0]);
    protected List<Object> queryParam = new ArrayList<Object>();
    private Segment nextSegmentPrefix = null;
    private boolean lockCondition = false;

    public BasicQueryCompare(Class<?> exampleType, TableMapping<?> tableMapping, LambdaTemplate jdbcTemplate) {
        super(exampleType, tableMapping, jdbcTemplate);
    }

    @Override
    public R ifTrue(boolean test, Consumer<QueryCompare<R, T, P>> lambda) {
        if (test) {
            lambda.accept(this);
            return this.getSelf();
        }
        return this.getSelf();
    }

    @Override
    public R nested(Consumer<R> lambda) {
        this.addCondition(SqlKeyword.LEFT);
        this.nextSegmentPrefix = SqlKeyword.EMPTY;
        lambda.accept(this.getSelf());
        this.nextSegmentPrefix = SqlKeyword.EMPTY;
        this.addCondition(SqlKeyword.RIGHT);
        return this.getSelf();
    }

    @Override
    public R nested(boolean test, Consumer<R> lambda) {
        return test ? this.nested(lambda) : this.getSelf();
    }

    @Override
    public R or() {
        this.nextSegmentPrefix = SqlKeyword.OR;
        return this.getSelf();
    }

    @Override
    public R or(boolean test, Consumer<R> lambda) {
        return test ? this.or(lambda) : this.getSelf();
    }

    @Override
    public R and() {
        this.nextSegmentPrefix = SqlKeyword.AND;
        return this.getSelf();
    }

    @Override
    public R and(boolean test, Consumer<R> lambda) {
        return test ? this.and(lambda) : this.getSelf();
    }

    @Override
    public R apply(String sqlString, Object ... args) {
        if (StringUtils.isBlank((String)sqlString)) {
            return this.getSelf();
        }
        this.queryTemplate.addSegment(() -> {
            if (args != null && args.length > 0) {
                for (Object arg : args) {
                    this.format("?", arg);
                }
            }
            return sqlString;
        });
        return this.getSelf();
    }

    protected void lockCondition() {
        this.lockCondition = true;
    }

    protected final R addCondition(Segment ... segments) {
        if (this.lockCondition) {
            throw new IllegalStateException("must before (group by/order by) invoke it.");
        }
        if (this.nextSegmentPrefix == SqlKeyword.EMPTY) {
            this.nextSegmentPrefix = null;
        } else if (this.nextSegmentPrefix == null) {
            this.queryTemplate.addSegment(SqlKeyword.AND);
            this.nextSegmentPrefix = null;
        } else {
            this.queryTemplate.addSegment(this.nextSegmentPrefix);
            this.nextSegmentPrefix = null;
        }
        for (Segment segment : segments) {
            this.queryTemplate.addSegment(segment);
        }
        return this.getSelf();
    }

    protected Segment formatLikeValue(String property, ConditionSqlDialect.SqlLike like, Object param) {
        ColumnMapping mapping = this.getTableMapping().getPropertyByName(property);
        String specialValue = mapping.getWhereValueTemplate();
        String colValue = StringUtils.isNotBlank((String)specialValue) ? specialValue : "?";
        return () -> {
            this.format(colValue, param);
            return ((ConditionSqlDialect)this.dialect()).like(like, param);
        };
    }

    protected Segment formatValue(String property, Object ... params) {
        if (ArrayUtils.isEmpty((Object[])params)) {
            return () -> "";
        }
        ColumnMapping mapping = this.getTableMapping().getPropertyByName(property);
        String specialValue = mapping.getWhereValueTemplate();
        String colValue = StringUtils.isNotBlank((String)specialValue) ? specialValue : "?";
        MergeSqlSegment mergeSqlSegment = new MergeSqlSegment(new Segment[0]);
        Iterator<Object> iterator = Arrays.asList(params).iterator();
        while (iterator.hasNext()) {
            MappedArg arg = new MappedArg(iterator.next(), mapping.getJdbcType(), this.exampleIsMap() ? null : mapping.getTypeHandler());
            mergeSqlSegment.addSegment(this.formatSegment(colValue, arg));
            if (!iterator.hasNext()) continue;
            mergeSqlSegment.addSegment(() -> ",");
        }
        return mergeSqlSegment;
    }

    protected Segment formatValue(Object ... params) {
        if (ArrayUtils.isEmpty((Object[])params)) {
            return () -> "";
        }
        String colValue = "?";
        MergeSqlSegment mergeSqlSegment = new MergeSqlSegment(new Segment[0]);
        Iterator<Object> iterator = Arrays.asList(params).iterator();
        while (iterator.hasNext()) {
            Object nextArg = iterator.next();
            int sqlType = 1111;
            TypeHandler<Object> typeHandler = TypeHandlerRegistry.DEFAULT.getDefaultTypeHandler();
            if (nextArg != null) {
                sqlType = TypeHandlerRegistry.toSqlType(nextArg.getClass());
                typeHandler = TypeHandlerRegistry.DEFAULT.getTypeHandler(nextArg.getClass());
            }
            MappedArg arg = new MappedArg(nextArg, sqlType, this.exampleIsMap() ? null : typeHandler);
            mergeSqlSegment.addSegment(this.formatSegment(colValue, arg));
            if (!iterator.hasNext()) continue;
            mergeSqlSegment.addSegment(() -> ",");
        }
        return mergeSqlSegment;
    }

    protected Segment formatSegment(String argTemp, Object param) {
        return () -> this.format(argTemp, param);
    }

    private String format(String argTemp, Object param) {
        this.queryParam.add(param);
        return argTemp;
    }

    @Override
    public R eq(boolean test, P property, Object value) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.EQ, this.formatValue(propertyName, value));
        }
        return this.getSelf();
    }

    @Override
    public R ne(boolean test, P property, Object value) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.NE, this.formatValue(propertyName, value));
        }
        return this.getSelf();
    }

    @Override
    public R gt(boolean test, P property, Object value) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.GT, this.formatValue(propertyName, value));
        }
        return this.getSelf();
    }

    @Override
    public R ge(boolean test, P property, Object value) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.GE, this.formatValue(propertyName, value));
        }
        return this.getSelf();
    }

    @Override
    public R lt(boolean test, P property, Object value) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.LT, this.formatValue(propertyName, value));
        }
        return this.getSelf();
    }

    @Override
    public R le(boolean test, P property, Object value) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.LE, this.formatValue(propertyName, value));
        }
        return this.getSelf();
    }

    @Override
    public R like(boolean test, P property, Object value) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.LIKE, this.formatLikeValue(propertyName, ConditionSqlDialect.SqlLike.DEFAULT, value));
        }
        return this.getSelf();
    }

    @Override
    public R notLike(boolean test, P property, Object value) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.NOT, SqlKeyword.LIKE, this.formatLikeValue(propertyName, ConditionSqlDialect.SqlLike.DEFAULT, value));
        }
        return this.getSelf();
    }

    @Override
    public R likeRight(boolean test, P property, Object value) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.LIKE, this.formatLikeValue(propertyName, ConditionSqlDialect.SqlLike.RIGHT, value));
        }
        return this.getSelf();
    }

    @Override
    public R notLikeRight(boolean test, P property, Object value) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.NOT, SqlKeyword.LIKE, this.formatLikeValue(propertyName, ConditionSqlDialect.SqlLike.RIGHT, value));
        }
        return this.getSelf();
    }

    @Override
    public R likeLeft(boolean test, P property, Object value) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.LIKE, this.formatLikeValue(propertyName, ConditionSqlDialect.SqlLike.LEFT, value));
        }
        return this.getSelf();
    }

    @Override
    public R notLikeLeft(boolean test, P property, Object value) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.NOT, SqlKeyword.LIKE, this.formatLikeValue(propertyName, ConditionSqlDialect.SqlLike.LEFT, value));
        }
        return this.getSelf();
    }

    @Override
    public R isNull(boolean test, P property) {
        if (test) {
            return this.addCondition(this.buildConditionByProperty(this.getPropertyName(property)), SqlKeyword.IS_NULL);
        }
        return this.getSelf();
    }

    @Override
    public R isNotNull(boolean test, P property) {
        if (test) {
            return this.addCondition(this.buildConditionByProperty(this.getPropertyName(property)), SqlKeyword.IS_NOT_NULL);
        }
        return this.getSelf();
    }

    @Override
    public R in(boolean test, P property, Collection<?> value) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.IN, SqlKeyword.LEFT, this.formatValue(propertyName, value.toArray()), SqlKeyword.RIGHT);
        }
        return this.getSelf();
    }

    @Override
    public R notIn(boolean test, P property, Collection<?> value) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.NOT, SqlKeyword.IN, SqlKeyword.LEFT, this.formatValue(propertyName, value.toArray()), SqlKeyword.RIGHT);
        }
        return this.getSelf();
    }

    @Override
    public R between(boolean test, P property, Object value1, Object value2) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.BETWEEN, this.formatValue(propertyName, value1), SqlKeyword.AND, this.formatValue(propertyName, value2));
        }
        return this.getSelf();
    }

    @Override
    public R notBetween(boolean test, P property, Object value1, Object value2) {
        if (test) {
            String propertyName = this.getPropertyName(property);
            return this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.NOT, SqlKeyword.BETWEEN, this.formatValue(propertyName, value1), SqlKeyword.AND, this.formatValue(propertyName, value2));
        }
        return this.getSelf();
    }

    @Override
    public R eqBySample(T sample) {
        if (sample == null) {
            throw new NullPointerException("sample is null.");
        }
        if (this.exampleIsMap()) {
            return this.eqBySampleMap((Map)sample);
        }
        boolean hasCondition = false;
        TableMapping<?> tableMapping = this.getTableMapping();
        for (ColumnMapping property : tableMapping.getProperties()) {
            Object value = property.getHandler().get(sample);
            if (value == null) continue;
            if (!hasCondition) {
                this.addCondition(SqlKeyword.LEFT);
                this.nextSegmentPrefix = SqlKeyword.EMPTY;
                hasCondition = true;
            }
            String propertyName = property.getProperty();
            this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.EQ, this.formatValue(propertyName, value));
        }
        if (hasCondition) {
            this.nextSegmentPrefix = SqlKeyword.EMPTY;
            this.addCondition(SqlKeyword.RIGHT);
        }
        return this.getSelf();
    }

    @Override
    public R eqBySampleMap(Map<String, Object> sample) {
        if (sample == null) {
            throw new NullPointerException("sample is null.");
        }
        Map<String, String> entityKeyMap = this.extractKeysMap(sample);
        boolean hasCondition = false;
        TableMapping<?> tableMapping = this.getTableMapping();
        if (!tableMapping.getProperties().isEmpty()) {
            for (ColumnMapping property : tableMapping.getProperties()) {
                String propertyName = property.getProperty();
                Object value = sample.get(entityKeyMap.get(propertyName));
                if (value == null) continue;
                if (!hasCondition) {
                    this.addCondition(SqlKeyword.LEFT);
                    this.nextSegmentPrefix = SqlKeyword.EMPTY;
                    hasCondition = true;
                }
                this.addCondition(this.buildConditionByProperty(propertyName), SqlKeyword.EQ, this.formatValue(propertyName, value));
            }
        } else {
            for (String column : sample.keySet()) {
                Object value = sample.get(column);
                if (value == null) continue;
                if (!hasCondition) {
                    this.addCondition(SqlKeyword.LEFT);
                    this.nextSegmentPrefix = SqlKeyword.EMPTY;
                    hasCondition = true;
                }
                this.addCondition(this.buildConditionByColumn(column), SqlKeyword.EQ, this.formatValue(value));
            }
        }
        if (hasCondition) {
            this.nextSegmentPrefix = SqlKeyword.EMPTY;
            this.addCondition(SqlKeyword.RIGHT);
        }
        return this.getSelf();
    }
}

