/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.lambda.core;

import java.sql.SQLException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.cobble.function.ESupplier;
import net.hasor.dbvisitor.page.PageObject;

class PageObjectForLambda
extends PageObject {
    private final ESupplier<Long, SQLException> totalCountSupplier;
    private final AtomicBoolean totalCountInited = new AtomicBoolean(false);

    public PageObjectForLambda(long pageSize, ESupplier<Long, SQLException> totalCountSupplier) {
        super(pageSize, 0L);
        Objects.requireNonNull(totalCountSupplier, "totalCountSupplier is null.");
        this.totalCountSupplier = totalCountSupplier;
    }

    @Override
    public void refreshTotalCount() {
        super.refreshTotalCount();
        this.getTotalCount();
    }

    @Override
    public long getTotalCount() {
        if (this.isRefreshTotalCount() || this.totalCountInited.compareAndSet(false, true)) {
            try {
                super.setTotalCount((Long)this.totalCountSupplier.eGet());
            }
            catch (SQLException e) {
                throw ExceptionUtils.toRuntime((Throwable)e);
            }
        }
        return super.getTotalCount();
    }

    @Override
    public void setTotalCount(long totalCount) {
        super.setTotalCount(totalCount);
        this.totalCountInited.set(true);
    }
}

