/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.lambda.support.entity;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.cobble.reflect.SFunction;
import net.hasor.dbvisitor.dialect.BatchBoundSql;
import net.hasor.dbvisitor.dialect.SqlDialect;
import net.hasor.dbvisitor.jdbc.PreparedStatementCreator;
import net.hasor.dbvisitor.jdbc.core.ParameterDisposer;
import net.hasor.dbvisitor.keyholder.KeySeqHolder;
import net.hasor.dbvisitor.lambda.InsertOperation;
import net.hasor.dbvisitor.lambda.LambdaTemplate;
import net.hasor.dbvisitor.lambda.core.AbstractInsertLambda;
import net.hasor.dbvisitor.lambda.core.BasicLambda;
import net.hasor.dbvisitor.mapping.def.ColumnMapping;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.types.MappedArg;
import net.hasor.dbvisitor.types.TypeHandler;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;

public class InsertLambdaForEntity<T>
extends AbstractInsertLambda<InsertOperation<T>, T, SFunction<T>>
implements InsertOperation<T> {
    public InsertLambdaForEntity(Class<T> exampleType, TableMapping<T> tableMapping, LambdaTemplate jdbcTemplate) {
        super(exampleType, tableMapping, jdbcTemplate);
    }

    @Override
    protected InsertOperation<T> getSelf() {
        return this;
    }

    @Override
    protected String getPropertyName(SFunction<T> property) {
        return BeanUtils.toProperty(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeGetResult() throws SQLException {
        try {
            List<String> useColumns = this.findInsertColumns();
            String insertSql = super.buildInsert(this.dialect(), this.primaryKeys, useColumns, this.insertColumnTerms);
            if (logger.isDebugEnabled()) {
                logger.trace("Executing SQL statement [" + insertSql + "].");
            }
            TypeHandlerRegistry typeRegistry = this.getJdbcTemplate().getTypeRegistry();
            if (this.insertValues.size() > 1) {
                if (this.dialect().supportBatch()) {
                    int[] nArray = this.getJdbcTemplate().executeCreator((PreparedStatementCreator)new BasicLambda.PreparedStatementCreatorWrap(insertSql, con -> {
                        boolean supportGetGeneratedKeys = con != null && con.getMetaData().supportsGetGeneratedKeys();
                        MappedArg[][] batchBoundSql = this.buildInsertArgs(useColumns, supportGetGeneratedKeys, con);
                        PreparedStatement ps = this.createPrepareStatement(con, insertSql);
                        for (Object[] objectArray : batchBoundSql) {
                            this.applyPreparedStatement(ps, objectArray, typeRegistry);
                            ps.addBatch();
                        }
                        return ps;
                    }), ps -> {
                        int[] res = ps.executeBatch();
                        this.processKeySeqHolderAfter(ps);
                        return res;
                    });
                    return nArray;
                }
                int[] nArray = this.getJdbcTemplate().execute(con -> {
                    boolean supportGetGeneratedKeys = con != null && con.getMetaData().supportsGetGeneratedKeys();
                    MappedArg[][] batchBoundSql = this.buildInsertArgs(useColumns, supportGetGeneratedKeys, con);
                    int[] res = new int[batchBoundSql.length];
                    for (int i = 0; i < batchBoundSql.length; ++i) {
                        try (PreparedStatement ps = this.createPrepareStatement(con, insertSql);){
                            this.applyPreparedStatement(ps, batchBoundSql[i], typeRegistry);
                            res[i] = ps.executeUpdate();
                            this.processKeySeqHolderAfter(ps);
                            continue;
                        }
                    }
                    return res;
                });
                return nArray;
            }
            int[] nArray = this.getJdbcTemplate().executeCreator((PreparedStatementCreator)new BasicLambda.PreparedStatementCreatorWrap(insertSql, con -> {
                boolean supportsGetGeneratedKeys = con != null && con.getMetaData().supportsGetGeneratedKeys();
                MappedArg[][] batchBoundSql = this.buildInsertArgs(useColumns, supportsGetGeneratedKeys, con);
                PreparedStatement ps = this.createPrepareStatement(con, insertSql);
                this.applyPreparedStatement(ps, batchBoundSql[0], typeRegistry);
                return ps;
            }), ps -> {
                int res = ps.executeUpdate();
                this.processKeySeqHolderAfter(ps);
                return new int[]{res};
            });
            return nArray;
        }
        finally {
            for (ParameterDisposer obj : this.parameterDisposers) {
                obj.cleanupParameters();
            }
            this.insertValues.clear();
            this.parameterDisposers.clear();
            this.fillBackEntityList.clear();
        }
    }

    @Override
    protected BatchBoundSql buildBoundSql(SqlDialect dialect) {
        try {
            List<String> useColumns = this.findInsertColumns();
            String insertSql = super.buildInsert(this.dialect(), this.primaryKeys, useColumns, this.insertColumnTerms);
            Object[][] batchBoundSql = this.buildInsertArgs(useColumns, false, null);
            return new BatchBoundSql.BatchBoundSqlObj(insertSql, batchBoundSql);
        }
        catch (SQLException e) {
            throw ExceptionUtils.toRuntime((Throwable)e);
        }
    }

    private List<String> findInsertColumns() {
        if (this.insertValues.size() != 1) {
            return this.insertColumns;
        }
        AbstractInsertLambda.InsertEntity entity = (AbstractInsertLambda.InsertEntity)this.insertValues.get(0);
        if (entity.isMap) {
            Map<String, String> entityKeyMap = this.extractKeysMap((Map)entity.object);
            return this.insertProperties.stream().filter(c -> {
                KeySeqHolder holder = c.getKeySeqHolder();
                return entityKeyMap.containsKey(c.getProperty()) || holder != null && holder.onBefore();
            }).map(ColumnMapping::getColumn).collect(Collectors.toList());
        }
        return this.insertProperties.stream().filter(c -> {
            KeySeqHolder holder = c.getKeySeqHolder();
            return c.getHandler().get(entity.object) != null || holder != null && holder.onBefore();
        }).map(ColumnMapping::getColumn).collect(Collectors.toList());
    }

    protected MappedArg[][] buildInsertArgs(List<String> useColumns, boolean forExecute, Connection executeConn) throws SQLException {
        boolean hasFillBack = !this.fillAfterProperties.isEmpty();
        TableMapping<?> tableMapping = this.getTableMapping();
        ArrayList<ColumnMapping> mappings = new ArrayList<ColumnMapping>();
        for (String column : useColumns) {
            mappings.add(tableMapping.getPropertyByColumn(column));
        }
        MappedArg[][] batchArgs = new MappedArg[this.insertValues.size()][];
        for (int i = 0; i < this.insertValues.size(); ++i) {
            AbstractInsertLambda.InsertEntity entity = (AbstractInsertLambda.InsertEntity)this.insertValues.get(i);
            if (hasFillBack && forExecute) {
                this.fillBackEntityList.add(entity);
            }
            MappedArg[] args = new MappedArg[mappings.size()];
            for (int j = 0; j < mappings.size(); ++j) {
                Integer jdbcType;
                Object arg;
                ColumnMapping mapping = (ColumnMapping)mappings.get(j);
                TypeHandler<?> typeHandler = entity.isMap ? null : mapping.getTypeHandler();
                this.processKeySeqHolderBefore(executeConn, mapping, entity);
                if (entity.isMap) {
                    Map<String, String> entityKeyMap = this.extractKeysMap((Map)entity.object);
                    if (mapping != null) {
                        arg = ((Map)entity.object).get(entityKeyMap.get(mapping.getProperty()));
                        jdbcType = mapping.getJdbcType();
                    } else {
                        arg = ((Map)entity.object).get(entityKeyMap.get(this.insertColumns.get(j)));
                        jdbcType = arg == null ? null : Integer.valueOf(TypeHandlerRegistry.toSqlType(arg.getClass()));
                    }
                } else {
                    arg = mapping.getHandler().get(entity.object);
                    jdbcType = mapping.getJdbcType();
                }
                if (forExecute && arg instanceof ParameterDisposer) {
                    this.parameterDisposers.add((ParameterDisposer)arg);
                }
                args[j] = arg == null ? null : new MappedArg(arg, jdbcType, typeHandler);
            }
            batchArgs[i] = args;
        }
        return batchArgs;
    }

    protected void processKeySeqHolderBefore(Connection conn, ColumnMapping mapping, AbstractInsertLambda.InsertEntity entity) throws SQLException {
        boolean beforeProcessed;
        if (!this.hasKeySeqHolderColumn || mapping.getKeySeqHolder() == null || conn == null) {
            return;
        }
        if (entity.isMap) {
            beforeProcessed = ((Map)entity.object).containsKey(mapping.getProperty());
        } else {
            boolean bl = beforeProcessed = mapping.getHandler().get(entity.object) != null;
        }
        if (beforeProcessed) {
            return;
        }
        Object value = mapping.getKeySeqHolder().beforeApply(conn, entity.object, mapping);
        if (value != null) {
            if (entity.isMap) {
                ((Map)entity.object).put(mapping.getProperty(), value);
            } else {
                mapping.getHandler().set((Object)entity, value);
            }
        }
    }

    protected void processKeySeqHolderAfter(PreparedStatement fillBack) throws SQLException {
        if (!this.hasKeySeqHolderColumn) {
            return;
        }
        ResultSet rs = fillBack.getGeneratedKeys();
        for (AbstractInsertLambda.InsertEntity entity : this.fillBackEntityList) {
            if (!rs.next()) break;
            for (int i = 0; i < this.fillAfterProperties.size(); ++i) {
                ColumnMapping mapping = (ColumnMapping)this.fillAfterProperties.get(i);
                if (mapping.getKeySeqHolder() == null) continue;
                Object value = mapping.getKeySeqHolder().afterApply(rs, entity.object, i, mapping);
                if (!entity.isMap || value == null) continue;
                ((Map)entity.object).put(mapping.getProperty(), value);
            }
        }
    }
}

