/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.lambda.support.map;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.ref.LinkedCaseInsensitiveMap;
import net.hasor.dbvisitor.dialect.BatchBoundSql;
import net.hasor.dbvisitor.dialect.BoundSql;
import net.hasor.dbvisitor.dialect.SqlDialect;
import net.hasor.dbvisitor.lambda.InsertOperation;
import net.hasor.dbvisitor.lambda.LambdaTemplate;
import net.hasor.dbvisitor.lambda.core.AbstractInsertLambda;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.types.MappedArg;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;

public class InsertLambdaForMap
extends AbstractInsertLambda<InsertOperation<Map<String, Object>>, Map<String, Object>, String>
implements InsertOperation<Map<String, Object>> {
    private final boolean toCamelCase = this.getTableMapping().isToCamelCase();

    public InsertLambdaForMap(TableMapping<?> tableMapping, LambdaTemplate jdbcTemplate) {
        super(Map.class, tableMapping, jdbcTemplate);
    }

    @Override
    protected InsertLambdaForMap getSelf() {
        return this;
    }

    @Override
    protected String getPropertyName(String property) {
        return property;
    }

    @Override
    protected BoundSql buildBoundSql(SqlDialect dialect) {
        if (this.insertValues.size() != 1) {
            throw new IllegalStateException("require single record.");
        }
        AbstractInsertLambda.InsertEntity entity = (AbstractInsertLambda.InsertEntity)this.insertValues.get(0);
        BoundSql.BoundSqlObj boundSqlObj = this.buildBoundSql(this.dialect(), entity);
        return new BatchBoundSql.BatchBoundSqlObj(boundSqlObj.getSqlString(), new MappedArg[][]{(MappedArg[])boundSqlObj.getArgs()});
    }

    @Override
    public int[] executeGetResult() throws SQLException {
        return this.getJdbcTemplate().execute(con -> {
            TypeHandlerRegistry typeRegistry = this.getJdbcTemplate().getTypeRegistry();
            int[] result = new int[this.insertValues.size()];
            for (int i = 0; i < this.insertValues.size(); ++i) {
                AbstractInsertLambda.InsertEntity ent = (AbstractInsertLambda.InsertEntity)this.insertValues.get(i);
                result[i] = this.executeOne(con, ent, typeRegistry);
            }
            return result;
        });
    }

    private int executeOne(Connection con, AbstractInsertLambda.InsertEntity ent, TypeHandlerRegistry typeRegistry) throws SQLException {
        BoundSql.BoundSqlObj boundSqlObj = this.buildBoundSql(this.dialect(), ent);
        String sqlString = boundSqlObj.getSqlString();
        try (PreparedStatement ps = this.createPrepareStatement(con, sqlString);){
            this.applyPreparedStatement(ps, boundSqlObj.getArgs(), typeRegistry);
            int n = ps.executeUpdate();
            return n;
        }
    }

    protected BoundSql.BoundSqlObj buildBoundSql(SqlDialect dialect, AbstractInsertLambda.InsertEntity entity) {
        Map<String, String> entityKeyMap = this.extractKeysMap((Map)entity.object);
        ArrayList insertProperties = new ArrayList();
        ArrayList<String> insertColumns = new ArrayList<String>();
        entityKeyMap.forEach((p, c) -> {
            insertProperties.add(p);
            insertColumns.add((String)c);
        });
        String insertSql = this.buildInsert(dialect, this.primaryKeys, insertColumns, this.insertColumnTerms);
        Object[] args = new MappedArg[entityKeyMap.size()];
        for (int i = 0; i < insertProperties.size(); ++i) {
            Object arg = ((Map)entity.object).get(insertProperties.get(i));
            Integer jdbcType = arg == null ? null : Integer.valueOf(TypeHandlerRegistry.toSqlType(arg.getClass()));
            args[i] = arg == null ? null : new MappedArg(arg, jdbcType, null);
        }
        return new BoundSql.BoundSqlObj(insertSql, args);
    }

    @Override
    protected Map<String, String> extractKeysMap(Map entity) {
        Object propertySet = this.getTableMapping().isCaseInsensitive() ? new LinkedCaseInsensitiveMap() : new HashMap();
        for (Object key : entity.keySet()) {
            String keyStr = key.toString();
            if (this.toCamelCase) {
                propertySet.put(keyStr, StringUtils.humpToLine((String)keyStr));
                continue;
            }
            propertySet.put(keyStr, keyStr);
        }
        return propertySet;
    }
}

