/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.mapping;

import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.keyholder.CreateContext;
import net.hasor.dbvisitor.keyholder.KeySeqHolder;
import net.hasor.dbvisitor.keyholder.KeySeqHolderFactory;
import net.hasor.dbvisitor.keyholder.sequence.AutoKeySeqHolderFactory;
import net.hasor.dbvisitor.keyholder.sequence.HolderKeySeqHolderFactory;
import net.hasor.dbvisitor.keyholder.sequence.SeqKeySeqHolderFactory;
import net.hasor.dbvisitor.keyholder.sequence.Uuid32KeySeqHolderFactory;
import net.hasor.dbvisitor.keyholder.sequence.Uuid36KeySeqHolderFactory;

public enum KeyTypeEnum {
    None(null),
    Auto(new AutoKeySeqHolderFactory()),
    UUID32(new Uuid32KeySeqHolderFactory()),
    UUID36(new Uuid36KeySeqHolderFactory()),
    Sequence(new SeqKeySeqHolderFactory()),
    Holder(new HolderKeySeqHolderFactory());

    private final KeySeqHolderFactory factory;

    private KeyTypeEnum(KeySeqHolderFactory factory) {
        this.factory = factory;
    }

    public KeySeqHolder createHolder(CreateContext context) {
        if (this.factory == null) {
            return null;
        }
        return this.factory.createHolder(context);
    }

    public static KeyTypeEnum valueOfCode(String code) {
        for (KeyTypeEnum keyType : KeyTypeEnum.values()) {
            if (!StringUtils.equalsIgnoreCase((String)keyType.name(), (String)code)) continue;
            return keyType;
        }
        return null;
    }
}

