/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.mapping;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.hasor.cobble.StringUtils;
import net.hasor.dbvisitor.mapping.def.TableDef;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.mapping.resolve.ClassTableMappingResolve;
import net.hasor.dbvisitor.mapping.resolve.MappingOptions;
import net.hasor.dbvisitor.mapping.resolve.XmlTableMappingResolve;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MappingRegistry {
    private final Map<String, Map<String, TableMapping<?>>> tableMappingMap = new ConcurrentHashMap();
    protected final ClassLoader classLoader;
    protected final TypeHandlerRegistry typeRegistry;
    protected final MappingOptions global;
    private final XmlTableMappingResolve xmlMappingResolve;
    private final ClassTableMappingResolve classMappingResolve;
    private static final DocumentBuilderFactory FACTORY = DocumentBuilderFactory.newInstance();

    public MappingRegistry() {
        this(null, null, null);
    }

    public MappingRegistry(ClassLoader classLoader, TypeHandlerRegistry typeRegistry, MappingOptions global) {
        this.classLoader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        this.typeRegistry = typeRegistry == null ? TypeHandlerRegistry.DEFAULT : typeRegistry;
        this.global = global;
        this.xmlMappingResolve = new XmlTableMappingResolve(global);
        this.classMappingResolve = new ClassTableMappingResolve(global);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public TypeHandlerRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public MappingOptions getGlobalOptions() {
        return this.global;
    }

    public void loadMapper(URL resource) throws IOException, ReflectiveOperationException {
        try (InputStream stream = resource.openStream();){
            Objects.requireNonNull(stream, "resource '" + resource + "' is not exist.");
            this.loadMapper(stream);
        }
    }

    public void loadMapper(String resource) throws IOException, ReflectiveOperationException {
        if (resource.startsWith("/")) {
            resource = resource.substring(1);
        }
        try (InputStream stream = this.classLoader.getResourceAsStream(resource);){
            Objects.requireNonNull(stream, "resource '" + resource + "' is not exist.");
            this.loadMapper(stream);
        }
    }

    public void loadMapper(InputStream stream) throws IOException, ReflectiveOperationException {
        Objects.requireNonNull(stream, "load InputStream is null.");
        try {
            Document document = this.loadXmlRoot(stream);
            Element root = document.getDocumentElement();
            NamedNodeMap rootAttributes = root.getAttributes();
            String namespace = this.readAttribute("namespace", rootAttributes);
            this.loadReader(namespace, root);
        }
        catch (ReflectiveOperationException | ParserConfigurationException | SAXException e) {
            throw new IOException(e);
        }
    }

    protected void loadReader(String space, Element configRoot) throws IOException, ReflectiveOperationException {
        NamedNodeMap rootAttributes = configRoot.getAttributes();
        String caseInsensitive = this.readAttribute("caseInsensitive", rootAttributes);
        String mapUnderscoreToCamelCase = this.readAttribute("mapUnderscoreToCamelCase", rootAttributes);
        String autoMapping = this.readAttribute("autoMapping", rootAttributes);
        String useDelimited = this.readAttribute("useDelimited", rootAttributes);
        MappingOptions fileScope = MappingOptions.buildNew(this.global);
        fileScope.setCaseInsensitive(StringUtils.isBlank((String)caseInsensitive) ? null : Boolean.valueOf(Boolean.parseBoolean(caseInsensitive)));
        fileScope.setMapUnderscoreToCamelCase(StringUtils.isBlank((String)mapUnderscoreToCamelCase) ? null : Boolean.valueOf(Boolean.parseBoolean(mapUnderscoreToCamelCase)));
        fileScope.setAutoMapping(StringUtils.isBlank((String)autoMapping) ? null : Boolean.valueOf(Boolean.parseBoolean(autoMapping)));
        fileScope.setUseDelimited(StringUtils.isBlank((String)useDelimited) ? null : Boolean.valueOf(Boolean.parseBoolean(useDelimited)));
        NodeList childNodes = configRoot.getChildNodes();
        int len = childNodes.getLength();
        for (int i = 0; i < len; ++i) {
            String typeString;
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            String elementName = node.getNodeName();
            boolean isResultMap = StringUtils.equalsIgnoreCase((String)"resultMap", (String)elementName);
            boolean isEntity = StringUtils.equalsIgnoreCase((String)"entity", (String)elementName);
            if (!isResultMap && !isEntity) continue;
            NamedNodeMap nodeAttributes = node.getAttributes();
            Node idNode = nodeAttributes.getNamedItem("id");
            Node typeNode = nodeAttributes.getNamedItem("type");
            String identify = idNode != null ? idNode.getNodeValue() : null;
            String string = typeString = typeNode != null ? typeNode.getNodeValue() : null;
            if (StringUtils.isBlank((String)identify)) {
                identify = typeString;
            }
            if (StringUtils.isBlank((String)typeString)) {
                throw new IOException("the <" + (isResultMap ? "resultMap" : "entity") + "> tag, type is null.");
            }
            TableDef<?> tableDef = this.xmlMappingResolve.resolveTableMapping(node, fileScope, this.getClassLoader(), this.getTypeRegistry());
            this.configNames(true, isEntity, tableDef);
            if (isEntity) {
                this.saveMapping(true, "", identify, tableDef);
                if (StringUtils.equals((String)identify, (String)typeString)) continue;
                this.saveMapping(true, "", typeString, tableDef);
                continue;
            }
            this.saveMapping(false, space, identify, tableDef);
        }
    }

    public void loadEntity(Class<?> entityType) {
        this.loadEntity(entityType.getName(), entityType);
    }

    public void loadEntity(String identify, Class<?> entityType) {
        Objects.requireNonNull(entityType, "entityType is null.");
        String typeString = entityType.getName();
        if (StringUtils.isBlank((String)identify)) {
            identify = typeString;
        }
        TableDef<?> tableDef = this.classMappingResolve.resolveTableMapping(entityType, (MappingOptions)null, this.getClassLoader(), this.getTypeRegistry());
        this.configNames(false, true, tableDef);
        this.saveMapping(true, "", identify, tableDef);
        if (!StringUtils.equals((String)identify, (String)typeString)) {
            this.saveMapping(true, "", typeString, tableDef);
        }
    }

    public void loadResultMap(String space, String identify, Class<?> resultType) {
        Objects.requireNonNull(resultType, "resultType is null.");
        String typeString = resultType.getName();
        if (StringUtils.isBlank((String)identify)) {
            identify = typeString;
        }
        TableDef<?> tableDef = this.classMappingResolve.resolveTableMapping(resultType, (MappingOptions)null, this.getClassLoader(), this.getTypeRegistry());
        this.configNames(false, false, tableDef);
        this.saveMapping(false, space, identify, tableDef);
    }

    private void configNames(boolean isXml, boolean isEntity, TableDef<?> tableDef) {
        if (!isEntity) {
            tableDef.setCatalog("");
            tableDef.setSchema("");
            tableDef.setTable("");
            return;
        }
        if (isXml) {
            return;
        }
        Class<?> entityType = tableDef.entityType();
        if (StringUtils.isBlank((String)tableDef.getTable())) {
            if (tableDef.isMapUnderscoreToCamelCase()) {
                tableDef.setTable(StringUtils.humpToLine((String)entityType.getSimpleName()));
            } else {
                tableDef.setTable(entityType.getSimpleName());
            }
        }
    }

    private void saveMapping(boolean isEntity, String space, String identify, TableMapping<?> tableMapping) {
        Map<String, TableMapping<?>> mappingMap;
        String string = space = StringUtils.isBlank((String)space) ? "" : space;
        if (!this.tableMappingMap.containsKey(space)) {
            this.tableMappingMap.put(space, new ConcurrentHashMap());
        }
        if ((mappingMap = this.tableMappingMap.get(space)).containsKey(identify)) {
            String msg = isEntity ? "repeat entity" : "repeat resultMap";
            throw new IllegalStateException(msg + " '" + identify + "' in " + (StringUtils.isBlank((String)space) ? "default namespace" : "'" + space + "' namespace."));
        }
        if (isEntity && StringUtils.isBlank((String)tableMapping.getTable())) {
            throw new IllegalStateException("entity '" + identify + "' table is not specified in " + (StringUtils.isBlank((String)space) ? "default namespace" : "'" + space + "' namespace."));
        }
        mappingMap.put(identify, tableMapping);
    }

    public <T> TableMapping<T> findEntity(Class<?> entityType) {
        return this.findMapping("", entityType.getName());
    }

    public <T> TableMapping<T> findEntity(String idOrType) {
        return this.findMapping("", idOrType);
    }

    public <T> TableMapping<T> findMapping(String space, String identify) {
        Map<String, TableMapping<?>> mappingMap;
        TableMapping<?> tableMapping = null;
        if (StringUtils.isNotBlank((String)space) && this.tableMappingMap.containsKey(space)) {
            mappingMap = this.tableMappingMap.get(space);
            tableMapping = mappingMap.get(identify);
        }
        if (tableMapping == null && this.tableMappingMap.containsKey("")) {
            mappingMap = this.tableMappingMap.get("");
            tableMapping = mappingMap.get(identify);
        }
        return tableMapping;
    }

    protected Document loadXmlRoot(InputStream stream) throws ParserConfigurationException, IOException, SAXException {
        if (stream == null) {
            throw new NullPointerException("stream is null.");
        }
        DocumentBuilder documentBuilder = FACTORY.newDocumentBuilder();
        documentBuilder.setEntityResolver((publicId, systemId) -> {
            boolean dbVisitorDTD;
            boolean mybatisDTD = StringUtils.equalsIgnoreCase((String)"-//mybatis.org//DTD Mapper 3.0//EN", (String)publicId) || StringUtils.containsIgnoreCase((String)systemId, (String)"mybatis-3-mapper.dtd");
            boolean bl = dbVisitorDTD = StringUtils.equalsIgnoreCase((String)"-//dbvisitor.net//DTD Mapper 1.0//EN", (String)publicId) || StringUtils.containsIgnoreCase((String)systemId, (String)"dbvisitor-mapper.dtd");
            if (dbVisitorDTD) {
                InputSource source = new InputSource(this.getClassLoader().getResourceAsStream("net/hasor/dbvisitor/dal/repository/parser/dbvisitor-mapper.dtd"));
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
            if (mybatisDTD) {
                InputSource source = new InputSource(this.getClassLoader().getResourceAsStream("net/hasor/dbvisitor/dal/repository/parser/mybatis-3-mapper.dtd"));
                source.setPublicId(publicId);
                source.setSystemId(systemId);
                return source;
            }
            return new DefaultHandler().resolveEntity(publicId, systemId);
        });
        return documentBuilder.parse(new InputSource(stream));
    }

    protected String readAttribute(String attrName, NamedNodeMap rootAttributes) {
        Node namespaceNode;
        if (rootAttributes != null && (namespaceNode = rootAttributes.getNamedItem(attrName)) != null) {
            return namespaceNode.getNodeValue();
        }
        return null;
    }
}

