/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.mapping.reader;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.hasor.cobble.ref.LinkedCaseInsensitiveMap;
import net.hasor.dbvisitor.mapping.TableReader;
import net.hasor.dbvisitor.mapping.def.ColumnMapping;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.types.TypeHandler;

public class MapTableReader
implements TableReader<Map<String, Object>> {
    private final boolean caseInsensitive;
    private final TableMapping<?> tableMapping;

    public MapTableReader(TableMapping<?> tableMapping) {
        this.tableMapping = tableMapping;
        this.caseInsensitive = tableMapping.isCaseInsensitive();
    }

    protected Map<String, Object> createColumnMap(int columnCount) {
        if (this.caseInsensitive) {
            return new LinkedCaseInsensitiveMap(columnCount);
        }
        return new LinkedHashMap<String, Object>();
    }

    @Override
    public Map<String, Object> extractRow(List<String> columns, ResultSet rs, int rowNum) throws SQLException {
        Map<String, Object> target = this.createColumnMap(columns.size());
        for (int i = 0; i < columns.size(); ++i) {
            String column = columns.get(i);
            ColumnMapping mapping = this.tableMapping.getPropertyByColumn(column);
            if (mapping == null || mapping.getHandler().isReadOnly()) continue;
            TypeHandler<?> realHandler = mapping.getTypeHandler();
            Object result = realHandler.getResult(rs, i + 1);
            target.put(mapping.getProperty(), result);
        }
        return target;
    }
}

