/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.mapping.resolve;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.hasor.cobble.ClassUtils;
import net.hasor.cobble.CollectionUtils;
import net.hasor.cobble.ExceptionUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.asm.AnnotationVisitor;
import net.hasor.cobble.asm.ClassReader;
import net.hasor.cobble.asm.ClassVisitor;
import net.hasor.cobble.dynamic.AsmTools;
import net.hasor.cobble.logging.Logger;
import net.hasor.dbvisitor.mapping.Table;
import net.hasor.dbvisitor.mapping.TableDefault;
import net.hasor.dbvisitor.mapping.resolve.MappingOptions;
import net.hasor.dbvisitor.mapping.resolve.TableDefaultInfo;
import net.hasor.dbvisitor.mapping.resolve.TableDefaultVisitor;
import net.hasor.dbvisitor.mapping.resolve.TableMappingResolve;
import net.hasor.dbvisitor.types.TypeHandler;

public abstract class AbstractTableMappingResolve<T>
implements TableMappingResolve<T> {
    private static final Logger logger = Logger.getLogger(AbstractTableMappingResolve.class);
    protected final MappingOptions global;
    protected static final Map<Class<?>, Class<?>> CLASS_MAPPING_MAP = new HashMap();

    public AbstractTableMappingResolve(MappingOptions global) {
        this.global = global == null ? MappingOptions.buildNew() : global;
    }

    protected static String hump2Line(String str, Boolean mapUnderscoreToCamelCase) {
        if (StringUtils.isBlank((String)str) || mapUnderscoreToCamelCase == null || !mapUnderscoreToCamelCase.booleanValue()) {
            return str;
        }
        return StringUtils.humpToLine((String)str);
    }

    protected static TableDefaultInfo fetchDefaultInfoByEntity(ClassLoader classLoader, Class<?> entityType, boolean autoGenName, MappingOptions options, Map<String, String> overwriteData) {
        TableDefaultInfo tableInfo;
        HashMap<String, String> confData = new HashMap<String, String>();
        AbstractTableMappingResolve.fetchConfigXmlInfo(confData, classLoader);
        AbstractTableMappingResolve.fetchPackageInfo(confData, TableDefault.class, classLoader, entityType.getName());
        boolean hasTable = AbstractTableMappingResolve.fetchEntityInfo(confData, Table.class, classLoader, entityType.getName());
        if (CollectionUtils.isNotEmpty(overwriteData)) {
            confData.putAll(overwriteData);
        }
        if (StringUtils.isBlank((String)(tableInfo = new TableDefaultInfo(confData, classLoader, options)).value()) && (hasTable || autoGenName) && !overwriteData.containsKey("table")) {
            tableInfo.setTable(AbstractTableMappingResolve.hump2Line(entityType.getSimpleName(), tableInfo.mapUnderscoreToCamelCase()));
        }
        return tableInfo;
    }

    private static void fetchConfigXmlInfo(Map<String, String> confData, ClassLoader classLoader) {
    }

    private static void fetchPackageInfo(Map<String, String> confData, Class<?> matchType, ClassLoader classLoader, String className) {
        if (StringUtils.isBlank((String)className)) {
            return;
        }
        String packageName = StringUtils.substringBeforeLast((String)className, (String)".");
        do {
            AbstractTableMappingResolve.fetchEntityInfo(confData, matchType, classLoader, packageName + ".package-info");
        } while (confData.isEmpty() && packageName.indexOf(46) != -1 && !StringUtils.isBlank((String)(packageName = StringUtils.substringBeforeLast((String)packageName, (String)"."))));
    }

    static boolean fetchEntityInfo(final Map<String, String> confData, final Class<?> matchType, ClassLoader classLoader, String className) {
        if (StringUtils.isBlank((String)className)) {
            return false;
        }
        String packageName = className.replace(".", "/");
        InputStream asStream = classLoader.getResourceAsStream(packageName + ".class");
        if (asStream == null) {
            return false;
        }
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        try {
            ClassReader classReader = new ClassReader(asStream);
            classReader.accept(new ClassVisitor(589824){

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    if (!AsmTools.toAsmType((Class)matchType).equals(desc)) {
                        return super.visitAnnotation(desc, visible);
                    }
                    atomicBoolean.set(true);
                    return new TableDefaultVisitor(589824, super.visitAnnotation(desc, visible), confData);
                }
            }, 1);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return atomicBoolean.get();
    }

    protected static TypeHandler<?> createTypeHandler(Class<?> configTypeHandlerType, Class<?> javaType) {
        try {
            Constructor<?> constructor = configTypeHandlerType.getConstructor(Class.class);
            return (TypeHandler)constructor.newInstance(javaType);
        }
        catch (NoSuchMethodException e) {
            return (TypeHandler)ClassUtils.newInstance(configTypeHandlerType);
        }
        catch (ReflectiveOperationException e) {
            throw ExceptionUtils.toRuntime((Throwable)e);
        }
    }

    static {
        CLASS_MAPPING_MAP.put(Iterable.class, ArrayList.class);
        CLASS_MAPPING_MAP.put(Collection.class, ArrayList.class);
        CLASS_MAPPING_MAP.put(List.class, ArrayList.class);
        CLASS_MAPPING_MAP.put(Set.class, LinkedHashSet.class);
        CLASS_MAPPING_MAP.put(Map.class, LinkedHashMap.class);
    }
}

