/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.mapping.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.CollectionUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.function.Property;
import net.hasor.cobble.logging.Logger;
import net.hasor.dbvisitor.keyholder.CreateContext;
import net.hasor.dbvisitor.keyholder.KeySeqHolder;
import net.hasor.dbvisitor.mapping.Column;
import net.hasor.dbvisitor.mapping.ColumnDescribe;
import net.hasor.dbvisitor.mapping.DdlAuto;
import net.hasor.dbvisitor.mapping.Ignore;
import net.hasor.dbvisitor.mapping.IndexDescribe;
import net.hasor.dbvisitor.mapping.KeyTypeEnum;
import net.hasor.dbvisitor.mapping.Table;
import net.hasor.dbvisitor.mapping.TableDescribe;
import net.hasor.dbvisitor.mapping.def.ColumnDef;
import net.hasor.dbvisitor.mapping.def.ColumnDescDef;
import net.hasor.dbvisitor.mapping.def.ColumnDescription;
import net.hasor.dbvisitor.mapping.def.IndexDef;
import net.hasor.dbvisitor.mapping.def.TableDef;
import net.hasor.dbvisitor.mapping.def.TableDescDef;
import net.hasor.dbvisitor.mapping.def.TableDescription;
import net.hasor.dbvisitor.mapping.def.TableMapping;
import net.hasor.dbvisitor.mapping.resolve.AbstractTableMappingResolve;
import net.hasor.dbvisitor.mapping.resolve.MappingOptions;
import net.hasor.dbvisitor.mapping.resolve.TableDefaultInfo;
import net.hasor.dbvisitor.types.TypeHandler;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;
import net.hasor.dbvisitor.types.UnknownTypeHandler;

public class ClassTableMappingResolve
extends AbstractTableMappingResolve<Class<?>> {
    private static final Logger logger = Logger.getLogger(ClassTableMappingResolve.class);
    private static final Map<Class<?>, TableMapping<?>> CACHE_TABLE_MAP = new WeakHashMap();

    public ClassTableMappingResolve(MappingOptions global) {
        super(global);
    }

    public static TableMapping<?> resolveTableMapping(Class<?> entityType, TypeHandlerRegistry typeRegistry) {
        if (CACHE_TABLE_MAP.containsKey(entityType)) {
            return CACHE_TABLE_MAP.get(entityType);
        }
        TableDefaultInfo tableInfo = ClassTableMappingResolve.fetchDefaultInfoByEntity(entityType.getClassLoader(), entityType, true, MappingOptions.buildNew(), Collections.emptyMap());
        TableDef<?> tableMapping = new ClassTableMappingResolve(null).resolveTableAndColumn(tableInfo, entityType, typeRegistry);
        CACHE_TABLE_MAP.put(entityType, tableMapping);
        return tableMapping;
    }

    @Override
    public TableDef<?> resolveTableMapping(Class<?> entityType, MappingOptions refFile, ClassLoader classLoader, TypeHandlerRegistry typeRegistry) {
        MappingOptions use = refFile == null ? this.global : refFile;
        TableDefaultInfo tableInfo = ClassTableMappingResolve.fetchDefaultInfoByEntity(classLoader, entityType, true, use, Collections.emptyMap());
        return this.resolveTableAndColumn(tableInfo, entityType, typeRegistry);
    }

    protected TableDef<?> resolveTable(TableDefaultInfo tableInfo, Class<?> entityType) {
        String catalog = tableInfo.catalog();
        String schema = tableInfo.schema();
        String table = StringUtils.isNotBlank((String)tableInfo.table()) ? tableInfo.table() : (StringUtils.isNotBlank((String)tableInfo.value()) ? tableInfo.value() : "");
        String characterSet = tableInfo.characterSet();
        String collation = tableInfo.collation();
        String comment = tableInfo.comment();
        String other = tableInfo.other();
        DdlAuto ddlAuto = tableInfo.ddlAuto();
        boolean autoProperty = tableInfo.autoMapping();
        boolean useDelimited = tableInfo.useDelimited();
        boolean caseInsensitive = tableInfo.caseInsensitive();
        boolean camelCase = tableInfo.mapUnderscoreToCamelCase();
        TableDef tableDef = new TableDef(catalog, schema, table, entityType, autoProperty, useDelimited, caseInsensitive, camelCase);
        if (StringUtils.isBlank((String)characterSet) && StringUtils.isBlank((String)collation) && StringUtils.isBlank((String)comment) && StringUtils.isBlank((String)other)) {
            tableDef.setDescription(this.parseDesc(ddlAuto, entityType.getAnnotation(TableDescribe.class)));
        } else {
            tableDef.setDescription(this.parseDesc(ddlAuto, tableInfo));
        }
        IndexDescribe[] indexDescribes = (IndexDescribe[])entityType.getAnnotationsByType(IndexDescribe.class);
        if (indexDescribes.length > 0) {
            for (IndexDescribe idx : indexDescribes) {
                String idxName = idx.name();
                String idxComment = idx.comment();
                String idxOther = idx.other();
                List<String> columns = Arrays.stream(idx.columns()).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(columns)) {
                    throw new IllegalArgumentException("entityType " + entityType + " @IndexDescribe columns is empty.");
                }
                if (StringUtils.isBlank((String)idxName)) {
                    throw new IllegalArgumentException("entityType " + tableDef.getTable() + " missing index name.");
                }
                IndexDef idxDef = new IndexDef();
                idxDef.setName(idxName);
                idxDef.setColumns(columns);
                idxDef.setUnique(idx.unique());
                idxDef.setComment(StringUtils.isBlank((String)idxComment) ? null : idxComment);
                idxDef.setOther(StringUtils.isBlank((String)idxOther) ? null : idxOther);
                tableDef.addIndexDescription(idxDef);
            }
        }
        return tableDef;
    }

    protected TableDef<?> resolveTableAndColumn(TableDefaultInfo tableInfo, Class<?> entityType, TypeHandlerRegistry typeRegistry) {
        TableDef<?> def = this.resolveTable(tableInfo, entityType);
        Map properties = BeanUtils.getPropertyFunc(entityType);
        ArrayList<String> names = new ArrayList<String>();
        List fields = BeanUtils.getALLFieldToList(entityType).stream().map(Field::getName).collect(Collectors.toList());
        for (String name : fields) {
            if (!properties.containsKey(name)) continue;
            names.add(name);
        }
        for (String name : properties.keySet()) {
            if (names.contains(name)) continue;
            names.add(name);
        }
        for (String name : names) {
            Property property = (Property)properties.get(name);
            Class type = BeanUtils.getPropertyType((Property)property);
            this.resolveProperty(def, name, type, property, typeRegistry, tableInfo);
        }
        return def;
    }

    protected void resolveProperty(TableDef<?> tableDef, String name, Class<?> type, Property handler, TypeHandlerRegistry typeRegistry, Table tableInfo) {
        TypeHandler<Object> typeHandler;
        int jdbcType;
        String column;
        Annotation[] annotations = BeanUtils.getPropertyAnnotation((Property)handler);
        Column info = null;
        ColumnDescribe infoDesc = null;
        for (Annotation a : annotations) {
            if (a instanceof Column) {
                info = (Column)a;
                continue;
            }
            if (a instanceof ColumnDescribe) {
                infoDesc = (ColumnDescribe)a;
                continue;
            }
            if (!(a instanceof Ignore)) continue;
            return;
        }
        if (info != null) {
            String string = column = StringUtils.isNotBlank((String)info.name()) ? info.name() : info.value();
            if (StringUtils.isBlank((String)column)) {
                column = ClassTableMappingResolve.hump2Line(name, tableInfo.mapUnderscoreToCamelCase());
            }
            Class<?> javaType = info.specialJavaType() == Object.class ? CLASS_MAPPING_MAP.getOrDefault(type, type) : info.specialJavaType();
            jdbcType = info.jdbcType();
            if (info.jdbcType() == 2000) {
                jdbcType = TypeHandlerRegistry.toSqlType(javaType);
            }
            typeHandler = info.typeHandler() == UnknownTypeHandler.class ? typeRegistry.getTypeHandler(javaType, jdbcType) : ClassTableMappingResolve.createTypeHandler(info.typeHandler(), javaType);
            boolean insert = info.insert();
            boolean update = info.update();
            boolean primary = info.primary();
            String selectTemplate = info.selectTemplate();
            String insertTemplate = info.insertTemplate();
            String setColTemplate = info.setColTemplate();
            String setValueTemplate = info.setValueTemplate();
            String whereColTemplate = info.whereColTemplate();
            String whereValueTemplate = info.whereValueTemplate();
            ColumnDef colDef = new ColumnDef(column, name, jdbcType, javaType, typeHandler, handler, insert, update, primary, selectTemplate, insertTemplate, setColTemplate, setValueTemplate, whereColTemplate, whereValueTemplate);
            colDef.setDescription(this.parseDesc(infoDesc));
            colDef.setKeySeqHolder(this.resolveKeyType(tableDef, colDef, info.keyType(), annotations, typeRegistry));
            tableDef.addMapping(colDef);
        } else if (tableDef.isAutoProperty()) {
            column = ClassTableMappingResolve.hump2Line(name, tableInfo.mapUnderscoreToCamelCase());
            Class<?> javaType = CLASS_MAPPING_MAP.getOrDefault(type, type);
            jdbcType = TypeHandlerRegistry.toSqlType(javaType);
            typeHandler = typeRegistry.getTypeHandler(javaType, jdbcType);
            tableDef.addMapping(new ColumnDef(column, name, jdbcType, javaType, typeHandler, handler, true, true, false));
        }
    }

    private TableDescription parseDesc(DdlAuto ddlAuto, TableDescribe tableDesc) {
        if (tableDesc == null) {
            return null;
        }
        TableDescDef descDef = new TableDescDef();
        descDef.setDdlAuto(ddlAuto);
        descDef.setCharacterSet(tableDesc.characterSet());
        descDef.setCollation(tableDesc.collation());
        descDef.setComment(tableDesc.comment());
        descDef.setOther(tableDesc.other());
        return descDef;
    }

    private ColumnDescription parseDesc(ColumnDescribe columnDesc) {
        if (columnDesc == null) {
            return null;
        }
        ColumnDescDef descDef = new ColumnDescDef();
        descDef.setSqlType(columnDesc.sqlType());
        descDef.setLength(columnDesc.length());
        descDef.setPrecision(columnDesc.precision());
        descDef.setScale(columnDesc.scale());
        descDef.setCharacterSet(columnDesc.characterSet());
        descDef.setCollation(columnDesc.collation());
        descDef.setScale(columnDesc.scale());
        descDef.setNullable(columnDesc.nullable());
        descDef.setDefault(columnDesc.defaultValue());
        descDef.setComment(columnDesc.comment());
        descDef.setOther(columnDesc.other());
        return descDef;
    }

    private KeySeqHolder resolveKeyType(TableDef<?> tableDef, ColumnDef colDef, KeyTypeEnum keyTypeEnum, Annotation[] allAnnotations, TypeHandlerRegistry typeRegistry) {
        if (keyTypeEnum == KeyTypeEnum.None) {
            return null;
        }
        HashMap<String, Object> envConfig = new HashMap<String, Object>();
        if (allAnnotations != null) {
            for (Annotation anno : allAnnotations) {
                envConfig.put(anno.annotationType().getName(), anno);
            }
        }
        return keyTypeEnum.createHolder(new CreateContext(this.global, typeRegistry, tableDef, colDef, envConfig));
    }
}

