/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.mapping.resolve;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.hasor.cobble.BeanUtils;
import net.hasor.cobble.ClassUtils;
import net.hasor.cobble.CollectionUtils;
import net.hasor.cobble.NumberUtils;
import net.hasor.cobble.StringUtils;
import net.hasor.cobble.convert.ConverterUtils;
import net.hasor.cobble.function.Property;
import net.hasor.cobble.logging.Logger;
import net.hasor.dbvisitor.keyholder.CreateContext;
import net.hasor.dbvisitor.keyholder.KeySeq;
import net.hasor.dbvisitor.keyholder.KeySeqHolder;
import net.hasor.dbvisitor.keyholder.KeySeqHolderFactory;
import net.hasor.dbvisitor.mapping.KeyTypeEnum;
import net.hasor.dbvisitor.mapping.def.ColumnDef;
import net.hasor.dbvisitor.mapping.def.ColumnDescDef;
import net.hasor.dbvisitor.mapping.def.ColumnMapping;
import net.hasor.dbvisitor.mapping.def.IndexDef;
import net.hasor.dbvisitor.mapping.def.TableDef;
import net.hasor.dbvisitor.mapping.resolve.AbstractTableMappingResolve;
import net.hasor.dbvisitor.mapping.resolve.ClassTableMappingResolve;
import net.hasor.dbvisitor.mapping.resolve.MappingOptions;
import net.hasor.dbvisitor.mapping.resolve.TableDefaultInfo;
import net.hasor.dbvisitor.types.TypeHandler;
import net.hasor.dbvisitor.types.TypeHandlerRegistry;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlTableMappingResolve
extends AbstractTableMappingResolve<Node> {
    private static final Logger logger = Logger.getLogger(XmlTableMappingResolve.class);
    private final ClassTableMappingResolve classTableMappingResolve;

    public XmlTableMappingResolve(MappingOptions global) {
        super(global);
        this.classTableMappingResolve = new ClassTableMappingResolve(this.global);
    }

    protected boolean hasAnyMapping(NodeList childNodes) {
        int len = childNodes.getLength();
        for (int i = 0; i < len; ++i) {
            String elementName;
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1 || !"id".equalsIgnoreCase(elementName = node.getNodeName().toLowerCase().trim()) && !"result".equalsIgnoreCase(elementName) && !"mapping".equalsIgnoreCase(elementName)) continue;
            return true;
        }
        return false;
    }

    private static String strFromXmlAttribute(NamedNodeMap nodeAttributes, String key) {
        Node node = nodeAttributes.getNamedItem(key);
        return node != null ? node.getNodeValue() : null;
    }

    @Override
    public TableDef<?> resolveTableMapping(Node refData, MappingOptions refFile, ClassLoader classLoader, TypeHandlerRegistry typeRegistry) throws ReflectiveOperationException {
        TableDef<?> tableDef;
        NodeList childNodes = refData.getChildNodes();
        NamedNodeMap nodeAttributes = refData.getAttributes();
        Class<?> entityType = classLoader.loadClass(XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "type"));
        HashMap<String, String> overwriteData = new HashMap<String, String>();
        overwriteData.compute("catalog", (key, oldValue) -> XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "catalog"));
        overwriteData.compute("schema", (key, oldValue) -> XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "schema"));
        overwriteData.compute("table", (key, oldValue) -> XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "table"));
        overwriteData.compute("autoMapping", (key, oldValue) -> XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "autoMapping"));
        overwriteData.compute("useDelimited", (key, oldValue) -> XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "useDelimited"));
        overwriteData.compute("mapUnderscoreToCamelCase", (key, oldValue) -> XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "mapUnderscoreToCamelCase"));
        overwriteData.compute("caseInsensitive", (key, oldValue) -> XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "caseInsensitive"));
        overwriteData.compute("character-set", (key, oldValue) -> XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "character-set"));
        overwriteData.compute("collation", (key, oldValue) -> XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "collation"));
        overwriteData.compute("comment", (key, oldValue) -> XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "comment"));
        overwriteData.compute("other", (key, oldValue) -> XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "other"));
        overwriteData.compute("ddlAuto", (key, oldValue) -> XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "ddlAuto"));
        MappingOptions use = refFile == null ? this.global : refFile;
        TableDefaultInfo tableInfo = XmlTableMappingResolve.fetchDefaultInfoByEntity(classLoader, entityType, false, use, overwriteData);
        if (this.hasAnyMapping(childNodes)) {
            tableDef = this.classTableMappingResolve.resolveTable(tableInfo, entityType);
            this.loadTableMapping(tableDef, refData, classLoader, typeRegistry);
        } else {
            tableDef = this.classTableMappingResolve.resolveTableAndColumn(tableInfo, entityType, typeRegistry);
        }
        boolean hasAnyIndex = false;
        int len = childNodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            if (!hasAnyIndex) {
                tableDef.getIndexes().clear();
            }
            hasAnyIndex = true;
            String elementName = node.getNodeName().toLowerCase().trim();
            if (!"index".equalsIgnoreCase(elementName)) continue;
            this.loadTableIndex(tableDef, node);
        }
        return tableDef;
    }

    private void loadTableMapping(TableDef<?> tableDef, Node refData, ClassLoader classLoader, TypeHandlerRegistry typeRegistry) throws ReflectiveOperationException {
        Map propertyMap = BeanUtils.getPropertyFunc(tableDef.entityType());
        NodeList childNodes = refData.getChildNodes();
        int len = childNodes.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            String elementName = node.getNodeName().toLowerCase().trim();
            if (StringUtils.isBlank((String)elementName)) {
                throw new UnsupportedOperationException("tag name is Empty.");
            }
            ColumnMapping columnMapping = null;
            if ("id".equalsIgnoreCase(elementName)) {
                columnMapping = this.resolveProperty(tableDef, true, node, propertyMap, classLoader, typeRegistry);
            } else if ("result".equalsIgnoreCase(elementName) || "mapping".equalsIgnoreCase(elementName)) {
                columnMapping = this.resolveProperty(tableDef, false, node, propertyMap, classLoader, typeRegistry);
            } else {
                if ("index".equalsIgnoreCase(elementName)) continue;
                throw new UnsupportedOperationException("tag <" + elementName + "> Unsupported.");
            }
            tableDef.addMapping(columnMapping);
        }
    }

    private void loadTableIndex(TableDef<?> tableDef, Node refData) {
        NamedNodeMap nodeAttributes = refData.getAttributes();
        String idxName = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "name");
        String columns = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "columns");
        String idxUnique = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "unique");
        String idxComment = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "comment");
        String idxOther = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "other");
        if (StringUtils.isBlank((String)idxName)) {
            throw new IllegalArgumentException("entityType " + tableDef.getTable() + " missing index name.");
        }
        ArrayList<String> columnList = null;
        if (StringUtils.isNotBlank((String)columns)) {
            columnList = Arrays.stream(columns.split(",")).filter(StringUtils::isNotBlank).map(String::trim).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(columnList)) {
            columnList = new ArrayList();
            NodeList columnNodes = refData.getChildNodes();
            int len = columnNodes.getLength();
            for (int i = 0; i < len; ++i) {
                String columnName;
                Node colNode = columnNodes.item(i);
                if (colNode.getNodeType() != 1 || !StringUtils.equalsIgnoreCase((String)colNode.getNodeName(), (String)"column") || !StringUtils.isNotBlank((String)(columnName = colNode.getTextContent().trim()))) continue;
                columnList.add(columnName);
            }
            if (CollectionUtils.isEmpty(columnList)) {
                throw new IllegalArgumentException("entityType " + tableDef.getTable() + " columns is empty.");
            }
        }
        IndexDef idxDef = new IndexDef();
        idxDef.setName(idxName);
        idxDef.setColumns(columnList);
        idxDef.setUnique((Boolean)ConverterUtils.convert((String)idxUnique, Boolean.TYPE));
        idxDef.setComment(StringUtils.isBlank((String)idxComment) ? null : idxComment);
        idxDef.setOther(StringUtils.isBlank((String)idxOther) ? null : idxOther);
        tableDef.addIndexDescription(idxDef);
    }

    private ColumnMapping resolveProperty(TableDef<?> tableDef, boolean asPrimaryKey, Node xmlNode, Map<String, Property> propertyMap, ClassLoader classLoader, TypeHandlerRegistry typeRegistry) throws ReflectiveOperationException {
        NamedNodeMap nodeAttributes = xmlNode.getAttributes();
        String column = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "column");
        String property = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "property");
        String javaType = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "javaType");
        String jdbcType = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "jdbcType");
        String typeHandler = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "typeHandler");
        String keyType = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "keyType");
        String insertStr = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "insert");
        String updateStr = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "update");
        String selectTemplate = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "selectTemplate");
        String insertTemplate = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "insertTemplate");
        String setColTemplate = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "setColTemplate");
        String setValueTemplate = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "setValueTemplate");
        String whereColTemplate = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "whereColTemplate");
        String whereValueTemplate = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "whereValueTemplate");
        String sqlType = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "sqlType");
        String length = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "length");
        String precision = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "precision");
        String scale = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "scale");
        String characterSet = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "character-set");
        String collation = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "collation");
        String nullableStr = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "nullable");
        String defaultValue = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "default");
        String comment = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "comment");
        String other = XmlTableMappingResolve.strFromXmlAttribute(nodeAttributes, "other");
        if (!propertyMap.containsKey(property)) {
            throw new NoSuchFieldException("property '" + property + "' undefined. location= " + XmlTableMappingResolve.logMessage(xmlNode));
        }
        Property propertyHandler = propertyMap.get(property);
        Class<?> columnJavaType = XmlTableMappingResolve.resolveJavaType(xmlNode, javaType, propertyHandler, classLoader);
        Integer columnJdbcType = XmlTableMappingResolve.resolveJdbcType(jdbcType, columnJavaType, typeRegistry);
        TypeHandler<?> columnTypeHandler = XmlTableMappingResolve.resolveTypeHandler(columnJavaType, columnJdbcType, classLoader, typeHandler, typeRegistry);
        boolean insert = StringUtils.isBlank((String)insertStr) || Boolean.parseBoolean(insertStr);
        boolean update = StringUtils.isBlank((String)updateStr) || Boolean.parseBoolean(updateStr);
        boolean nullable = StringUtils.isBlank((String)nullableStr) || Boolean.parseBoolean(updateStr);
        ColumnDef colDef = new ColumnDef(column, property, columnJdbcType, columnJavaType, columnTypeHandler, propertyHandler, insert, update, asPrimaryKey, selectTemplate, insertTemplate, setColTemplate, setValueTemplate, whereColTemplate, whereValueTemplate);
        if (sqlType == null && length == null && precision == null && scale == null && characterSet == null && collation == null && defaultValue == null && comment == null && other == null) {
            colDef.setDescription(null);
        } else {
            nullable = !asPrimaryKey && nullable;
            colDef.setDescription(new ColumnDescDef(sqlType, length, precision, scale, characterSet, collation, nullable, defaultValue, comment, other));
        }
        colDef.setKeySeqHolder(this.resolveKeyType(tableDef, colDef, keyType, classLoader, typeRegistry));
        return colDef;
    }

    private KeySeqHolder resolveKeyType(TableDef<?> tableDef, ColumnDef colDef, String keyType, ClassLoader classLoader, TypeHandlerRegistry typeRegistry) throws ReflectiveOperationException {
        if (StringUtils.isBlank((String)keyType)) {
            return null;
        }
        KeyTypeEnum keyTypeEnum = KeyTypeEnum.valueOfCode(keyType);
        if (keyTypeEnum != null) {
            switch (keyTypeEnum) {
                case Auto: 
                case UUID32: 
                case UUID36: {
                    return keyTypeEnum.createHolder(new CreateContext(this.global, typeRegistry, tableDef, colDef, Collections.emptyMap()));
                }
            }
            return null;
        }
        if (StringUtils.startsWithIgnoreCase((String)keyType, (String)"KeySeq::")) {
            keyType = keyType.substring("KeySeq::".length());
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put(KeySeq.class.getName(), new KeySeqImpl(keyType));
            return KeyTypeEnum.Sequence.createHolder(new CreateContext(this.global, typeRegistry, tableDef, colDef, context));
        }
        Class<?> aClass = classLoader.loadClass(keyType);
        KeySeqHolderFactory holderFactory = (KeySeqHolderFactory)aClass.newInstance();
        return holderFactory.createHolder(new CreateContext(this.global, typeRegistry, tableDef, colDef, Collections.emptyMap()));
    }

    private static Class<?> resolveJavaType(Node xmlNode, String javaType, Property property, ClassLoader classLoader) throws ReflectiveOperationException {
        Class columnJavaType = BeanUtils.getPropertyType((Property)property);
        if (StringUtils.isNotBlank((String)javaType)) {
            try {
                Class configColumnJavaType = ClassUtils.getClass((ClassLoader)classLoader, (String)javaType);
                if (!configColumnJavaType.isAssignableFrom(columnJavaType)) {
                    String errorMessage = configColumnJavaType.getName() + " is not a subclass of " + columnJavaType.getName() + ", location= " + XmlTableMappingResolve.logMessage(xmlNode);
                    throw new ClassCastException(errorMessage);
                }
                columnJavaType = configColumnJavaType;
            }
            catch (ClassNotFoundException e) {
                String errorMessage = javaType + ", location " + XmlTableMappingResolve.logMessage(xmlNode);
                throw new ClassNotFoundException(errorMessage);
            }
        }
        return columnJavaType;
    }

    private static Integer resolveJdbcType(String jdbcType, Class<?> javaType, TypeHandlerRegistry typeRegistry) {
        if (NumberUtils.isNumber((String)jdbcType)) {
            return NumberUtils.createInteger((String)jdbcType);
        }
        return TypeHandlerRegistry.toSqlType(javaType);
    }

    private static TypeHandler<?> resolveTypeHandler(Class<?> javaType, Integer jdbcType, ClassLoader classLoader, String typeHandler, TypeHandlerRegistry typeRegistry) throws ClassNotFoundException {
        if (StringUtils.isNotBlank((String)typeHandler)) {
            Class configTypeHandlerType = ClassUtils.getClass((ClassLoader)classLoader, (String)typeHandler);
            if (typeRegistry.hasTypeHandler(configTypeHandlerType)) {
                return typeRegistry.getTypeHandler(configTypeHandlerType);
            }
            if (TypeHandler.class.isAssignableFrom(configTypeHandlerType)) {
                return XmlTableMappingResolve.createTypeHandler(configTypeHandlerType, javaType);
            }
            throw new ClassCastException(configTypeHandlerType.getName() + " is not a subclass of " + TypeHandler.class.getName());
        }
        if (typeRegistry.hasTypeHandler(javaType, jdbcType)) {
            return typeRegistry.getTypeHandler(javaType, jdbcType);
        }
        if (typeRegistry.hasTypeHandler(javaType)) {
            return typeRegistry.getTypeHandler(javaType);
        }
        if (typeRegistry.hasTypeHandler(jdbcType)) {
            return typeRegistry.getTypeHandler(jdbcType);
        }
        return typeRegistry.getDefaultTypeHandler();
    }

    private static String logMessage(Node xmlNode) {
        Node xpath = xmlNode;
        StringBuilder xpathString = new StringBuilder();
        do {
            if (xpathString.length() > 0) {
                xpathString.insert(0, "/");
            }
            xpathString.insert(0, xpath.getNodeName());
        } while ((xpath = xpath.getParentNode()).getParentNode() != null);
        Element documentElement = xmlNode.getOwnerDocument().getDocumentElement();
        NamedNodeMap docAttr = documentElement.getAttributes();
        Node spaceNode = docAttr.getNamedItem("namespace");
        xpathString.insert(0, "namespace=" + (spaceNode != null ? spaceNode.getNodeValue() : null) + ", ");
        NamedNodeMap mappingNodeAttr = xmlNode.getParentNode().getAttributes();
        Node idNode = mappingNodeAttr.getNamedItem("id");
        Node typeNode = mappingNodeAttr.getNamedItem("type");
        xpathString.append("[");
        xpathString.append("@id=" + (idNode != null ? idNode.getNodeValue() : null) + ", ");
        xpathString.append("@type=" + (typeNode != null ? typeNode.getNodeValue() : null));
        xpathString.append("]");
        return xpathString.toString();
    }

    private static class KeySeqImpl
    implements KeySeq {
        private final String keyType;

        public KeySeqImpl(String keyType) {
            this.keyType = keyType;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return KeySeq.class;
        }

        @Override
        public String value() {
            return this.keyType;
        }
    }
}

