/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.page;

import net.hasor.dbvisitor.page.Page;

public class PageObject
implements Page {
    private long totalCount = 0L;
    private long pageSize = 0L;
    private long currentPage = 0L;
    private long pageNumberOffset = 0L;
    private boolean refreshTotalCount = false;

    public PageObject() {
    }

    public PageObject(long pageSize, long totalCount) {
        this.pageSize = pageSize;
        this.totalCount = totalCount;
    }

    @Override
    public long getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(long pageSize) {
        this.pageSize = Math.max(pageSize, 0L);
    }

    @Override
    public long getCurrentPage() {
        if (this.pageSize > 0L) {
            return this.currentPage + this.pageNumberOffset;
        }
        return this.pageNumberOffset;
    }

    @Override
    public void setCurrentPage(long currentPage) {
        this.currentPage = currentPage <= this.pageNumberOffset ? 0L : currentPage - this.pageNumberOffset;
    }

    @Override
    public long getPageNumberOffset() {
        return this.pageNumberOffset;
    }

    @Override
    public void setPageNumberOffset(long pageNumberOffset) {
        this.pageNumberOffset = Math.max(pageNumberOffset, 0L);
    }

    @Override
    public boolean isRefreshTotalCount() {
        return this.refreshTotalCount;
    }

    public void setRefreshTotalCount(boolean refreshTotalCount) {
        this.refreshTotalCount = refreshTotalCount;
    }

    @Override
    public void refreshTotalCount() {
        this.setRefreshTotalCount(true);
    }

    @Override
    public long getFirstRecordPosition() {
        long pgSize = this.getPageSize();
        if (pgSize <= 0L) {
            return 0L;
        }
        return pgSize * this.currentPage;
    }

    @Override
    public long getTotalPage() {
        long pgSize = this.getPageSize();
        if (pgSize > 0L) {
            long totalCount = this.getTotalCount();
            if (totalCount == 0L) {
                return this.pageNumberOffset;
            }
            long result = totalCount / pgSize;
            if (totalCount % pgSize != 0L) {
                ++result;
            }
            return result + this.pageNumberOffset;
        }
        long totalCount = this.getTotalCount();
        if (totalCount > 0L) {
            return this.pageNumberOffset + 1L;
        }
        return this.pageNumberOffset;
    }

    @Override
    public long getTotalCount() {
        return this.totalCount;
    }

    @Override
    public void setTotalCount(long totalCount) {
        this.totalCount = totalCount;
    }
}

