/*
 * Decompiled with CFR 0.152.
 */
package net.hasor.dbvisitor.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public interface ConnectionHolder {
    public void requested();

    public void released() throws SQLException;

    public int getRefCount();

    public Connection getConnection() throws SQLException;

    public DataSource getDataSource() throws SQLException;

    public boolean isOpen();

    default public boolean hasTransaction() throws SQLException {
        Connection conn = this.getConnection();
        if (conn == null) {
            return false;
        }
        return !conn.getAutoCommit();
    }

    default public void setTransaction() throws SQLException {
        Connection conn = this.getConnection();
        if (conn == null) {
            throw new IllegalStateException("connection is close.");
        }
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
    }

    default public void cancelTransaction() throws SQLException {
        Connection conn = this.getConnection();
        if (conn == null) {
            throw new IllegalStateException("connection is close.");
        }
        if (!conn.getAutoCommit()) {
            conn.setAutoCommit(true);
        }
    }
}

